/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.BackgroundRenderPass;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.ForegroundRenderPass;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.TriangleStripArray;
import org.xith3d.scenegraph.View;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Test of the Xith3D Background Geom capabilities (basic skybox)"}, authors={"William Denniss"})
public class BackgroundGeomTest
extends Xith3DTest {
    private Xith3DEnvironment env = new Xith3DEnvironment(1.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
    private int x = 10;
    private int viewmode = 1;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case _0: {
                this.viewmode = 0;
                break;
            }
            case _1: {
                this.viewmode = 1;
                break;
            }
            case _2: {
                this.viewmode = 2;
                break;
            }
            case _3: {
                this.viewmode = 3;
                break;
            }
            case _4: {
                this.viewmode = 4;
                break;
            }
            case Q: {
                --this.x;
                break;
            }
            case A: {
                ++this.x;
            }
        }
    }

    public void onRenderLoopStarted() {
        System.out.println("Keys 0 to 4 change the camera.  If camera 1 is selected, 'q' and 'a' can be used to change the x-coordinate of the camera location");
    }

    public void onRenderLoopStopped(long gameTime, UpdatingThread.TimingMode timingMode, float averageFPS) {
        System.out.println("done frame speed test at " + (int)averageFPS + " fps");
        System.out.println("there are " + this.env.getCanvas().getPeer().getTriangles() + " triangles in scene");
        System.out.println("rendering " + (float)this.env.getCanvas().getPeer().getTriangles() * averageFPS + " triangles/sec");
        System.out.println("   Num frames = " + this.getIterationsCount());
        System.out.println("   Delta ms = " + timingMode.getMilliSeconds(gameTime));
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        if (this.viewmode == 0) {
            this.env.getView().getTransform().lookAt(new Vector3f(5.0f, 0.0f, 5.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f));
        } else if (this.viewmode == 1) {
            this.env.getView().getTransform().lookAt(new Vector3f(this.x, 0.0f, 3.0f), new Vector3f(0.0f, -5.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f));
        } else if (this.viewmode == 2) {
            this.env.getView().getTransform().lookAt(new Vector3f(2.0f, 0.0f, 2.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f));
        } else if (this.viewmode == 3) {
            this.env.getView().getTransform().lookAt(new Vector3f(-1.0f, 0.0f, 2.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f));
        } else if (this.viewmode == 4) {
            this.env.getView().getTransform().lookAt(new Vector3f(50.0f, 0.0f, 2.0f), new Vector3f(1.0f, 4.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f));
        }
    }

    private void init(Xith3DEnvironment env) {
        BranchGroup b = env.addRenderPass(BackgroundRenderPass.createPerspective(View.CameraMode.VIEW_FIXED_POSITION));
        BranchGroup m = env.addRenderPass(RenderPass.createPerspective());
        BranchGroup f = env.addRenderPass(ForegroundRenderPass.createPerspective(View.CameraMode.VIEW_FIXED));
        Shape3D sh = new Shape3D();
        Point3f[] pts = new Point3f[]{new Point3f(-100.0f, -100.0f, 100.0f), new Point3f(-100.0f, -100.0f, -100.0f), new Point3f(100.0f, -100.0f, -100.0f), new Point3f(100.0f, -100.0f, 100.0f), new Point3f(0.0f, 100.0f, 0.0f)};
        Tuple3f[] coords = new Point3f[]{pts[0], pts[2], pts[1], pts[0], pts[3], pts[2], pts[0], pts[4], pts[1], pts[1], pts[4], pts[2], pts[2], pts[4], pts[3], pts[3], pts[4], pts[0]};
        TexCoord2f[] texCoords = new TexCoord2f[]{new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f)};
        TriangleArray ta = new TriangleArray(coords.length);
        ta.setCoordinates(0, coords);
        ta.setTextureCoordinates(0, 0, texCoords);
        ta.calculateFaceNormals();
        sh.setGeometry(ta);
        Texture2D texture = TextureLoader.getInstance().getTexture("stone.jpg");
        Appearance a = new Appearance();
        a.setRenderingAttributes(new RenderingAttributes());
        a.getRenderingAttributes().setDepthBufferWriteEnabled(false);
        a.setTexture(texture);
        sh.setAppearance(a);
        b.addChild(sh);
        sh = new Shape3D();
        pts = new Point3f[]{new Point3f(-1.0f, -1.0f, 1.0f), new Point3f(-1.0f, -1.0f, -1.0f), new Point3f(1.0f, -1.0f, -1.0f), new Point3f(1.0f, -1.0f, 1.0f), new Point3f(1.0f, 1.0f, 1.0f)};
        coords = new Point3f[]{pts[0], pts[2], pts[1], pts[0], pts[3], pts[2], pts[0], pts[4], pts[1], pts[1], pts[4], pts[2], pts[2], pts[4], pts[3], pts[3], pts[4], pts[0]};
        Colorf[] colors = new Colorf[]{new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 0.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 0.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 0.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 0.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 0.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 0.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f)};
        ta = new TriangleArray(coords.length);
        ta.setColors(0, colors);
        ta.setCoordinates(0, coords);
        ta.calculateFaceNormals();
        sh.setGeometry(ta);
        Appearance a2 = new Appearance();
        sh.setAppearance(a2);
        m.addChild(sh);
        float depth = -2.5f;
        float width = 0.06f;
        float height = 1.0f;
        float x = 2.0f;
        float y = 0.3f;
        TriangleStripArray geometry = new TriangleStripArray(4);
        Appearance appearance = new Appearance();
        TexCoord2f[] textureCoordinates = new TexCoord2f[]{new TexCoord2f(0.0f, 0.35f), new TexCoord2f(0.04f, 0.35f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.04f, 1.0f)};
        Tuple3f[] vertices = new Point3f[]{new Point3f(-width + x, -height + y, depth), new Point3f(width + x, -height + y, depth), new Point3f(-width + x, height + y, depth), new Point3f(width + x, height + y, depth)};
        appearance.setTexture("hud.png");
        appearance.setRenderingAttributes(new RenderingAttributes());
        appearance.setTransparencyAttributes(new TransparencyAttributes(TransparencyAttributes.BLENDED, 0.1f));
        geometry.setCoordinates(0, vertices);
        geometry.setTextureCoordinates(0, 0, textureCoordinates);
        f.addChild(new Shape3D(geometry, appearance));
        env.addPerspectiveBranch(m);
    }

    public BackgroundGeomTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.init(this.env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        this.env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        BackgroundGeomTest test = new BackgroundGeomTest(BackgroundGeomTest.parseCommandLine(args));
        test.begin();
    }
}

