/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.scenegraph.primitives.Torus;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Test for Xith3D's bumpmapping capabilities"}, authors={"Marvin Froehlich (aka Qudus)"})
public class BumpMappingTest
extends Xith3DTest {
    private PointLight light;
    private Shape3D lightAvatar;
    private Vector3f lightTranslation;
    private RotatableGroup lightRotator;
    private Point3f tmp = new Point3f();

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                if (this.lightRotator.isAnimating()) {
                    this.lightRotator.stopAnimation();
                    break;
                }
                this.lightRotator.startAnimation(this.getGameTime(), this.getTimingMode());
            }
        }
    }

    private BranchGroup createScene(Animator animator) {
        BranchGroup scene = new BranchGroup();
        Torus torus = new Torus(2.0f, 0.375f, 48, 48, 11, false, 2);
        Texture2D tex = TextureLoader.getInstance().getTexture("lena.dds", TextureFormat.RGB, Texture.MipmapMode.MULTI_LEVEL_MIPMAP);
        torus.getAppearance(true).setTexture(tex);
        torus.setBumpMappingEnabled(true, "normalmap.bmp");
        TransformGroup tg = new TransformGroup();
        scene.addChild(tg);
        tg.addChild(torus);
        this.lightTranslation = new Vector3f(3.0f, 0.0f, 2.0f);
        this.light = new PointLight();
        this.light.setAttenuation(1.0f, 0.0f, 0.0f);
        scene.addChild(this.light);
        this.lightAvatar = new Sphere(0.02f, 8, 8, Colorf.YELLOW);
        StaticTransform.translate(this.lightAvatar, (Tuple3f)this.lightTranslation);
        this.lightRotator = new RotatableGroup(new TransformationDirectives(0.0f, 0.0f, 0.25f));
        this.lightRotator.addChild(this.lightAvatar);
        scene.addChild(this.lightRotator);
        animator.addAnimatableObject(this.lightRotator);
        return scene;
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        this.tmp.set((TupleNf)this.lightTranslation);
        this.lightAvatar.getWorldTransform().transform(this.tmp);
        this.light.setLocation(this.tmp);
    }

    public BumpMappingTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL();
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createScene(this.getAnimator()));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        FirstPersonInputHandler fpih = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)canvas, arguments.getMouseYInverted());
        fpih.getBindingsManager().unbind(Keys.SPACE);
        InputSystem.getInstance().addInputHandler(fpih);
    }

    public static void main(String[] args) throws Throwable {
        BumpMappingTest test = new BumpMappingTest(BumpMappingTest.parseCommandLine(args));
        test.begin();
    }
}

