/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import java.awt.Font;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseWheelEvent;
import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Renderer;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Transform;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.FixedSizedBillboard;
import org.xith3d.scenegraph.primitives.FixedSizedBillboardFactory;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.interpolate.AngleInterpolater;

@Xith3DTest.Description(fulltext={"Demonstrates, how FixedSizedBillboards work."}, authors={"Herve"})
public class FixedSizedBillboardTest
extends Xith3DTest {
    private AngleInterpolater angleInterpol;
    private Tuple3f eyePos = new Point3f(0.0f, 0.0f, 20.0f);
    private Tuple3f focus = new Point3f(0.0f, 0.0f, 0.0f);
    private Tuple3f vecUp = new Point3f(0.0f, 1.0f, 0.0f);
    private View view;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case F1: {
                this.view.getCanvas3D(0).takeScreenshot(false);
            }
        }
    }

    public void onMouseWheelMoved(MouseWheelEvent e, int wheelDelta) {
        this.eyePos.addZ(wheelDelta);
    }

    protected void onRenderLoopStarted() {
        super.onRenderLoopStarted();
        this.angleInterpol = new AngleInterpolater(0.0f, 1.5707964f, 0.0f, (float)Math.PI * 2, true);
        this.angleInterpol.startIncreasing(this.getGameMicroTime());
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        float angle = this.angleInterpol.getValue(timingMode.getMicroSeconds(gameTime));
        this.eyePos.set(5.0f * FastMath.cos(angle), 5.0f * FastMath.sin(angle), this.eyePos.getZ());
        this.view.lookAt(this.eyePos, this.focus, this.vecUp);
    }

    private void addCubes(BranchGroup root) {
        Cube cube1 = new Cube(3.0f, "stone.jpg");
        Cube cube2 = new Cube(3.0f, "grass.jpg");
        Cube cube3 = new Cube(3.0f, "jplogo.png");
        TransformGroup tg1 = new TransformGroup(new Transform3D(-5.0f, 0.0f, 0.0f));
        TransformGroup tg2 = new TransformGroup(new Transform3D(0.0f, 0.0f, 0.0f));
        TransformGroup tg3 = new TransformGroup(new Transform3D(5.0f, 0.0f, 0.0f));
        tg1.addChild(cube1);
        tg2.addChild(cube2);
        tg3.addChild(cube3);
        root.addChild(tg1);
        root.addChild(tg2);
        root.addChild(tg3);
    }

    private FixedSizedBillboard createTextBillboard() {
        String text = "Hello, I am a non-zoomable text.\nRoll the mouse-wheel to check.";
        Font font = new Font("SansSerif", 1, 12);
        FixedSizedBillboard textBillboard = FixedSizedBillboardFactory.createConstantSizedTextBillboard(text, 0, font, Colorf.ORANGE);
        return textBillboard;
    }

    private BranchGroup createScene() throws Exception {
        BranchGroup root = new BranchGroup();
        this.addCubes(root);
        TransformGroup tg4 = new TransformGroup(new Transform3D(0.0f, 0.0f, 5.0f));
        FixedSizedBillboard billboard = FixedSizedBillboardFactory.createConstantSizeTexturedBillboard(128, 64, "stone.jpg");
        tg4.addChild(billboard);
        tg4.addChild(new Transform(this.createTextBillboard()).setTranslation(0.0f, 0.0f, 1.0f));
        root.addChild(tg4);
        return root;
    }

    public FixedSizedBillboardTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this.eyePos, this.focus, this.vecUp, this);
        this.view = env.getView();
        env.getRenderer().setTransparentSortingPolicy(Renderer.TransparentSortingPolicy.SORT_BY_Z_VALUE);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createScene());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        FixedSizedBillboardTest test = new FixedSizedBillboardTest(FixedSizedBillboardTest.parseCommandLine(args));
        test.begin();
    }
}

