/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.jagatoo.input.events.MouseButtonReleasedEvent;
import org.jagatoo.input.events.MouseMovedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.render.Renderer;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Box;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.selection.MovementConstraints;
import org.xith3d.selection.ViewConstraints;
import org.xith3d.test.Xith3DTest;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Basic demonstration of having a perspective pass while drawing parallel."}, authors={"Andreas Nusser (aka XithN00b)"})
public class ParallelTest
extends Xith3DTest {
    private Renderer renderer;
    private BranchGroup selectionGroup;
    private View camera;
    private Canvas3D canvas;
    private MovementConstraints movementConstraints = new ViewConstraints();
    private RenderPass parallelPass;
    private float updown = 0.0f;
    private float leftright = 0.0f;
    private static final float SPEED = 0.02f;
    private Rectangle rect = null;
    private Point3f rectangeStart = new Point3f();
    private boolean leftPressed = false;

    private void rotate() {
        Vector3f direction = Vector3f.fromPool(0.0f, 0.0f, -1.0f);
        Matrix3f transformation = Matrix3f.fromPool();
        Matrix3f rotation = Matrix3f.fromPool();
        rotation.rotY(this.leftright);
        transformation.rotX(this.updown);
        transformation.mul(rotation);
        transformation.transform(direction);
        Matrix3f.toPool(transformation);
        Matrix3f.toPool(rotation);
        this.camera.lookAlong(this.camera.getPosition(), direction);
        Vector3f.toPool(direction);
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case L: {
                this.renderer.setLayeredMode(!this.renderer.isLayeredMode());
                break;
            }
            case UP: {
                this.updown += 0.02f;
                this.rotate();
                break;
            }
            case DOWN: {
                this.updown -= 0.02f;
                this.rotate();
                break;
            }
            case LEFT: {
                this.leftright -= 0.02f;
                this.rotate();
                break;
            }
            case RIGHT: {
                this.leftright += 0.02f;
                this.rotate();
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        if (MouseButtons.LEFT_BUTTON == button) {
            this.leftPressed = true;
            this.movementConstraints.computeNewPosition(this.parallelPass.getConfig(), this.canvas, e.getX(), e.getY(), Point3f.ZERO, this.rectangeStart);
        }
    }

    public void onMouseButtonReleased(MouseButtonReleasedEvent e, MouseButton button) {
        if (MouseButtons.LEFT_BUTTON == button) {
            this.leftPressed = false;
            if (this.rect != null) {
                this.selectionGroup.removeChild(this.rect);
                this.rect = null;
            }
        }
    }

    public void onMouseMoved(MouseMovedEvent e, int x, int y, int dx, int dy) {
        if (this.leftPressed) {
            Point3f rectangleEnd = Point3f.fromPool();
            this.movementConstraints.computeNewPosition(this.parallelPass.getConfig(), this.canvas, x, y, Point3f.ZERO, rectangleEnd);
            Vector3f delta = Vector3f.fromPool(rectangleEnd);
            delta.sub(this.rectangeStart);
            if (this.rect != null) {
                this.selectionGroup.removeChild(this.rect);
            }
            this.rect = new Rectangle(delta.getX(), delta.getY(), Rectangle.ZeroPointLocation.BOTTOM_LEFT, (Tuple3f)this.rectangeStart, Colorf.RED);
            this.rect.setAlpha(0.8f);
            this.selectionGroup.addChild(this.rect);
            Point3f.toPool(rectangleEnd);
            Vector3f.toPool(delta);
        }
    }

    private void createSceneGraph(SceneGraph sg) {
        BranchGroup rootGroup = new BranchGroup();
        rootGroup.addChild(new DirectionalLight());
        rootGroup.addChild(new Box(1.0f, 2.0f, 0.5f, Colorf.BLUE));
        sg.addPerspectiveBranch(rootGroup);
        this.selectionGroup = new BranchGroup();
        this.selectionGroup.addChild(new AmbientLight());
        this.parallelPass = sg.addParallelBranch(this.selectionGroup);
        this.parallelPass.getConfig().setViewTransform(Transform3D.IDENTITY);
    }

    public ParallelTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        this.renderer = env.getRenderer();
        this.camera = env.getView();
        this.createSceneGraph(env);
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        ParallelTest test = new ParallelTest(ParallelTest.parseCommandLine(args));
        test.begin();
    }
}

