/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Polygon Offset test"}, authors={"Yuri Vl. Gushchin (aka YVG)", "Marvin Froehlich (aka Qudus) [code streamlining]"})
public class PolygonOffsetTest
extends Xith3DTest {
    private PolygonAttributes paWhite;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                if (this.paWhite.getPolygonOffset() == 0.0f) {
                    this.paWhite.setPolygonOffset(-1.0f);
                    this.paWhite.setPolygonOffsetFactor(-1.0f);
                    break;
                }
                if (this.paWhite.getPolygonOffset() == -1.0f) {
                    this.paWhite.setPolygonOffset(1.0f);
                    this.paWhite.setPolygonOffsetFactor(1.0f);
                    break;
                }
                this.paWhite.setPolygonOffset(0.0f);
                this.paWhite.setPolygonOffsetFactor(0.0f);
            }
        }
    }

    private void createSceneGraph(Xith3DEnvironment env) {
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        TransformGroup scaleTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        scaleTransform.setTransform(t);
        testRotateYGroup.addChild(scaleTransform);
        Rectangle rect = new Rectangle(0.6f, 0.6f, Colorf.WHITE);
        Appearance app = rect.getAppearance(true);
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        this.paWhite = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE, -1.0f, -1.0f);
        app.setPolygonAttributes(this.paWhite);
        scaleTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, Colorf.RED);
        StaticTransform.translate(rect, 0.4f, -0.4f, 0.0f);
        app = rect.getAppearance(true);
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE, 0.0f));
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        scaleTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, Colorf.GREEN);
        StaticTransform.translate(rect, -0.4f, 0.4f, 0.0f);
        app = rect.getAppearance(true);
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE, 0.0f));
        scaleTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, Colorf.BLUE);
        StaticTransform.translate(rect, 0.4f, 0.4f, 0.0f);
        app = rect.getAppearance(true);
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE, 0.0f));
        scaleTransform.addChild(rect);
        env.addPerspectiveBranch().getBranchGroup().addChild(testRotateYGroup);
        this.getAnimator().addAnimatableObject(testRotateYGroup);
    }

    public PolygonOffsetTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        this.createSceneGraph(env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle polygon offset to zero or non-zero, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        PolygonOffsetTest test = new PolygonOffsetTest(PolygonOffsetTest.parseCommandLine(args));
        test.begin();
    }
}

