/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureCreator;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderTarget;
import org.xith3d.render.TextureRenderTarget;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.scenegraph.SkyBoxTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple testcase for Xith3D's render-to-texture feature."}, authors={"Marvin Froehlich (aka Qudus)"})
public class RenderToTextureTest
extends Xith3DTest {
    private GroupNode group;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.group.setRenderable(!this.group.isRenderable());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createSceneGraph(ResourceLocator resLoc, SceneGraph sceneGraph) throws Exception {
        sceneGraph.addRenderPass(SkyBoxTest.createSkyBox(resLoc.getResource("skyboxes/"), "normal"));
        BranchGroup bg = new BranchGroup();
        this.group = new Group();
        Group mainGroup = new Group();
        RotatableGroup rg0 = new RotatableGroup(new TransformationDirectives(0.0f, 0.0f, 0.3f));
        RotatableGroup rg1 = new RotatableGroup(new TransformationDirectives(0.5f, 0.5f, 0.0f));
        TransformGroup translation = new TransformGroup(new Transform3D(0.0f, 3.0f, -5.0f));
        Rectangle rect = new Rectangle(3.0f, 3.0f, (Texture)TextureLoader.getInstance().getTexture("stone.jpg"));
        rg0.addChild(translation);
        translation.addChild(rg1);
        rg1.addChild(rect);
        this.getAnimator().addAnimatableObject(rg0);
        this.getAnimator().addAnimatableObject(rg1);
        mainGroup.addChild(rg0);
        Rectangle rect0 = new Rectangle(1.0f, 1.0f, Colorf.RED);
        StaticTransform.translate(rect0, -4.0f, 2.8f, 0.0f);
        Rectangle rect1 = new Rectangle(1.0f, 1.0f, Colorf.GREEN);
        StaticTransform.translate(rect1, 4.0f, 2.8f, 0.0f);
        Rectangle rect2 = new Rectangle(1.0f, 1.0f, Colorf.BLUE);
        StaticTransform.translate(rect2, -4.0f, -2.8f, 0.0f);
        Rectangle rect3 = new Rectangle(1.0f, 1.0f, Colorf.YELLOW);
        StaticTransform.translate(rect3, 4.0f, -2.8f, 0.0f);
        mainGroup.addChild(rect0);
        mainGroup.addChild(rect1);
        mainGroup.addChild(rect2);
        mainGroup.addChild(rect3);
        bg.addChild(this.group);
        this.group.addChild(mainGroup);
        RenderPass rp = sceneGraph.addPerspectiveBranch(bg);
        Colorf backgroundColor = new Colorf(0.0f, 0.0f, 0.0f, 0.1f);
        Texture2D targetTex = TextureCreator.createTexture(TextureFormat.RGBA, 512, 512, backgroundColor);
        targetTex.enableAutoFreeLocalData();
        TextureRenderTarget renderTarget = new TextureRenderTarget((GroupNode)mainGroup, (Texture)targetTex, backgroundColor);
        sceneGraph.getRenderer().addRenderTarget((RenderTarget)renderTarget, rp.getConfig());
        Cube cube = new Cube(2.0f, targetTex);
        cube.getAppearance().setTransparencyAttributes(new TransparencyAttributes());
        cube.getAppearance().setPolygonAttributes(new PolygonAttributes(FaceCullMode.SWITCH));
        StaticTransform.rotateX(cube, 0.7853982f);
        StaticTransform.rotateY(cube, -0.7853982f);
        StaticTransform.translate(cube, 3.0f, 0.0f, 0.0f);
        bg.addChild(cube);
    }

    public RenderToTextureTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(resLoc, env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle the main scenegraph's visibility, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        RenderToTextureTest test = new RenderToTextureTest(RenderToTextureTest.parseCommandLine(args));
        test.begin();
    }
}

