/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This test dimply checks, if textured shapes", "are properly renderde when behind a transparent shape."}, authors={"Marvin Froehlich (aka Qudus)"})
public class TexturedBehindTransparentTest
extends Xith3DTest {
    private Shape3D transparentShape;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.transparentShape.setRenderable(!this.transparentShape.isRenderable());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createSceneGraph() {
        BranchGroup scene = new BranchGroup();
        Cube cube = new Cube(1.0f, "stone.jpg");
        scene.addChild(cube);
        Rectangle rect = new Rectangle(2.0f, 2.0f, 3.0f, "brushedMetal.png");
        rect.getAppearance().setTransparencyAttributes(new TransparencyAttributes(0.5f));
        scene.addChild(rect);
        this.transparentShape = rect;
        return scene;
    }

    private HUD createInfoHUD(Sized2iRO size) {
        HUD hud = new HUD(size, 800.0f);
        Label info = new Label(hud.getResX(), 40.0f, "Press SPACE to toggle the transparent shape's visibility.", HUDFont.getFont("Verdana", HUDFont.PLAIN, 18), Colorf.WHITE, TextAlignment.CENTER_LEFT);
        info.setPadding(10);
        hud.getContentPane().addWidget(info, 0.0f, hud.getResY() - info.getHeight());
        return hud;
    }

    public TexturedBehindTransparentTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createSceneGraph());
        env.addHUD(this.createInfoHUD(arguments.getResolution()));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        TexturedBehindTransparentTest test = new TexturedBehindTransparentTest(TexturedBehindTransparentTest.parseCommandLine(args));
        test.begin();
    }
}

