/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Transparency Alpha + Light test"}, authors={"Yuri Vl. Gushchin (aka YVG)"})
public class TransparencyAlphaTestLight
extends Xith3DTest {
    private Material mat;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                this.mat.setLightingEnabled(!this.mat.isLightingEnabled());
            }
        }
    }

    private void createSceneGraph(Xith3DEnvironment env) {
        BranchGroup objRoot = new BranchGroup();
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        objRoot.addChild(testRotateYGroup);
        DirectionalLight dlight = new DirectionalLight(true, Colorf.GRAY30, new Vector3f(-1.0f, -1.0f, -1.0f));
        objRoot.addChild(dlight);
        TransformGroup sceneRootTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        sceneRootTransform.setTransform(t);
        testRotateYGroup.addChild(sceneRootTransform);
        Texture2D texture = TextureLoader.getInstance().getTexture("stone.jpg");
        this.mat = new Material();
        this.mat.setEmissiveColor(Colorf.BLACK);
        this.mat.setSpecularColor(Colorf.GRAY50);
        this.mat.setAmbientColor(0.75f, 0.0f, 0.0f);
        this.mat.setDiffuseColor(0.75f, 0.0f, 0.0f);
        this.mat.setLightingEnabled(true);
        this.mat.setColorTarget(Material.AMBIENT_AND_DIFFUSE);
        Rectangle rect = new Rectangle(0.6f, 0.6f, (Texture)texture);
        StaticTransform.translate(rect, -0.4f, -0.4f, 0.0f);
        Appearance rectApp = rect.getAppearance(true);
        rectApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        TransparencyAttributes ta = new TransparencyAttributes();
        ta.setMode(TransparencyAttributes.BLENDED);
        ta.setTransparency(0.15f);
        rectApp.setTransparencyAttributes(ta);
        sceneRootTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, (Texture)texture);
        StaticTransform.translate(rect, 0.4f, -0.4f, 0.0f);
        rectApp = rect.getAppearance(true);
        rectApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        ta = new TransparencyAttributes();
        ta.setMode(TransparencyAttributes.BLENDED);
        ta.setTransparency(0.45f);
        rectApp.setTransparencyAttributes(ta);
        sceneRootTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, (Texture)texture);
        StaticTransform.translate(rect, -0.4f, 0.4f, 0.0f);
        rectApp = rect.getAppearance(true);
        rectApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        ta = new TransparencyAttributes();
        ta.setMode(TransparencyAttributes.BLENDED);
        ta.setTransparency(0.65f);
        rectApp.setTransparencyAttributes(ta);
        sceneRootTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, (Texture)texture);
        StaticTransform.translate(rect, 0.4f, 0.4f, 0.0f);
        rectApp = rect.getAppearance(true);
        rectApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        ta = new TransparencyAttributes();
        ta.setMode(TransparencyAttributes.BLENDED);
        ta.setTransparency(0.85f);
        rectApp.setTransparencyAttributes(ta);
        sceneRootTransform.addChild(rect);
        Cube cube = new Cube(0.8f, 11, false, 2);
        StaticTransform.translate(cube, 0.0f, 0.0f, -0.6f);
        Appearance a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        a.setMaterial(this.mat);
        a.setTexture(texture);
        cube.setAppearance(a);
        sceneRootTransform.addChild(cube);
        env.addPerspectiveBranch(objRoot);
        this.getAnimator().addAnimatableObject(testRotateYGroup);
    }

    public TransparencyAlphaTestLight(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle lighting on/off, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        TransparencyAlphaTestLight test = new TransparencyAlphaTestLight(TransparencyAlphaTestLight.parseCommandLine(args));
        test.begin();
    }
}

