/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This test case demonstrates, how a semi-transparent", "sphere can be rendered in Xith3D.."}, authors={"Marvin Froehlich (aka Qudus)"})
public class TransparentSphereTest
extends Xith3DTest {
    private PolygonAttributes polyAttrs;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.polyAttrs.setFaceCullMode(FaceCullMode.values()[(this.polyAttrs.getFaceCullMode().ordinal() + 1) % FaceCullMode.values().length]);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createScene(Animator animator) throws Exception {
        BranchGroup scene = new BranchGroup();
        Cube background = new Cube(10.0f, "stone.jpg");
        scene.addChild(background);
        Cube cube = new Cube(1.0f, "jplogo.jpg");
        scene.addChild(cube);
        Sphere sphere = new Sphere(2.0f, 32, 32, "deathstar.jpg");
        TransparencyAttributes ta = new TransparencyAttributes(TransparencyAttributes.BLENDED, 0.3f);
        sphere.getAppearance(true).setTransparencyAttributes(ta);
        this.polyAttrs = new PolygonAttributes(PolygonAttributes.CULL_SWITCH);
        sphere.getAppearance().setPolygonAttributes(this.polyAttrs);
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.05f, 0.05f, 0.0f));
        rg.addChild(sphere);
        scene.addChild(rg);
        animator.addAnimatableObject(rg);
        return scene;
    }

    public TransparentSphereTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createScene(this.getAnimator()));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        TransparentSphereTest test = new TransparentSphereTest(TransparentSphereTest.parseCommandLine(args));
        test.begin();
    }
}

