/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.FastMath;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This test case demonstrates, how a semi-transparent", "sphere can be rendered in Xith3D.."}, authors={"Marvin Froehlich (aka Qudus)"})
public class TransparentStateChangeTest
extends Xith3DTest {
    private final TransparencyAttributes ta = new TransparencyAttributes(TransparencyAttributes.BLENDED, 0.3f);

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createScene() throws Exception {
        BranchGroup scene = new BranchGroup();
        Cube background = new Cube(10.0f, "stone.jpg");
        scene.addChild(background);
        final Rectangle rect3 = new Rectangle(0.75f, 0.75f, "deathstar.jpg");
        rect3.setName("rect3");
        TransformGroup tg3 = new TransformGroup(0.25f, 0.25f, 3.0f);
        tg3.addChild(rect3);
        scene.addChild(tg3);
        Rectangle rect1 = new Rectangle(2.0f, 2.0f, "precision.png");
        rect1.setName("rect1");
        rect1.getAppearance(true).setTransparencyAttributes(this.ta);
        Rectangle rect2 = new Rectangle(1.5f, 1.5f, "jplogo.jpg");
        rect2.setName("rect2");
        rect2.getAppearance(true).setTransparencyAttributes(this.ta);
        TransformGroup tg = new TransformGroup();
        tg.addChild(rect1);
        scene.addChild(tg);
        TransformGroup rg2 = new TransformGroup(0.5f, 1.0f, 2.0f);
        rg2.addChild(rect2);
        scene.addChild(rg2);
        this.getOperationScheduler().addInterval(new Interval(1000000L){

            protected void onIntervalHit(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                TransparentStateChangeTest.this.ta.setTransparency(FastMath.randomFloat());
            }
        });
        this.getOperationScheduler().addInterval(new Interval(5000000L){

            protected void onIntervalHit(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                System.out.println("Applying BLENDED TransparencyAttributes to rect3 (the one in front)...");
                TransparencyAttributes ta = new TransparencyAttributes(TransparencyAttributes.BLENDED, 0.5f);
                rect3.getAppearance(true).setTransparencyAttributes(ta);
                this.kill();
            }
        });
        return scene;
    }

    public TransparentStateChangeTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup sceneBranch = this.createScene();
        env.addPerspectiveBranch(sceneBranch);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        TransparentStateChangeTest test = new TransparentStateChangeTest(TransparentStateChangeTest.parseCommandLine(args));
        test.begin();
    }
}

