/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.opengl.enums.TestFunction;
import org.openmali.types.twodee.Dim2i;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.render.preprocessing.sorting.CustomRenderBinSorter;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This testcase shows how you can sort 2D elements by z-index."}, authors={"Marvin Froehlich (aka Qudus)"})
public class ZIndexTest
extends Xith3DTest {
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private RenderPass createScene() {
        Dim2i resolution = new Dim2i(800, 600);
        BranchGroup scene = new BranchGroup();
        RenderingAttributes ra = new RenderingAttributes();
        ra.setDepthTestFunction(TestFunction.ALWAYS);
        Rectangle rect0 = new Rectangle(128.0f, 128.0f, Rectangle.ZeroPointLocation.TOP_LEFT, "precision.png");
        rect0.getAppearance().setRenderingAttributes(ra);
        rect0.setCustomComparable(Integer.valueOf(0));
        TransformGroup tg0 = new TransformGroup(new Transform3D(100.0f, -100.0f, -0.0f));
        tg0.addChild(rect0);
        scene.addChild(tg0);
        Rectangle rect1 = new Rectangle(128.0f, 128.0f, Rectangle.ZeroPointLocation.TOP_LEFT, "stone.jpg");
        rect1.getAppearance().setRenderingAttributes(ra);
        rect1.setCustomComparable(Integer.valueOf(1));
        TransformGroup tg1 = new TransformGroup(new Transform3D(120.0f, -120.0f, -0.01f));
        tg1.addChild(rect1);
        scene.addChild(tg1);
        Rectangle rect2 = new Rectangle(128.0f, 128.0f, Rectangle.ZeroPointLocation.TOP_LEFT, "jplogo.png");
        rect2.getAppearance().setRenderingAttributes(ra);
        rect2.setCustomComparable(Integer.valueOf(2));
        TransformGroup tg2 = new TransformGroup(new Transform3D(140.0f, -140.0f, -0.02f));
        tg2.addChild(rect2);
        scene.addChild(tg2);
        Rectangle rect3 = new Rectangle(128.0f, 128.0f, Rectangle.ZeroPointLocation.TOP_LEFT, "rustycan.jpg");
        rect3.getAppearance().setRenderingAttributes(ra);
        rect3.setCustomComparable(Integer.valueOf(3));
        TransformGroup tg3 = new TransformGroup(new Transform3D(160.0f, -160.0f, -0.03f));
        tg3.addChild(rect3);
        scene.addChild(tg3);
        Rectangle rect4 = new Rectangle(128.0f, 128.0f, Rectangle.ZeroPointLocation.TOP_LEFT, "cursors/cursor1.png");
        rect4.getAppearance().setRenderingAttributes(ra);
        rect4.setCustomComparable(Integer.valueOf(0));
        TransformGroup tg4 = new TransformGroup(new Transform3D(180.0f, -180.0f, -0.04f));
        tg4.addChild(rect4);
        scene.addChild(tg4);
        Rectangle rect5 = new Rectangle(128.0f, 128.0f, Rectangle.ZeroPointLocation.TOP_LEFT, "crate.png");
        rect5.getAppearance().setRenderingAttributes(ra);
        rect5.setCustomComparable(Integer.valueOf(5));
        TransformGroup tg5 = new TransformGroup(new Transform3D(220.0f, -220.0f, -0.05f));
        tg5.addChild(rect5);
        scene.addChild(tg5);
        RenderPass renderPass = RenderPass.create2D(scene, (Sized2iRO)resolution);
        renderPass.getConfig().setOpaqueSorter(new CustomRenderBinSorter());
        renderPass.getConfig().setTransparentSorter(new CustomRenderBinSorter());
        return renderPass;
    }

    public ZIndexTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        resLoc.createAndAddTSL("HUD");
        env.addRenderPass(this.createScene());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        ZIndexTest test = new ZIndexTest(ZIndexTest.parseCommandLine(args));
        test.begin();
    }
}

