/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.scenegraph;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.softmed.jops.ParticleManager;
import org.softmed.jops.ParticleSystem;
import org.softmed.jops.modifiers.PointMass;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.particles.jops.ParticleManagerUpdater;
import org.xith3d.scenegraph.particles.jops.ParticleSystemNode;
import org.xith3d.scenegraph.particles.jops.RelativeParticleSystemNode;
import org.xith3d.terrain.ChunkedTerrain;
import org.xith3d.terrain.GridSampler;
import org.xith3d.terrain.HeightMapSampler;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.terrain.DetailTextureSurface;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Combination test of a Terrain and ParticleSystem"}, authors={"kukanani"})
public class ComplexSceneTest
extends Xith3DTest {
    private GridSampler heightMap;
    private DetailTextureSurface surface;
    private ChunkedTerrain chunkedTerrain;
    private static final boolean useExternalPointMass = false;
    private ParticleManager pmanager = new ParticleManager();
    private ParticleSystem ps;
    private ParticleSystem pmps;
    private ParticleSystemNode relPSN;
    private String handle;
    private List<ParticleSystemNode> particleSystemNodes = new ArrayList<ParticleSystemNode>();

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private Node createTerrain(ResourceLocator resLoc) throws MalformedURLException {
        try {
            this.heightMap = new HeightMapSampler(resLoc.getResource("terrain/terrain-height.raw"), 257, 257);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.surface = new DetailTextureSurface(resLoc.getResource("terrain/terrain-splat.png").toString(), resLoc.getResource("terrain/terrain-details.png").toString(), 1.0f, TextureAttributes.BLEND);
        this.chunkedTerrain = new ChunkedTerrain(this.heightMap, this.surface, -250.0f, 0.0f, -250.0f, 500.0f, 50.0f);
        return this.chunkedTerrain;
    }

    private Model loadModel(ResourceLocator resLoc) throws Exception {
        Model model = ModelLoader.getInstance().loadModel(resLoc.getResource("models/jeep.obj"));
        return model;
    }

    private static final String loadParticleSystemHandle(ParticleManager pmanager, URL url) throws Exception {
        String handle = pmanager.load(url);
        return handle;
    }

    private static final String loadParticleSystemHandle(ParticleManager pmanager, ResourceLocator resLoc) throws Exception {
        String psName = "ps/candle.ops";
        String handle = ComplexSceneTest.loadParticleSystemHandle(pmanager, resLoc.getResource(psName));
        return handle;
    }

    private final ParticleSystem initParticleSystem(ResourceLocator resLoc) throws Exception {
        this.handle = ComplexSceneTest.loadParticleSystemHandle(this.pmanager, resLoc);
        ParticleSystem ps = this.pmanager.getCopyAttached(this.handle);
        this.pmps = new ParticleSystem();
        this.pmps.setLimited(false);
        PointMass pm = new PointMass();
        pm.getStrength().addValue(Float.valueOf(-9.0f), 0.0f);
        pm.setThreshold(false);
        pm.getThresholdValue().addValue(Float.valueOf(1.0f), 0.0f);
        pm.setDistanceVariation("linear");
        pm.setDistanceProportion("inverse");
        this.getOperationScheduler().scheduleOperation(new ParticleManagerUpdater(this.pmanager));
        return ps;
    }

    private void createScene(ResourceLocator resLoc, SceneGraph sg) throws Exception {
        BranchGroup scene = new BranchGroup();
        scene.addChild(new PointLight(1.0f, 0.8f, 0.2f, 2.0f, 2.0f, 15.0f, 0.001f));
        scene.addChild(this.createTerrain(resLoc));
        scene.addChild(this.loadModel(resLoc));
        sg.addPerspectiveBranch(scene);
        resLoc = resLoc.getSubLocator("jops/");
        resLoc.createAndAddTSL("textures");
        this.relPSN = new RelativeParticleSystemNode();
        this.ps = this.initParticleSystem(resLoc);
        this.relPSN.setParticleSystem(this.ps);
        this.particleSystemNodes.add(this.relPSN);
        RenderPass sgPass = sg.addPerspectiveBranch();
        sgPass.setLayeredModeForced(true);
        sgPass.getBranchGroup().addChild(this.relPSN);
    }

    public ComplexSceneTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(80.0f, 80.0f, -80.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createScene(resLoc, env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        FirstPersonInputHandler fpih = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)canvas, arguments.getMouseYInverted());
        fpih.getBindingsManager().createDefaultBindings(true);
        InputSystem.getInstance().addInputHandler(fpih);
    }

    public static void main(String[] args) throws Throwable {
        ComplexSceneTest test = new ComplexSceneTest(ComplexSceneTest.parseCommandLine(args));
        test.begin();
    }
}

