/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.scenegraph;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.LODSwitch;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple test of the LODSwitch<br>", "The LODSwitch handles multiple Nodes, that represent the", "same Node, but in different levels of detail."}, authors={"Marvin Froehlich (aka Qudus)"})
public class LODSwitchTest
extends Xith3DTest {
    private Canvas3D canvas;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                this.canvas.switchWireframeMode();
            }
        }
    }

    private void initSceneGraph(SceneGraph sg) {
        BranchGroup scene = new BranchGroup();
        LODSwitch lodSwitch = new LODSwitch();
        Sphere sphere0 = new Sphere(10.0f, 128, 128, "deathstar.jpg");
        lodSwitch.addLODItem(sphere0, 0.0f, 20.0f);
        Sphere sphere1 = new Sphere(10.0f, 64, 64, "deathstar.jpg");
        lodSwitch.addLODItem(sphere1, 19.0f, 35.0f);
        Sphere sphere2 = new Sphere(10.0f, 16, 16, "deathstar.jpg");
        lodSwitch.addLODItem(sphere2, 34.0f, 50.0f);
        Sphere sphere3 = new Sphere(10.0f, 8, 8, "deathstar.jpg");
        lodSwitch.addLODItem(sphere3, 49.0f, 75.0f);
        Sphere sphere4 = new Sphere(10.0f, 4, 4, "deathstar.jpg");
        lodSwitch.addLODItem(sphere4, 74.0f, Float.MAX_VALUE);
        scene.addChild(lodSwitch);
        sg.addPerspectiveBranch(scene);
    }

    public LODSwitchTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 100.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.initSceneGraph(env);
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        this.canvas.setWireframeMode(true);
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        FirstPersonInputHandler fpih = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)this.canvas, arguments.getMouseYInverted());
        fpih.getBindingsManager().createDefaultBindings();
        InputSystem.getInstance().addInputHandler(fpih);
    }

    public static void main(String[] args) throws Throwable {
        LODSwitchTest test = new LODSwitchTest(LODSwitchTest.parseCommandLine(args));
        test.begin();
    }
}

