/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.scenegraph;

import java.util.ArrayList;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.logging.Log;
import org.jagatoo.logging.LogChannel;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.LODSwitch;
import org.xith3d.scenegraph.LazyLoadable;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.widgets.assemblies.HUDConsole;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple test of the LazyLoadable interface and it's interaction with the LODSwitch<br>", "The LODSwitch handles multiple Nodes, that represent the same object, ", "but in different levels of detail. In conjuction with the LazyLoadable ", "interface it is possible to load higher levels of detail on demand"}, authors={"Marvin Froehlich (aka Qudus)", "Mathias Henze (aka cylab)"})
public class LazyLoadableTest
extends Xith3DTest {
    private static ArrayList<String> messages = new ArrayList(16);
    private Canvas3D canvas;
    private HUDConsole console;
    private final LogChannel logChannel = new LogChannel("LazyLoadableTest");

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case T: {
                this.canvas.switchWireframeMode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendMessage(String message) {
        ArrayList<String> arrayList = messages;
        synchronized (arrayList) {
            messages.add(message);
        }
    }

    private void createHUD(SceneGraph sg, Sized2iRO resolusion) {
        HUD hud = new HUD(resolusion, 800.0f);
        this.console = new HUDConsole(hud.getResX(), 200.0f, this.logChannel.getID(), true);
        hud.getContentPane().addWidget(this.console);
        this.console.setInputBoxVisible(false);
        sg.addHUD(hud);
    }

    private void initSceneGraph(SceneGraph sg) {
        BranchGroup scene = new BranchGroup();
        LODSwitch lodSwitch = new LODSwitch(){

            protected void setLODChild(int index) {
                super.setLODChild(index);
                LazyLoadableTest.this.appendMessage("Setting LOD-Index: " + index);
            }
        };
        lodSwitch.addLODItem(new LazyDeathstar(128, "0 - Highest Level Deathstar"), 0.0f, 20.0f);
        lodSwitch.addLODItem(new LazyDeathstar(64, "1 - Higher Level Deathstar"), 20.0f, 35.0f);
        lodSwitch.addLODItem(new LazyDeathstar(16, "2 - Medium Level Deathstar"), 35.0f, 50.0f);
        lodSwitch.addLODItem(new LazyDeathstar(8, "3 - Lower Level Deathstar"), 50.0f, 75.0f);
        lodSwitch.addLODItem(new LazyDeathstar(4, "4 - Lowest Level Deathstar", false), 64.0f, Float.MAX_VALUE);
        scene.addChild(lodSwitch);
        sg.addPerspectiveBranch(scene);
    }

    public LazyLoadableTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 100.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.initSceneGraph(env);
        this.createHUD(env, arguments.getResolution());
        Log.getLogManager().registerLog(this.console);
        Log.getLogManager().setTimestampingEnabled(true);
        env.getOperationScheduler().addInterval(new Interval(15000L){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onIntervalHit(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                ArrayList arrayList = messages;
                synchronized (arrayList) {
                    if (!messages.isEmpty()) {
                        for (String message : messages) {
                            Log.println(LazyLoadableTest.this.logChannel, message);
                        }
                        messages.clear();
                    }
                }
            }
        });
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        FirstPersonInputHandler fpih = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)this.canvas, arguments.getMouseYInverted());
        fpih.getBindingsManager().createDefaultBindings();
        fpih.setMouseMovementSuspended(true);
        InputSystem.getInstance().addInputHandler(fpih);
    }

    public static void main(String[] args) throws Throwable {
        LazyLoadableTest test = new LazyLoadableTest(LazyLoadableTest.parseCommandLine(args));
        test.begin();
    }

    private class LazyDeathstar
    extends Sphere
    implements LazyLoadable {
        private final int detail;
        private final String name;
        private boolean isSetup;

        public LazyDeathstar(int detail, String name) {
            this(detail, name, true);
        }

        public LazyDeathstar(int detail, String name, boolean lazy) {
            super(10.0f, detail, detail, "deathstar.jpg");
            this.isSetup = false;
            this.detail = detail;
            this.name = name;
            this.isSetup = !lazy;
        }

        public boolean isSetUp() {
            LazyLoadableTest.this.appendMessage("'isSetup' called on " + this.name + ", returning " + this.isSetup);
            return this.isSetup;
        }

        public void prepare() {
            LazyLoadableTest.this.appendMessage("'prepare' called on " + this.name);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                LazyLoadableTest.this.appendMessage("'prepare' caught an exception: " + ex.getMessage());
            }
            LazyLoadableTest.this.appendMessage("'prepare' exited on " + this.name);
        }

        public void setUp() {
            LazyLoadableTest.this.appendMessage("'setUp' called on " + this.name);
            this.isSetup = true;
        }

        public void tearDown() {
            LazyLoadableTest.this.appendMessage("'tearDown' called on " + this.name);
            this.isSetup = false;
        }

        public void cleanUp() {
            LazyLoadableTest.this.appendMessage("'cleanUp' called on " + this.name);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                LazyLoadableTest.this.appendMessage("'cleanUp' caught an exception: " + ex.getMessage());
            }
            LazyLoadableTest.this.appendMessage("'cleanUp' exited on " + this.name);
        }
    }
}

