/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.scenegraph;

import java.util.BitSet;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.PickScheduler;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.PickResult;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Switch;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Switch node test"}, authors={"YVG"})
public class SwitchNodeTest
extends Xith3DTest
implements NearestPickListener {
    private GroupNode pickGroup;
    private PickScheduler pickScheduler;
    private RenderPass renderPass;
    private Switch switch1;
    private Switch switch2;
    private int bitMask = 7;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                if (this.renderPass.getConfig().getProjectionPolicy() == View.ProjectionPolicy.PERSPECTIVE_PROJECTION) {
                    this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PARALLEL_PROJECTION);
                    break;
                }
                this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PERSPECTIVE_PROJECTION);
            }
        }
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        this.pickScheduler.pickNearest(this.pickGroup, e.getButton(), e.getX(), e.getY(), (NearestPickListener)this);
    }

    public boolean testIntersectionsInWorldSpaceForPicking() {
        return false;
    }

    public void onObjectPicked(PickResult nearest, Object userObject, long pickTime) {
        if (nearest.getNode().getName().equals("Plane1")) {
            int child = this.switch1.getWhichChild();
            if (child == -2) {
                this.switch1.setWhichChild(0);
            } else if (child == -1) {
                this.switch1.setWhichChild(-2);
            } else if (child == 2) {
                this.switch1.setWhichChild(-1);
            } else {
                this.switch1.setWhichChild(child + 1);
            }
        } else if (nearest.getNode().getName().equals("Plane2")) {
            this.bitMask = this.bitMask + 1 & 7;
            this.switch2.setChildMask(this.getMask());
        }
    }

    public void onPickingMissed(Object userObject, long pickTime) {
    }

    private BitSet getMask() {
        BitSet mask = new BitSet(3);
        if ((this.bitMask & 1) != 0) {
            mask.set(0);
        }
        if ((this.bitMask & 2) != 0) {
            mask.set(1);
        }
        if ((this.bitMask & 4) != 0) {
            mask.set(2);
        }
        return mask;
    }

    private void createSceneGraph(SceneGraph sg) throws Exception {
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        TransformGroup scaleTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        scaleTransform.setTransform(t);
        testRotateYGroup.addChild(scaleTransform);
        Texture2D texture = TextureLoader.getInstance().getTexture("stone.jpg");
        Rectangle rect1 = new Rectangle(0.45f, 0.45f, (Texture)texture);
        StaticTransform.translate(rect1, 0.0f, -0.25f, 0.0f);
        rect1.setName("Plane1");
        Appearance rectApp = rect1.getAppearance(true);
        rectApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        scaleTransform.addChild(rect1);
        Rectangle rect2 = new Rectangle(0.45f, 0.45f, (Texture)texture);
        StaticTransform.translate(rect2, 0.0f, 0.25f, 0.0f);
        rect2.setName("Plane2");
        Appearance rectApp2 = rect2.getAppearance(true);
        rectApp2.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        scaleTransform.addChild(rect2);
        this.switch1 = new Switch();
        this.switch1.setWhichChild(-2);
        scaleTransform.addChild(this.switch1);
        Appearance a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        a.setTexture(texture);
        Cube shape = new Cube(0.45f, a);
        StaticTransform.translate(shape, -0.5f, -0.75f, 0.0f);
        this.switch1.addChild(shape);
        a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        a.setTexture(texture);
        shape = new Cube(0.45f, a);
        StaticTransform.translate(shape, 0.0f, -0.75f, 0.0f);
        this.switch1.addChild(shape);
        a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        a.setTexture(texture);
        shape = new Cube(0.45f, a);
        StaticTransform.translate(shape, 0.5f, -0.75f, 0.0f);
        this.switch1.addChild(shape);
        this.switch2 = new Switch();
        this.switch2.setWhichChild(-3);
        this.switch2.setChildMask(this.getMask());
        scaleTransform.addChild(this.switch2);
        a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        a.setTexture(texture);
        shape = new Cube(0.45f, a);
        StaticTransform.translate(shape, -0.5f, 0.75f, 0.0f);
        this.switch2.addChild(shape);
        a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        a.setTexture(texture);
        shape = new Cube(0.45f, a);
        StaticTransform.translate(shape, -0.5f, 0.75f, 0.0f);
        this.switch2.addChild(shape);
        a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        a.setTexture(texture);
        shape = new Cube(0.45f, a);
        StaticTransform.translate(shape, 0.5f, 0.75f, 0.0f);
        this.switch2.addChild(shape);
        this.pickGroup = testRotateYGroup;
        this.renderPass = sg.addPerspectiveBranch(new BranchGroup((Node)testRotateYGroup));
        this.getAnimator().addAnimatableObject(testRotateYGroup);
    }

    public SwitchNodeTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env);
        this.pickScheduler = env.getPickScheduler();
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit ESC to exit, SPACE to toggle projection policy, click mouse on planes to switch");
        System.out.println("Note that due to Linux workarounds planes with CULL_NONE are pickable only from one (face) side...");
    }

    public static void main(String[] args) throws Throwable {
        SwitchNodeTest test = new SwitchNodeTest(SwitchNodeTest.parseCommandLine(args));
        test.begin();
    }
}

