/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.shaders;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.effects.EffectFactory;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GLSLContext;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.scenegraph.SkyBoxTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.listeners.SliderListener;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Slider;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Xith3D bloom effect test"}, authors={"Yoann Meste (aka Mancer)"})
public class BloomTest
extends Xith3DTest
implements SliderListener {
    private Label label1;
    private Label label2;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createSceneGraph(Xith3DEnvironment env) throws Exception {
        BranchGroup objRoot = new BranchGroup();
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.01f, 0.0f));
        objRoot.addChild(testRotateYGroup);
        PointLight light = new PointLight(true, Colorf.GRAY30, (Tuple3f)new Point3f(-1.0f, 0.5f, 0.45f), 0.5f);
        objRoot.addChild(light);
        TransformGroup sceneRootTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        sceneRootTransform.setTransform(t);
        testRotateYGroup.addChild(sceneRootTransform);
        Texture2D texture = TextureLoader.getInstance().getTexture("earth.jpg");
        Sphere sphere = new Sphere(1.8f, 64, 64, 11, false, 2);
        Appearance a = new Appearance();
        a.setTexture(texture);
        sphere.setAppearance(a);
        sceneRootTransform.addChild(sphere);
        env.addPerspectiveBranch(objRoot);
        this.getAnimator().addAnimatableObject(testRotateYGroup);
        return objRoot;
    }

    public void onSliderValueChanged(Slider slider, int newValue) {
        if (slider.getUserObject().equals("SCENE_WEIGHT")) {
            float sceneWeight = (float)newValue / 100.0f;
            EffectFactory.getInstance().getBloomFactory().setSceneWeight(sceneWeight);
            this.label1.setText(String.valueOf(newValue));
        } else if (slider.getUserObject().equals("BLOOM_WEIGHT")) {
            float blurWeight = (float)newValue / 100.0f;
            EffectFactory.getInstance().getBloomFactory().setBloomWeight(blurWeight);
            this.label2.setText(String.valueOf(newValue));
        }
    }

    private void createHUD(Xith3DEnvironment env, Sized2iRO resolution) {
        HUD hud = new HUD(resolution, 1024.0f);
        Slider slider = new Slider(265.0f);
        slider.setMinMaxAndValue(0, 200, 100);
        slider.setSmoothSliding(true);
        slider.addSliderListener(this);
        slider.setUserObject("SCENE_WEIGHT");
        hud.getContentPane().addWidget(slider, 32.0f, 580.0f);
        this.label1 = new Label(50.0f, 20.0f, "100", Colorf.WHITE);
        hud.getContentPane().addWidget(this.label1, 305.0f, 580.0f);
        slider = new Slider(265.0f);
        slider.setMinMaxAndValue(0, 200, 100);
        slider.setSmoothSliding(true);
        slider.addSliderListener(this);
        slider.setUserObject("BLOOM_WEIGHT");
        hud.getContentPane().addWidget(slider, 32.0f, 620.0f);
        this.label2 = new Label(50.0f, 20.0f, "100", Colorf.WHITE);
        hud.getContentPane().addWidget(this.label2, 305.0f, 620.0f);
        env.addHUD(hud);
    }

    public BloomTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        GLSLContext.setDebuggingEnabled(true);
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 2.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup group = this.createSceneGraph(env);
        env.addRenderPass(SkyBoxTest.createSkyBox(resLoc.getResource("skyboxes/"), "normal"));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        EffectFactory.getInstance().getBloomFactory().prepareForBloom(env, canvas, group);
        this.createHUD(env, arguments.getResolution());
    }

    public static void main(String[] args) throws Throwable {
        BloomTest test = new BloomTest(BloomTest.parseCommandLine(args));
        test.begin();
    }
}

