/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.shaders;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.FastMath;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.shaders.impl.glsl.GLSLShaderLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.GLSLContext;
import org.xith3d.scenegraph.GLSLFragmentShader;
import org.xith3d.scenegraph.GLSLShaderProgram;
import org.xith3d.scenegraph.GLSLVertexShader;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.GeometryType;
import org.xith3d.scenegraph.primitives.Grid;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This is a simple demo demonstrating how to use GLSL support in Xith."}, authors={"Florian Hofmann (aka Goliat)"})
public class GLSLWaverTest
extends Xith3DTest {
    private static final int RESOLUTION = 32;
    private GLSLContext shaderProg;
    private Canvas3D canvas;
    private View view;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case W: 
            case SPACE: {
                this.canvas.switchWireframeMode();
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private GLSLContext loadShader(ResourceLocator resLoc) throws Exception {
        GLSLContext.setDebuggingEnabled(true);
        GLSLVertexShader waverShader = GLSLShaderLoader.getInstance().loadVertexShader(resLoc.getResource("glsl/waver.glslvert"));
        GLSLContext shaderProg = new GLSLContext(new GLSLShaderProgram());
        ((GLSLShaderProgram)shaderProg.getProgram()).addShader(waverShader);
        GLSLFragmentShader heightcolorShader = GLSLShaderLoader.getInstance().loadFragmentShader(resLoc.getResource("glsl/heightcolor.glslfrag"));
        ((GLSLShaderProgram)shaderProg.getProgram()).addShader(heightcolorShader);
        shaderProg.getUniformParameters().setUniformVar("time", 0.0f);
        return shaderProg;
    }

    private void createSceneGraph(SceneGraph sg, Sized2iRO resolution, ResourceLocator resLoc) throws Exception {
        this.view = sg.getView();
        Grid.setGeometryConstructionTypeHint(GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY);
        Grid patch = new Grid(1.0f, 1.0f, 32, 32, 1, false, 2);
        StaticTransform.translate(patch, 0.5f, 0.5f, 0.0f);
        this.shaderProg = this.loadShader(resLoc);
        Appearance app = new Appearance();
        app.setShaderProgramContext(this.shaderProg);
        patch.setAppearance(app);
        sg.addPerspectiveBranch().getBranchGroup().addChild(patch);
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        float seconds = timingMode.getSecondsAsFloat(gameTime);
        this.shaderProg.getUniformParameters().setUniformVar("time", seconds);
        float posEye = 0.5f;
        float heightCam = 1.5f;
        float heightEye = 0.5f;
        this.view.getTransform().lookAt(FastMath.sin(seconds / 10.0f), FastMath.cos(seconds / 10.0f), heightCam, posEye, posEye, heightEye, 0.0f, 0.0f, 1.0f);
    }

    public GLSLWaverTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env, arguments.getResolution(), resLoc);
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        GLSLWaverTest test = new GLSLWaverTest(GLSLWaverTest.parseCommandLine(args));
        test.begin();
    }
}

