/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.shadows;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.jagatoo.opengl.enums.TextureFilter;
import org.openmali.FastMath;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.effects.EffectFactory;
import org.xith3d.effects.shadows.ShadowFactory;
import org.xith3d.effects.shadows.ShadowMappingFactory;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animatable;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.SpotLight;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Cone;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.scenegraph.primitives.Ring;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.scenegraph.primitives.Torus;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.texturing.CubeTextureSet;

@Xith3DTest.Description(fulltext={"Simple Xith3D shadows test using GLSL"}, authors={"Marvin Froehlich (aka Qudus)"})
public class GLSLShadowMappingTest
extends Xith3DTest {
    private static final boolean USE_SPOTLIGHT = true;
    private Canvas3D canvas;
    private Animatable rotator;
    private Group occluders;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                if (this.rotator.isAnimating()) {
                    this.rotator.stopAnimation();
                    break;
                }
                this.rotator.startAnimation(this.getGameTime(), this.getTimingMode());
                break;
            }
            case B: {
                ShadowFactory sf = EffectFactory.getInstance().getShadowFactory();
                sf.setShadowSoftness((sf.getShadowSoftness() + 1) % 8);
                break;
            }
            case F1: {
                EffectFactory.getInstance().getShadowFactory().setEnabled(!EffectFactory.getInstance().getShadowFactory().isEnabled());
                break;
            }
            case F2: {
                this.occluders.setRenderable(!this.occluders.isRenderable());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private static Rectangle createRect(float width, float height, float zOffset, Texture texture0) {
        Rectangle rect = new Rectangle(width, height, zOffset, texture0);
        rect.setIsShadowReceiver(true);
        return rect;
    }

    private Group createRoom(float width, float height, float depth, CubeTextureSet textures, Material mat) throws Exception {
        Group group = new Group();
        group.setName("room");
        Rectangle back = GLSLShadowMappingTest.createRect(width, height, -depth / 2.0f, textures.getBackTexture());
        Rectangle left = GLSLShadowMappingTest.createRect(depth, height, 0.0f, textures.getLeftTexture());
        Rectangle right = GLSLShadowMappingTest.createRect(depth, height, 0.0f, textures.getRightTexture());
        Rectangle top = GLSLShadowMappingTest.createRect(width, depth, 0.0f, textures.getTopTexture());
        Rectangle bottom = GLSLShadowMappingTest.createRect(width, depth, 0.0f, textures.getBottomTexture());
        Rectangle front = GLSLShadowMappingTest.createRect(width, height, -depth / 2.0f, textures.getFrontTexture());
        back.setName("back");
        left.setName("left");
        right.setName("right");
        top.setName("top");
        bottom.setName("bottom");
        front.setName("front");
        StaticTransform.rotateY(left, 1.5707964f);
        StaticTransform.translate(left, -width / 2.0f, 0.0f, 0.0f);
        StaticTransform.rotateY(right, -1.5707964f);
        StaticTransform.translate(right, width / 2.0f, 0.0f, 0.0f);
        StaticTransform.rotateX(top, 1.5707964f);
        StaticTransform.translate(top, 0.0f, height / 2.0f, 0.0f);
        StaticTransform.rotateX(bottom, -1.5707964f);
        StaticTransform.translate(bottom, 0.0f, -height / 2.0f, 0.0f);
        StaticTransform.rotateX(front, (float)Math.PI);
        back.getAppearance().setMaterial(mat);
        left.getAppearance().setMaterial(mat);
        right.getAppearance().setMaterial(mat);
        top.getAppearance().setMaterial(mat);
        bottom.getAppearance().setMaterial(mat);
        front.getAppearance().setMaterial(mat);
        PolygonAttributes pa = new PolygonAttributes(FaceCullMode.BACK);
        back.getAppearance().setPolygonAttributes(pa);
        left.getAppearance().setPolygonAttributes(pa);
        right.getAppearance().setPolygonAttributes(pa);
        top.getAppearance().setPolygonAttributes(pa);
        bottom.getAppearance().setPolygonAttributes(pa);
        front.getAppearance().setPolygonAttributes(pa);
        group.addChild(back);
        group.addChild(left);
        group.addChild(right);
        group.addChild(top);
        group.addChild(bottom);
        group.addChild(front);
        return group;
    }

    private static TransformGroup createTG(Shape3D shape, String name, Material mat, float x, float y, float z) {
        shape.setIsOccluder(true);
        shape.setName(name);
        shape.getAppearance().setMaterial(mat);
        TransformGroup tg = new TransformGroup(new Transform3D(x, y, z));
        tg.setName(shape.getName());
        tg.addChild(shape);
        return tg;
    }

    private Group createOccluders(Material mat) {
        Group group = new Group();
        int torusPrecision = 16;
        Torus torus = new Torus(1.0f, 0.5f, 16, 16, "rustycan.jpg");
        group.addChild(GLSLShadowMappingTest.createTG(torus, "torus1", mat, 0.0f, 0.0f, 0.0f));
        Cube cube = new Cube(1.0f, "jplogo.jpg");
        group.addChild(GLSLShadowMappingTest.createTG(cube, "cube1", mat, 3.0f, 0.0f, 0.0f));
        int spherePrecision = 24;
        Sphere sphere = new Sphere(1.0f, 24, 24, "deathstar.jpg");
        group.addChild(GLSLShadowMappingTest.createTG(sphere, "sphere1", mat, -3.0f, 0.0f, 0.0f));
        int ringPrecision = 16;
        Ring ring = new Ring(1.0f, 0.7f, 16, "saturnringcolor.jpg");
        StaticTransform.rotateX(ring, FastMath.toRad(45.0f));
        group.addChild(GLSLShadowMappingTest.createTG(ring, "ring1", mat, 0.0f, 0.0f, -3.0f));
        int conePrecision = 16;
        Cone cone = new Cone(1.0f, 1.0f, 16, "precision.png");
        StaticTransform.rotateX(cone, FastMath.toRad(45.0f));
        group.addChild(GLSLShadowMappingTest.createTG(cone, "cone1", mat, 0.0f, 0.0f, 3.0f));
        this.occluders = group;
        return group;
    }

    protected void createSceneGraph(Sized2iRO resolution, SceneGraph sg, Animator animator) throws Exception {
        BranchGroup scene = new BranchGroup();
        scene.setName("scene");
        Texture2D tex = TextureLoader.getInstance().getTexture("crate.png");
        tex.setFilter(TextureFilter.TRILINEAR);
        CubeTextureSet roomTexs = new CubeTextureSet(tex, tex, tex, tex, tex, tex);
        Material mat = new Material(Colorf.GRAY40, Colorf.BLACK, Colorf.GRAY40, Colorf.WHITE, 100.0f);
        mat.setLightingEnabled(true);
        float roomWidth = 14.0f;
        float roomHeight = 14.0f;
        float roomDepth = 14.0f;
        Group room = this.createRoom(14.0f, 14.0f, 14.0f, roomTexs, mat);
        scene.addChild(room);
        Colorf ambient = Colorf.GRAY50;
        Point3f light0Pos = new Point3f(-4.2000003f, 6.2999997f, -4.2000003f);
        Vector3f light0Dir = new Vector3f(light0Pos);
        light0Dir.negate();
        float lightSpreadAngle = 0.3926991f;
        Sphere light0Vis = new Sphere(0.1f, 8, 8, Colorf.YELLOW);
        light0Vis.setName("light0");
        TransformGroup tgLight0Vis = new TransformGroup();
        tgLight0Vis.setName("light0");
        tgLight0Vis.getTransform().setTranslation(light0Pos);
        tgLight0Vis.addChild(light0Vis);
        RotatableGroup rotator0 = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        rotator0.setName("rotator0");
        rotator0.addChild(tgLight0Vis);
        scene.addChild(rotator0);
        animator.addAnimatableObject(rotator0);
        this.rotator = rotator0;
        scene.addChild(new AmbientLight(ambient));
        SpotLight light0 = new SpotLight(Colorf.WHITE, (Tuple3f)light0Dir, light0Vis, new Tuple3f(0.0f, 0.0f, 0.001f), 0.3926991f, 1.0f);
        light0.setName("light0");
        scene.addChild(light0);
        scene.addChild(this.createOccluders(mat));
        RenderPass renderPass = sg.addPerspectiveBranch(scene);
        renderPass.setShadowCasterLight(light0);
        Texture2D depthTex = ((ShadowMappingFactory)EffectFactory.getInstance().getShadowFactory()).getShadowMap();
        TestUtils.displayDebugTextures(resolution, 240.0f, sg, depthTex);
    }

    public GLSLShadowMappingTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(6.0f, 0.0f, 6.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(arguments.getResolution(), env, this.getAnimator());
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        FirstPersonInputHandler fpih = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)this.canvas, arguments.getMouseYInverted());
        fpih.getBindingsManager().unbind(Keys.SPACE);
        InputSystem.getInstance().addInputHandler(fpih);
    }

    public static void main(String[] args) throws Throwable {
        GLSLShadowMappingTest test = new GLSLShadowMappingTest(GLSLShadowMappingTest.parseCommandLine(args));
        test.begin();
    }
}

