/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.sound;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.opengl.enums.TextureFilter;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.sound.SoundLoader;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BackgroundSound;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.sound.SoundContainer;
import org.xith3d.sound.SoundProcessor;
import org.xith3d.sound.drivers.javasound.SoundDriverImpl;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Plays a midi sound file."}, authors={"Marvin Froehlich (aka Qudus)"})
public class MidiSoundTest
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createSceneGraph(Xith3DEnvironment env, ResourceLocator resLoc) throws Exception {
        BranchGroup root = new BranchGroup();
        Transform3D rotate = new Transform3D();
        rotate.rotXYZ(0.7853982f, 0.62831855f, 1.5707964f);
        TransformGroup objRotate = new TransformGroup(rotate);
        root.addChild(objRotate);
        Texture2D texture = TextureLoader.getInstance().getTexture("stone.jpg");
        texture.setFilter(TextureFilter.TRILINEAR);
        Cube cube = new Cube(1.0f, texture);
        objRotate.addChild(cube);
        SoundDriverImpl soundDriver = new SoundDriverImpl();
        SoundProcessor.getInstance().setSoundDriver(soundDriver);
        soundDriver.setListenerVolume(1.0f);
        soundDriver.start();
        SoundContainer sc = SoundLoader.getInstance().loadSound(resLoc.getResource("sounds/axel_f.mid"));
        BackgroundSound sound = new BackgroundSound(sc, 1.0f);
        sound.setEnabled(true);
        root.addChild(sound);
        env.addPerspectiveBranch(root);
    }

    public MidiSoundTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env, resLoc);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        MidiSoundTest test = new MidiSoundTest(MidiSoundTest.parseCommandLine(args));
        test.begin();
    }
}

