/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.terrain;

import java.util.Random;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TexCoordGeneration;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.terrain.legacy.heightmap.MillerFractal;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Test of another Terrain implementation for Xith3D"}, authors={"William Denniss"})
public class TerrainTest2
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private Node createScene() {
        Group objRoot = new Group();
        MillerFractal miller = new MillerFractal(7, 4.0f, 10.0f, new Random(System.nanoTime()));
        Shape3D sh = new Shape3D();
        Geometry ta = miller.generateGeometry(-30.0f, -48.0f, 10.0f, 10.0f);
        ta.calculateFaceNormals();
        sh.setGeometry(ta);
        Texture2D texture = TextureLoader.getInstance().getTexture("rustycan.jpg", Texture.MipmapMode.MULTI_LEVEL_MIPMAP);
        Material mat = new Material();
        mat.setAmbientColor(Colorf.WHITE);
        mat.setLightingEnabled(true);
        Appearance a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        a.setTexture(texture);
        TexCoordGeneration texGen = new TexCoordGeneration(TexCoordGeneration.SPHERE_MAP, TexCoordGeneration.TEXTURE_COORDINATE_2);
        a.setTexCoordGeneration(texGen);
        a.setMaterial(mat);
        sh.setAppearance(a);
        objRoot.addChild(sh);
        DirectionalLight lighting = new DirectionalLight(true, new Colorf(2.0f, 2.0f, 2.0f), new Vector3f(0.0f, 0.0f, 15.0f));
        objRoot.addChild(lighting);
        PointLight pLight = new PointLight(Colorf.BLUE, (Tuple3f)new Point3f(80.0f, 30.0f, 85.0f), (Tuple3f)new Point3f(3.0E-5f, 3.0E-5f, 3.0E-5f));
        objRoot.addChild(pLight);
        AmbientLight aLight = new AmbientLight(Colorf.GRAY70);
        objRoot.addChild(aLight);
        return objRoot;
    }

    public TerrainTest2(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 80.0f, 65.0f, 65.0f, 13.0f, 0.0f, 0.0f, 1.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch().getBranchGroup().addChild(this.createScene());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        TerrainTest2 test = new TerrainTest2(TerrainTest2.parseCommandLine(args));
        test.begin();
    }
}

