/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.terrain;

import java.io.IOException;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.IndexedTriangleArray;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.utils.GeomDrawUtil;
import org.xith3d.terrain.legacy.Terrain;
import org.xith3d.terrain.legacy.TerrainRenderInterface;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.terrain.HeightMap;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Another TerrainTest"}, authors={"Mathias Henze (aka cylab)"})
public class TerrainTest3
extends Xith3DTest {
    private static final int MAX_HEIGHT = 30;
    private FirstPersonInputHandler fpHandler;
    private Canvas3D canvas;
    private ResourceLocator resLoc;
    private Terrain terrain;
    private TerrainShape terrainShape;
    private HeightMap heightMap;
    private View view;

    protected void exit() {
        this.fpHandler.setMouseMovementSuspended(true);
        super.exit();
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                if (!this.fpHandler.isMouseMovementSuspended()) {
                    this.fpHandler.setMouseMovementSuspended(true);
                    break;
                }
                this.end();
                break;
            }
            case G: {
                this.canvas.switchWireframeMode();
                break;
            }
            case Y: {
                this.fpHandler.flipMouseYAxis();
                break;
            }
            case NUMPAD_ADD: {
                this.heightMap.setHeight(this.heightMap.getHeight() + 5.0f);
                this.terrain.addData(this.heightMap);
                this.terrainShape.rebuild(this.view);
                break;
            }
            case NUMPAD_SUBTRACT: {
                this.heightMap.setHeight(this.heightMap.getHeight() - 5.0f);
                this.terrain.addData(this.heightMap);
                this.terrainShape.rebuild(this.view);
                break;
            }
            case U: {
                this.terrain.addData(this.heightMap);
                this.terrainShape.rebuild(this.view);
            }
        }
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        this.fpHandler.setMouseMovementSuspended(false);
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
    }

    private BranchGroup createScene() {
        BranchGroup root = new BranchGroup();
        this.terrain = new Terrain(7, 5);
        System.out.println("Building terrain...");
        try {
            this.heightMap = new HeightMap(this.resLoc.getResource("terrain/terrain-height.raw"), 257, 257, 30.0f);
            this.terrain.addData(this.heightMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Nodes = " + this.terrain.CountNodes());
        System.out.println("Removing nodes which are irrelevent...");
        System.out.println("Nodes count before culling = " + this.terrain.CountNodes());
        this.terrain.cullStaticData(40.0f, 4);
        System.out.println("Nodes count after culling = " + this.terrain.CountNodes());
        Node.pushGlobalIgnoreBounds(true);
        this.terrainShape = new TerrainShape();
        Node.popGlobalIgnoreBounds();
        this.terrainShape.rebuild(this.view);
        root.addChild(this.terrainShape);
        AmbientLight ambient = new AmbientLight(Colorf.WHITE);
        root.addChild(ambient);
        return root;
    }

    public TerrainTest3(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        up.normalize();
        Xith3DEnvironment env = new Xith3DEnvironment(new Vector3f(128.0f, 20.0f, 128.0f), new Vector3f(128.0f, 0.0f, 0.0f), up, this);
        this.view = env.getView();
        this.resLoc = TestUtils.createResourceLocator();
        this.resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createScene());
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        this.fpHandler = new FirstPersonInputHandler((Transformable)env.getView(), env.getCanvas(), 1.0f, 1.0f, arguments.getMouseYInverted(), 5.0f);
        this.fpHandler.getBindingsManager().createDefaultBindings();
        this.fpHandler.setMouseMovementSuspended(true);
        InputSystem.getInstance().addInputHandler(this.fpHandler);
        this.addFPSListener(new CanvasFPSListener(this.canvas));
    }

    public static void main(String[] args) throws Throwable {
        TerrainTest3 test = new TerrainTest3(TerrainTest3.parseCommandLine(args));
        test.begin();
    }

    private class TerrainShape
    extends Group
    implements TerrainRenderInterface {
        static final int MAX_INDICES = 20000;
        static final int MAX_VERTICES = 30000;
        int totalIndex = 0;
        int totalVerts = 0;
        Shape3D shape;
        IndexedTriangleArray geo;
        GeomDrawUtil drawer;
        int[] index = new int[20000];
        int[] vertexMap = new int[100];
        PolygonAttributes pa;

        public TerrainShape() {
            this.geo = new IndexedTriangleArray(30000, 20000);
            this.geo.setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
            this.drawer = new GeomDrawUtil(this.geo);
            Appearance a = new Appearance();
            this.pa = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK);
            a.setPolygonAttributes(this.pa);
            Texture2D texture = TextureLoader.getInstance().getTexture("stone.jpg", Texture.MipmapMode.MULTI_LEVEL_MIPMAP);
            Material mat = new Material();
            mat.setAmbientColor(Colorf.GRAY25);
            mat.setLightingEnabled(true);
            a.setMaterial(mat);
            a.setTexture(texture);
            Node.pushGlobalIgnoreBounds(true);
            this.shape = new Shape3D(this.geo, a);
            Node.popGlobalIgnoreBounds();
            this.addChild(this.shape);
        }

        public void rebuild(View view) {
            TerrainTest3.this.terrain.update(view.getPosition(), 117.0f);
            this.drawer.drawStart();
            this.totalIndex = 0;
            this.totalVerts = 0;
            TerrainTest3.this.terrain.render(this);
            System.out.println("total vertices = " + this.totalVerts);
            System.out.println("total indices = " + this.totalIndex);
            this.drawer.drawEnd();
            this.geo.setIndex(this.index);
            this.geo.setValidIndexCount(this.totalIndex);
            this.geo.setValidVertexCount(this.totalVerts);
        }

        public void start() {
        }

        public void initVert(int i, float x, float y, float z) {
            if (this.totalVerts >= 30000) {
                return;
            }
            this.drawer.newVertex();
            this.drawer.setCoordinate(x, y, z);
            int textureScale = 16;
            float texCoordx = x / (float)(TerrainTest3.this.terrain.getWidth() / textureScale);
            float texCoordz = z / (float)(TerrainTest3.this.terrain.getWidth() / textureScale);
            TexCoord2f texCoords = new TexCoord2f(texCoordx, texCoordz);
            this.geo.setTextureCoordinate(0, this.totalVerts, texCoords);
            float c = 1.0f;
            this.drawer.setColor(c, c, c);
            ++this.totalVerts;
        }

        public void tri(int a, int b, int c) {
            if (this.totalIndex + 3 >= 20000) {
                return;
            }
            this.index[this.totalIndex++] = this.vertexMap[a];
            this.index[this.totalIndex++] = this.vertexMap[b];
            this.index[this.totalIndex++] = this.vertexMap[c];
        }

        public void done() {
        }
    }
}

