/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.terrain;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.spatial.bodies.Plane;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loaders.texture.TextureCreator;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Clipper;
import org.xith3d.render.RenderCallbackAdapter;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.render.RenderTarget;
import org.xith3d.render.TextureRenderTarget;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Switch;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Line;
import org.xith3d.scenegraph.primitives.SkyBox;
import org.xith3d.terrain.ChunkedTerrain;
import org.xith3d.terrain.GridSampler;
import org.xith3d.terrain.GridSurface;
import org.xith3d.terrain.HeightMapSampler;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.scenegraph.SkyBoxTest;
import org.xith3d.test.terrain.GLSLTerrainSurface;
import org.xith3d.test.terrain.Water;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Hmmm, guess I'll have to stop it someday... ;)"}, authors={"Mathias Henze (aka cylab)"})
public class TerrainTest5
extends Xith3DTest {
    private static final String SKYBOX = "reijerse/skyboxsun45deg/512";
    private boolean showReflectionTexture = false;
    private boolean clipTerrain = true;
    private Xith3DEnvironment env;
    private FirstPersonInputHandler fpHandler;
    private Canvas3D canvas;
    private GridSampler heightMap;
    private GridSurface surface;
    private Colorf backgroundColor = new Colorf(0.5686275f, 0.54901963f, 0.5058824f, 1.0f);
    private HUD gui;
    private Transform3D reflectionTransform;
    private Texture2D reflection = TextureCreator.createTexture(TextureFormat.RGBA, 512, 512, this.backgroundColor);
    private TextureRenderTarget reflectionTarget;
    private Image reflectionView = null;
    private float tolerance = 0.01f;
    private float bias = 7.0f;
    private float x = -10000.0f / this.bias;
    private float z = -10000.0f / this.bias;
    private float scale = 20000.0f / this.bias;
    private float height = 4000.0f / this.bias;
    private float waterlevel = this.height / 3.3f;
    private float movementSpeed = this.scale / 1200.0f * 3.0f;
    private Clipper clipper = null;
    private Water water = null;
    private Switch waterSwitch = null;

    protected void exit() {
        this.fpHandler.setMouseMovementSuspended(true);
        super.exit();
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        this.fpHandler.setMouseMovementSuspended(false);
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                if (!this.fpHandler.isMouseMovementSuspended()) {
                    this.fpHandler.setMouseMovementSuspended(true);
                    break;
                }
                this.end();
                break;
            }
            case G: {
                this.canvas.switchWireframeMode();
                break;
            }
            case R: {
                this.showReflectionTexture = !this.showReflectionTexture;
                try {
                    if (this.showReflectionTexture) {
                        this.gui.getContentPane().addWidget(this.reflectionView, 10.0f, 10.0f);
                        break;
                    }
                    this.gui.getContentPane().removeWidget(this.reflectionView);
                }
                catch (Exception exception) {}
                break;
            }
            case B: {
                this.reflectionTarget.setBackgroundRenderingEnabled(!this.reflectionTarget.isBackgroundRenderingEnabled());
                break;
            }
            case C: {
                this.clipTerrain = !this.clipTerrain;
                break;
            }
            case O: {
                this.reflectionTarget.setBackgroundRenderingEnabled(!this.reflectionTarget.isBackgroundRenderingEnabled());
                break;
            }
            case Y: {
                this.fpHandler.flipMouseYAxis();
                break;
            }
            case SPACE: {
                if (this.fpHandler.isMouseMovementSuspended()) break;
                this.fpHandler.setMouseMovementSuspended(true);
            }
        }
    }

    private BranchGroup createScene(ResourceLocator resLoc, SceneGraph sceneGraph) throws IOException {
        BranchGroup root = new BranchGroup();
        URL heightMapSource = resLoc.getResource("terrain/coast/coast-heightfield_1x1k_16bit.raw");
        long t0 = TestUtils.dumpAction("Loading HeightMap from \"" + heightMapSource + "\"...");
        try {
            this.heightMap = new HeightMapSampler(heightMapSource, 1024, 1024, HeightMapSampler.Type.RAW_16);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        TestUtils.dumpDoneIn(t0);
        t0 = TestUtils.dumpAction("Generating Terrain surface...");
        this.surface = new GLSLTerrainSurface(resLoc, this.backgroundColor);
        TestUtils.dumpDoneIn(t0);
        t0 = TestUtils.dumpAction("Creating ChunkedTerrain...");
        ChunkedTerrain chunkedTerrain = new ChunkedTerrain(this.heightMap, this.surface, this.x, 0.0f, this.z, this.scale, this.height);
        root.addChild(chunkedTerrain);
        TestUtils.dumpDoneIn(t0);
        root.addChild(new Line((Tuple3f)Point3f.ZERO, Vector3f.POSITIVE_X_AXIS, Colorf.RED));
        root.addChild(new Line((Tuple3f)Point3f.ZERO, Vector3f.POSITIVE_Y_AXIS, Colorf.GREEN));
        root.addChild(new Line((Tuple3f)Point3f.ZERO, Vector3f.POSITIVE_Z_AXIS, Colorf.BLUE));
        t0 = TestUtils.dumpAction("Generating Water...");
        this.water = new Water(this.scale * 4.0f, this.scale * 4.0f, 100, resLoc, this.reflection, "w_normalmap.bmp", "w_distortion1.bmp", this.backgroundColor);
        this.addUpdatable(this.water);
        TestUtils.dumpDoneIn(t0);
        StaticTransform.rotate(this.water, 1.0f, 0.0f, 0.0f, 1.5707964f);
        StaticTransform.translate(this.water, 0.0f, this.waterlevel, 0.0f);
        this.waterSwitch = new Switch();
        this.waterSwitch.addChild(this.water);
        this.waterSwitch.setWhichChild(-2);
        root.addChild(this.waterSwitch);
        this.clipper = new Clipper(new Plane(0.0f, 1.0f, 0.0f, -this.waterlevel));
        root.setClipper(this.clipper);
        AmbientLight ambient = new AmbientLight(Colorf.WHITE);
        root.addChild(ambient);
        SkyBox sky = SkyBoxTest.createSkyBox(resLoc.getResource("skyboxes/"), SKYBOX);
        LinkedList children = sky.getBranchGroup().getChildren(new LinkedList());
        for (Node node2 : children) {
            StaticTransform.rotate((Shape3D)node2, 0.0f, 1.0f, 0.0f, (float)Math.PI);
        }
        sceneGraph.addRenderPass(sky);
        root.dump();
        return root;
    }

    private void setupGUI() {
        this.reflectionView = new Image(320.0f, 240.0f, this.reflection);
    }

    private void setupReflection(SceneGraph sceneGraph, BranchGroup scene) {
        RenderPass reflectionPass = RenderPass.createPerspective(scene);
        this.reflectionTarget = new TextureRenderTarget((GroupNode)scene, (Texture)this.reflection, this.backgroundColor);
        this.reflectionTarget.setBackgroundRenderingEnabled(true);
        RenderPassConfig config = reflectionPass.getConfig();
        this.reflectionTransform = new Transform3D();
        config.setViewTransform(this.reflectionTransform);
        reflectionPass.addRenderCallback(new RenderCallbackAdapter(){

            public void beforeRenderPassIsProcessed(RenderPass renderPass) {
                if (TerrainTest5.this.waterSwitch != null) {
                    TerrainTest5.this.waterSwitch.setWhichChild(-1);
                }
            }

            public void afterRenderPassIsProcessed(RenderPass renderPass) {
                if (TerrainTest5.this.waterSwitch != null) {
                    TerrainTest5.this.waterSwitch.setWhichChild(-2);
                }
            }

            public void beforeRenderPassIsRendered(RenderPass renderPass, OpenGLLayer openGLLayer, Object glObj) {
                TerrainTest5.this.clipper.setEnabled(TerrainTest5.this.clipTerrain);
                TerrainTest5.this.water.getAppearance().setColor(Colorf.RED);
            }

            public void afterRenderPassCompleted(RenderPass renderPass, OpenGLLayer openGLLayer, Object glObj) {
                TerrainTest5.this.clipper.setEnabled(false);
                TerrainTest5.this.water.getAppearance().setColor(Colorf.BLUE);
            }
        });
        sceneGraph.getRenderer().addRenderTarget((RenderTarget)this.reflectionTarget, reflectionPass);
        this.addUpdatable(new Updatable(){

            public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                TerrainTest5.this.updateReflection(TerrainTest5.this.env);
            }
        });
    }

    private void updateReflection(SceneGraph sceneGraph) {
        Transform3D viewTransform = sceneGraph.getView().getTransform();
        Matrix4f scaleMatrix = new Matrix4f(Matrix4f.IDENTITY);
        scaleMatrix.m11(-1.0f);
        scaleMatrix.m13(2.0f * this.waterlevel);
        scaleMatrix.mul(viewTransform.getMatrix4f());
        Matrix4f reflectionMatrix = new Matrix4f(scaleMatrix);
        this.reflectionTransform.set(reflectionMatrix);
    }

    public TerrainTest5(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        up.normalize();
        this.env = new Xith3DEnvironment(new Point3f(950.0f, this.waterlevel + 70.0f, 930.0f), new Point3f(300.0f, this.waterlevel, 880.0f), up, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("skyboxes");
        resLoc.createAndAddTSL("textures");
        resLoc.createAndAddTSL("terrain");
        resLoc.createAndAddTSL("shader");
        BranchGroup scene = this.createScene(resLoc, this.env);
        this.setupReflection(this.env, scene);
        this.env.addPerspectiveBranch(scene);
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        this.env.addCanvas(this.canvas);
        this.canvas.setWireframeMode(false);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        this.gui = new HUD(this.canvas);
        this.env.addHUD(this.gui);
        this.setupGUI();
        this.fpHandler = new FirstPersonInputHandler((Transformable)this.env.getView(), this.env.getCanvas(), 1.5f, 1.5f, arguments.getMouseYInverted(), this.movementSpeed);
        this.fpHandler.getBindingsManager().createDefaultBindings();
        this.fpHandler.getBindingsManager().unbind(Keys.SPACE);
        InputSystem.getInstance().addInputHandler(this.fpHandler);
        this.addFPSListener(new CanvasFPSListener(this.canvas){

            protected String getDynamicTitlePart(float fps, boolean limited) {
                return super.getDynamicTitlePart(fps, limited) + ", tolerance: " + TerrainTest5.this.tolerance;
            }
        });
    }

    public static void main(String[] args) throws Throwable {
        TerrainTest5 test = new TerrainTest5(TerrainTest5.parseCommandLine(args));
        test.begin();
    }
}

