/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.terrain;

import net.java.dev.joode.util.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.loaders.shaders.impl.glsl.GLSLShaderLoader;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.GLSLContext;
import org.xith3d.scenegraph.GLSLFragmentShader;
import org.xith3d.scenegraph.GLSLParameters;
import org.xith3d.scenegraph.GLSLShaderProgram;
import org.xith3d.scenegraph.GLSLVertexShader;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureUnit;
import org.xith3d.scenegraph.primitives.Grid;

public class Water
extends Grid
implements Updatable {
    private GLSLContext shaderProg;
    private float fogDistance = 40.0f;
    private float fogBoundary = 2000.0f;
    private float[] fogColor = new float[4];

    public Water(float width, float height, int repeat, ResourceLocator resLoc, Texture reflection, String normalMap, String dudvMap, Colorf fogColor) {
        super(width, height, 32, 32, (Texture)null);
        fogColor.get(this.fogColor);
        Appearance a = this.getAppearance(true);
        Material mat = new Material();
        mat.setAmbientColor(Colorf.WHITE);
        mat.setLightingEnabled(false);
        a.setMaterial(mat);
        TextureLoader tl = TextureLoader.getInstance();
        TextureAttributes ta = new TextureAttributes(TextureAttributes.REPLACE, null, null, TextureAttributes.NICEST);
        TextureUnit reflectionUnit = new TextureUnit(reflection, ta, null);
        TextureUnit normalMapUnit = new TextureUnit(tl.getTexture(normalMap, Texture.MipmapMode.MULTI_LEVEL_MIPMAP), ta, null);
        TextureUnit dudvMapUnit = new TextureUnit(tl.getTexture(dudvMap, Texture.MipmapMode.MULTI_LEVEL_MIPMAP), ta, null);
        a.setTextureUnits(reflectionUnit, normalMapUnit, dudvMapUnit);
        GLSLContext.setDebuggingEnabled(true);
        try {
            GLSLVertexShader vertexShader = GLSLShaderLoader.getInstance().loadVertexShader(resLoc.getResource("shader/water/water.glslvert"));
            GLSLFragmentShader fragmentShader = GLSLShaderLoader.getInstance().loadFragmentShader(resLoc.getResource("shader/water/water.glslfrag"));
            this.shaderProg = new GLSLContext(new GLSLShaderProgram(vertexShader, fragmentShader));
            GLSLParameters params = this.shaderProg.getUniformParameters();
            params.setUniformVar("reflection", 0);
            params.setUniformVar("normalMap", 1);
            params.setUniformVar("dudvMap", 2);
            params.setUniformVar("FogColor", 3, this.fogColor);
            params.setUniformVar("FogDistance", this.fogDistance);
            params.setUniformVar("FogBoundary", this.fogBoundary);
            params.setUniformVar("lightpos", 4, 100.0f, 100.0f, 100.0f, 0.0f);
            params.setUniformVar("time", 0.1f);
            params.setUniformVar("time2", 0.1f);
            params.setUniformVar("waterColor", new Tuple3f(0.0f, 0.8f, 1.0f));
            params.setUniformVar("waterDepth", 30.0f);
            a.setShaderProgramContext(this.shaderProg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setAppearance(a);
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        float gameSeconds = timingMode.getSecondsAsFloat(gameTime);
        this.shaderProg.getUniformParameters().setUniformVar("time", FastMath.sin(gameSeconds / 0.8f) / 100.0f);
        this.shaderProg.getUniformParameters().setUniformVar("time2", gameSeconds / 6.0f);
    }
}

