/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.texture;

import java.util.Random;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.FastMath;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureUnit;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.GeometryConstruct;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Multi-texturing test"}, authors={"David Yazel", "Marvin Froehlich (aka Qudus)"})
public class MultitextureTest
extends Xith3DTest {
    private Transform3D t3dRotate;
    private Transform3D t3dTranslate;
    private Vector3f translation;
    private TransformGroup tf_1;
    private TransformGroup tf_2;
    private float angle = 0.0f;
    private float translateValue = 0.0f;
    private float translateDir = 1.0f;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
        }
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        this.t3dRotate.rotXYZ(this.angle, this.angle, this.angle);
        this.tf_2.setTransform(this.t3dRotate);
        this.translation.setX(this.translateValue);
        this.translation.setZ(-3.0f);
        this.t3dTranslate.setTranslation(this.translation);
        this.tf_1.setTransform(this.t3dTranslate);
        if (this.translateDir > 0.0f) {
            this.translateValue += 0.01f;
            if (this.translateValue >= 5.0f) {
                this.translateDir = -1.0f;
            }
        } else {
            this.translateValue -= 0.01f;
            if (this.translateValue <= -5.0f) {
                this.translateDir = 1.0f;
            }
        }
        this.angle += 7.32E-4f;
        if (this.angle >= (float)Math.PI * 2) {
            this.angle = 0.0f;
        }
    }

    private Shape3D createMultiTexCube(Appearance app) {
        int features = 9;
        GeometryConstruct gc = Cube.createGeometryConstructTA(0.3f, 9, false, 2);
        TriangleArray geom = new TriangleArray(gc.numVertices());
        geom.setCoordinates(0, gc.getCoordinates());
        geom.setTextureCoordinates(0, 0, gc.getTextureCoordinates2f());
        geom.setTexCoordData(1, geom.getTexCoordsData(0));
        return new Shape3D(geom, app);
    }

    private BranchGroup createScene() {
        Texture[] textures = new Texture[]{TextureLoader.getInstance().getTexture("stone.jpg"), TextureLoader.getInstance().getTexture("cross.jpg")};
        this.t3dRotate = new Transform3D();
        this.t3dTranslate = new Transform3D();
        this.translation = new Vector3f();
        this.tf_1 = new TransformGroup(this.t3dTranslate);
        this.tf_2 = new TransformGroup(this.t3dRotate);
        Group bg_1 = new Group();
        bg_1.addChild(this.tf_1);
        this.tf_1.addChild(this.tf_2);
        Appearance app = new Appearance();
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        TextureAttributes ta = new TextureAttributes(TextureAttributes.MODULATE, null, null, TextureAttributes.NICEST);
        TextureUnit tu0 = new TextureUnit(textures[0], ta, null);
        TextureUnit tu1 = new TextureUnit(textures[1], ta, null);
        app.setTextureUnits(tu0, tu1);
        Random ran = new Random(System.nanoTime());
        for (int i = 0; i < 300; ++i) {
            Shape3D cube = this.createMultiTexCube(app);
            StaticTransform.translate(cube, 2.0f - 4.0f * ran.nextFloat(), 2.0f - 4.0f * ran.nextFloat(), 2.0f - 4.0f * ran.nextFloat());
            this.tf_2.addChild(cube);
        }
        return new BranchGroup((Node)bg_1);
    }

    public MultitextureTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        env.getView().setFieldOfView(FastMath.toRad(35.0f));
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createScene());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        MultitextureTest test = new MultitextureTest(MultitextureTest.parseCommandLine(args));
        test.begin();
    }
}

