/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.texture;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyStateEvent;
import org.jagatoo.opengl.enums.TextureFilter;
import org.openmali.FastMath;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.ProjectiveTextureUnit;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Box;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.borders.BevelBorder;
import org.xith3d.ui.hud.listeners.SliderListener;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.hud.widgets.Slider;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.interpolate.AngleInterpolater;

@Xith3DTest.Description(fulltext={"A simple testcase for projective textures"}, authors={"Marvin Froehlich (aka Qudus)"})
public class ProjectiveTexturesTest
extends Xith3DTest {
    private View projector;
    private TransformGroup projTG;
    private Point3f projectorBasePos = new Point3f(0.0f, 5.0f, 0.0f);
    private Point3f projectorPos = new Point3f();
    private Vector3f tmpVec = new Vector3f();
    private Matrix3f mat = new Matrix3f();
    private AngleInterpolater angleInter = new AngleInterpolater(1.5707964f);
    private AngleInterpolater angleInter2 = new AngleInterpolater((float)Math.PI * 2);
    private FirstPersonInputHandler fpih;

    public void onKeyStateChanged(KeyStateEvent e, Key key, boolean state) {
        switch (key.getKeyID()) {
            case LEFT_CONTROL: {
                this.fpih.setSuspended(state);
            }
        }
    }

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    protected void onRenderLoopStarted() {
        super.onRenderLoopStarted();
        this.angleInter.startIncreasing(this.getGameMicroTime());
        this.angleInter2.startDecreasing(this.getGameMicroTime());
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        float angle = this.angleInter.getValue(gameTime, timingMode);
        float angle2 = this.angleInter2.getValue(gameTime, timingMode);
        this.tmpVec.set(2.0f, 0.0f, 0.0f);
        this.mat.rotY(angle);
        this.mat.transform(this.tmpVec);
        this.projectorPos.add(this.projectorBasePos, this.tmpVec);
        this.tmpVec.set(1.0f, -5.0f, 0.0f);
        this.mat.rotY(angle2);
        this.mat.transform(this.tmpVec);
        this.projTG.getTransform().lookAlong(this.projectorPos, this.tmpVec, Vector3f.NEGATIVE_Z_AXIS);
        this.projTG.updateTransform();
        this.projector.setTransform(this.projTG.getTransform());
    }

    private Shape3D createSteps() {
        int numSteps = 10;
        float stepWidth = 8.0f;
        float halfStepWidth = 4.0f;
        float stepDepth = 0.5f;
        Tuple3f[] coords = new Point3f[120];
        TexCoord2f[] texCoords = new TexCoord2f[coords.length];
        for (int i = 0; i < 10; ++i) {
            int i_ = i * 2 * 6;
            coords[i_ + 0] = new Point3f(-4.0f, (float)(i + 0) * 0.5f, (float)(i + 0) * -0.5f);
            coords[i_ + 1] = new Point3f(4.0f, (float)(i + 0) * 0.5f, (float)(i + 0) * -0.5f);
            coords[i_ + 2] = new Point3f(-4.0f, (float)(i + 1) * 0.5f, (float)(i + 0) * -0.5f);
            coords[i_ + 3] = coords[i_ + 2];
            coords[i_ + 4] = coords[i_ + 1];
            coords[i_ + 5] = new Point3f(4.0f, (float)(i + 1) * 0.5f, (float)(i + 0) * -0.5f);
            coords[i_ + 6] = new Point3f(-4.0f, (float)(i + 1) * 0.5f, (float)(i + 0) * -0.5f);
            coords[i_ + 7] = new Point3f(4.0f, (float)(i + 1) * 0.5f, (float)(i + 0) * -0.5f);
            coords[i_ + 8] = new Point3f(-4.0f, (float)(i + 1) * 0.5f, (float)(i + 1) * -0.5f);
            coords[i_ + 9] = coords[i_ + 8];
            coords[i_ + 10] = coords[i_ + 7];
            coords[i_ + 11] = new Point3f(4.0f, (float)(i + 1) * 0.5f, (float)(i + 1) * -0.5f);
            texCoords[i_ + 0] = new TexCoord2f(0.0f, 0.0f);
            texCoords[i_ + 1] = new TexCoord2f(16.0f, 0.0f);
            texCoords[i_ + 2] = new TexCoord2f(0.0f, 1.0f);
            texCoords[i_ + 3] = texCoords[i_ + 2];
            texCoords[i_ + 4] = texCoords[i_ + 1];
            texCoords[i_ + 5] = new TexCoord2f(16.0f, 1.0f);
            texCoords[i_ + 6] = texCoords[i_ + 0];
            texCoords[i_ + 7] = texCoords[i_ + 1];
            texCoords[i_ + 8] = texCoords[i_ + 2];
            texCoords[i_ + 9] = texCoords[i_ + 3];
            texCoords[i_ + 10] = texCoords[i_ + 4];
            texCoords[i_ + 11] = texCoords[i_ + 5];
        }
        TriangleArray geom = new TriangleArray(coords.length);
        geom.setCoordinates(0, coords);
        geom.setTextureCoordinates(0, 0, texCoords);
        StaticTransform.translate(geom, 0.0f, -2.5f, 2.5f);
        StaticTransform.rotateX(geom, -0.7853982f);
        geom.calculateFaceNormals();
        geom.invertNormals();
        Appearance app = new Appearance();
        app.setTexture("stone.jpg");
        app.getTexture().setFilter(TextureFilter.TRILINEAR);
        Shape3D shape = new Shape3D(geom, app);
        return shape;
    }

    private ProjectiveTextureUnit createProjective() {
        ProjectiveTextureUnit projTU = new ProjectiveTextureUnit("jplogo.png");
        this.projector = projTU.getProjector();
        this.projector.setFieldOfView(FastMath.toRad(10.0f));
        return projTU;
    }

    private BranchGroup createScene() {
        BranchGroup scene = new BranchGroup();
        Shape3D steps = this.createSteps();
        scene.addChild(steps);
        steps.getAppearance().setTextureUnit(1, this.createProjective());
        this.projTG = new TransformGroup();
        Box projectorModel = new Box(0.0f, 0.0f, 0.35f, 0.2f, 0.2f, 0.7f, "brushedMetal.png");
        this.projTG.addChild(projectorModel);
        scene.addChild(this.projTG);
        return scene;
    }

    private HUD createHUD(Sized2iRO size) {
        HUD hud = new HUD(size, 800.0f);
        Panel p = new Panel(200.0f, 75.0f, Colorf.LIGHT_GRAY);
        p.setBorder(new BevelBorder(BevelBorder.Type.RAISED));
        final Label l1 = new Label(170.0f, 16.0f, "Spread-angle: ");
        p.addWidget(l1, 10.0f, 10.0f);
        Slider slider = new Slider(170.0f, 16.0f);
        slider.setMinMaxAndValue(0, 60, 0);
        slider.addSliderListener(new SliderListener(){

            public void onSliderValueChanged(Slider slider, int newValue) {
                l1.setText("Spread-angle: " + newValue + '\u00b0');
                ProjectiveTexturesTest.this.projector.setFieldOfView(FastMath.toRad(newValue));
            }
        });
        slider.setValue((int)FastMath.toDeg(this.projector.getFieldOfView()));
        p.addWidget(slider, 10.0f, 30.0f);
        hud.getContentPane().addWidget(p, 10.0f, 10.0f);
        Label info = new Label(hud.getResX(), 40.0f, "Hold LEFT_CTRL to get HUD control.", HUDFont.getFont("Verdana", HUDFont.PLAIN, 18), Colorf.WHITE, TextAlignment.CENTER_LEFT);
        info.setPadding(10);
        hud.getContentPane().addWidget(info, 0.0f, hud.getResY() - info.getHeight());
        return hud;
    }

    public ProjectiveTexturesTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(-6.813648f, 4.8754387f, 3.718038f, -5.9804096f, 4.449732f, 3.365211f, 0.39201087f, 0.90486115f, -0.16599326f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createScene());
        env.addHUD(this.createHUD(arguments.getResolution()));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.fpih = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)canvas, arguments.getMouseYInverted());
        this.fpih.getBindingsManager().unbind(Keys.SPACE);
        InputSystem.getInstance().addInputHandler(this.fpih);
    }

    public static void main(String[] args) throws Throwable {
        ProjectiveTexturesTest test = new ProjectiveTexturesTest(ProjectiveTexturesTest.parseCommandLine(args));
        test.begin();
    }
}

