/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.texture;

import java.awt.RenderingHints;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.RenderLoop;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.scenegraph.primitives.DrawRectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.interpolate.AngleInterpolater;

@Xith3DTest.Description(fulltext={"This test demonstrates, how to update a Texture to create", "a radar."}, authors={"Marvin Froehlich (aka Qudus)"})
public class RadarTest
extends Xith3DTest {
    private static final int TEX_SIZE = 150;
    private static final Colorf RADAR_BACKGROUND = Colorf.newReadOnly(0.57f, 1.0f, 0.64f, 0.5f);
    private static final Colorf RADAR_ROTATOR_COLOR = Colorf.newReadOnly(0.0f, 1.0f, 0.0f, 0.1f);
    private static final Colorf OBJECT_COLOR = Colorf.newReadOnly(0.0f, 0.5f, 0.0f, 0.0f);
    private static final Colorf tmpColor = new Colorf();
    private TextureImage2D radarBaseImage;
    private Texture2D radarTex;
    private final AngleInterpolater angleInter = new AngleInterpolater(0.0f, 2.0f, 0.0f, (float)Math.PI * 2, true);
    private long t1 = -1L;
    private Texture2DCanvas.DrawCallback2D drawCallback = new Texture2DCanvas.DrawCallback2D(){

        public boolean needsRedraw(long nanoTime) {
            long t = System.nanoTime();
            if (t > RadarTest.this.t1) {
                RadarTest.this.t1 = t + 5000000L;
                return true;
            }
            return false;
        }

        public void drawTexture(Texture2DCanvas texCanvas, int texWidth, int texHeight) {
            float angle = (float)Math.PI * 2 - (RadarTest.this.angleInter.isStopped() ? 0.0f : RadarTest.this.angleInter.getValue(RadarTest.this.getGameMicroTime()));
            TextureImage2D image = texCanvas.getImage();
            texCanvas.beginUpdateRegionComplete();
            image.clear(RadarTest.this.radarBaseImage, true, null);
            texCanvas.setAntialiazingEnabled(true);
            int angStart = (int)FastMath.toDeg(angle) - 5;
            if (angStart < 0) {
                angStart = 360 + angStart;
            }
            texCanvas.setColor(RADAR_ROTATOR_COLOR);
            texCanvas.fillArc(0, 0, 149, 149, angStart, 10);
            float objDispStartAngle = FastMath.toRad(160.0f);
            float objDispEndAngle = objDispStartAngle - FastMath.toRad(90.0f);
            if (angle <= objDispStartAngle && angle >= objDispEndAngle) {
                float objDispAngle = FastMath.toRad(157.0f);
                float objDist = 56.25f;
                int objX = (int)(FastMath.cos(objDispAngle) * objDist);
                int objY = (int)(FastMath.sin(objDispAngle) * objDist);
                int objRadius = 3;
                tmpColor.set(OBJECT_COLOR);
                tmpColor.setAlpha((objDispStartAngle - angle) / (objDispStartAngle - objDispEndAngle));
                texCanvas.setColor(tmpColor);
                texCanvas.fillArc(75 + objX - objRadius, 75 - objY - objRadius, objRadius << 1, objRadius << 1, 0, 360);
            }
            texCanvas.setAntialiazingEnabled(false);
            texCanvas.finishUpdateRegion();
        }
    };

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private TextureImage2D createRadarBaseTexture() {
        Texture2D radarBaseTex = Texture2D.createOfflineDrawTexture(TextureFormat.RGBA, 150, 150, false);
        Texture2DCanvas g = radarBaseTex.getTextureCanvas();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(RADAR_BACKGROUND.getAWTColor());
        g.fillArc(0, 0, 149, 149, 0, 360);
        return radarBaseTex.getImage0();
    }

    private RenderPass createRenderPass() {
        RenderPass rp = RenderPass.create2D(800, 600);
        this.radarBaseImage = this.createRadarBaseTexture();
        DrawRectangle rect = new DrawRectangle(150.0f, 150.0f, true);
        StaticTransform.translate(rect, (800.0f - rect.getWidth()) / 2.0f, -(600.0f - rect.getHeight()) / 2.0f, 0.0f);
        this.radarTex = rect.getTexture();
        this.radarTex.getTextureCanvas().addDrawCallback(this.drawCallback);
        rp.getBranchGroup().addChild(rect);
        return rp;
    }

    protected void onRenderLoopStarted() {
        super.onRenderLoopStarted();
        this.angleInter.startIncreasing(this.getGameMicroTime());
    }

    public RadarTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addRenderPass(this.createRenderPass());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.begin(RenderLoop.RunMode.RUN_IN_SAME_THREAD);
    }

    public static void main(String[] args) throws Throwable {
        RadarTest test = new RadarTest(RadarTest.parseCommandLine(args));
        test.begin();
    }
}

