/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.texture;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.opengl.enums.TextureBoundaryMode;
import org.jagatoo.opengl.enums.TextureFilter;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector2f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GlobalOptions;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.StateButton;
import org.xith3d.ui.hud.borders.EmptyBorder;
import org.xith3d.ui.hud.layout.ListLayout;
import org.xith3d.ui.hud.listeners.WidgetStateListener;
import org.xith3d.ui.hud.utils.ButtonGroup;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.hud.widgets.RadioButton;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Texture Filters test"}, authors={"Marvi Froehlich (aka Qudus)"})
public class TextureFiltersTest
extends Xith3DTest {
    private RotatableGroup testRotateYGroup;
    private Texture2D[] textures;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                if (this.testRotateYGroup.isAnimating()) {
                    this.testRotateYGroup.stopAnimation();
                    break;
                }
                this.testRotateYGroup.startAnimation(this.getGameTime(), this.getTimingMode());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private HUD createHUD(Sized2iRO canvasRes) {
        HUD hud = new HUD(canvasRes, 800.0f);
        Panel panel = new Panel(200.0f, 160.0f, new Colorf(Colorf.LIGHT_GRAY, 0.5f));
        panel.setBorder(new EmptyBorder(10));
        panel.setLayout(new ListLayout(ListLayout.Orientation.VERTICAL));
        panel.addWidget(new Label(200.0f, 20.0f, "Texture-Filter:"));
        ButtonGroup groupFilters = new ButtonGroup();
        RadioButton rb = new RadioButton(200.0f, 20.0f, TextureFilter.POINT.name());
        rb.setUserObject((Object)TextureFilter.POINT);
        groupFilters.addStateButton(rb);
        rb.setState(true);
        panel.addWidget(rb);
        rb = new RadioButton(200.0f, 20.0f, TextureFilter.BILINEAR.name());
        rb.setUserObject((Object)TextureFilter.BILINEAR);
        groupFilters.addStateButton(rb);
        rb.setState(false);
        panel.addWidget(rb);
        rb = new RadioButton(200.0f, 20.0f, TextureFilter.TRILINEAR.name());
        rb.setUserObject((Object)TextureFilter.TRILINEAR);
        groupFilters.addStateButton(rb);
        rb.setState(false);
        panel.addWidget(rb);
        rb = new RadioButton(200.0f, 20.0f, TextureFilter.ANISOTROPIC_2.name());
        rb.setUserObject((Object)TextureFilter.ANISOTROPIC_2);
        groupFilters.addStateButton(rb);
        rb.setState(false);
        panel.addWidget(rb);
        rb = new RadioButton(200.0f, 20.0f, TextureFilter.ANISOTROPIC_4.name());
        rb.setUserObject((Object)TextureFilter.ANISOTROPIC_4);
        groupFilters.addStateButton(rb);
        rb.setState(false);
        panel.addWidget(rb);
        rb = new RadioButton(200.0f, 20.0f, TextureFilter.ANISOTROPIC_8.name());
        rb.setUserObject((Object)TextureFilter.ANISOTROPIC_8);
        groupFilters.addStateButton(rb);
        rb.setState(false);
        panel.addWidget(rb);
        rb = new RadioButton(200.0f, 20.0f, TextureFilter.ANISOTROPIC_16.name());
        rb.setUserObject((Object)TextureFilter.ANISOTROPIC_16);
        groupFilters.addStateButton(rb);
        rb.setState(false);
        panel.addWidget(rb);
        groupFilters.addStateListener(new WidgetStateListener(){

            public void onButtonStateChanged(StateButton stateButton, boolean state, Object userObject) {
                GlobalOptions.getInstance().setTextureFilter((TextureFilter)((Object)userObject));
            }
        });
        hud.getContentPane().addWidget(panel, 20.0f, 20.0f);
        return hud;
    }

    private BranchGroup createSceneGraph(Animator animator) {
        BranchGroup root = new BranchGroup();
        this.testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.08f, 0.0f));
        TransformGroup scaleTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        scaleTransform.setTransform(t);
        this.testRotateYGroup.addChild(scaleTransform);
        TextureLoader.getInstance().getCache().setEnabled(false);
        this.textures = new Texture2D[2];
        this.textures[0] = TextureLoader.getInstance().getTexture("stone.jpg", Texture.MipmapMode.MULTI_LEVEL_MIPMAP);
        this.textures[0].setBoundaryModes(TextureBoundaryMode.WRAP, TextureBoundaryMode.WRAP);
        Rectangle rect = new Rectangle(2.0f, 32.0f, this.textures[0], Vector2f.ZERO, new Vector2f(1.0f, 32.0f));
        rect.setName("Rect1");
        StaticTransform.rotateX(rect, 1.5707964f);
        StaticTransform.translate(rect, 1.625f, -1.0f, 0.0f);
        scaleTransform.addChild(rect);
        this.textures[1] = this.textures[0].cloneNodeComponent(false);
        for (int i = this.textures[1].getImagesCount() - 1; i >= 1; --i) {
            this.textures[1].setImage(i, null);
        }
        rect = new Rectangle(2.0f, 32.0f, this.textures[1], Vector2f.ZERO, new Vector2f(1.0f, 32.0f));
        rect.setName("Rect2");
        StaticTransform.rotateX(rect, 1.5707964f);
        StaticTransform.translate(rect, -1.625f, -1.0f, 0.0f);
        scaleTransform.addChild(rect);
        GlobalOptions.getInstance().setTextureFilter(TextureFilter.POINT);
        root.addChild(this.testRotateYGroup);
        animator.addAnimatableObject(this.testRotateYGroup);
        return root;
    }

    public TextureFiltersTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup rootBranch = this.createSceneGraph(this.getAnimator());
        env.addPerspectiveBranch(rootBranch);
        env.addHUD(this.createHUD(arguments.getResolution()));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle projection policy, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        TextureFiltersTest test = new TextureFiltersTest(TextureFiltersTest.parseCommandLine(args));
        test.begin();
    }
}

