/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.texture;

import java.awt.geom.Rectangle2D;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.scenegraph.primitives.DrawRectangle;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This testcase demonstrates, how to directly draw/paint", "to a Texture2D using a Graphics2D."}, authors={"Marvin Froehlich (aka Qudus)"})
public class TexturePainterTest
extends Xith3DTest {
    private Texture2D drawTexture;
    private TextureImage2D sampleImage;
    private int[] texSizes = new int[]{32, 64, 128, 256};
    private int currTexSizeIndex = 3;
    private Texture2DCanvas.DrawCallback2D drawCallback = new Texture2DCanvas.DrawCallback2D(){

        public void drawTexture(Texture2DCanvas texCanvas, int texWidth, int texHeight) {
            System.out.println("redrawing texture...");
            System.out.println("  texture size: " + texWidth + "x" + texHeight);
            texCanvas.beginUpdateRegionComplete();
            texCanvas.getImage().clear(true, null);
            texCanvas.setAntialiazingEnabled(true);
            texCanvas.setColor(Colorf.WHITE);
            texCanvas.drawCircle(texWidth / 2, texHeight / 2, (int)((double)Math.min(texWidth, texHeight) * 0.45));
            texCanvas.setAntialiazingEnabled(false);
            texCanvas.finishUpdateRegion();
        }
    };

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.currTexSizeIndex = (this.currTexSizeIndex + 1) % this.texSizes.length;
                int texSize = this.texSizes[this.currTexSizeIndex];
                TextureImage2D ic = this.drawTexture.getImage0();
                ic.initImageData(texSize, texSize, false, false);
                this.drawTexture.setSizeChanged();
                this.drawCallback.setDirty(true);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private Rectangle createButton(int left, int top, int width, int height) {
        final Button.Description buttonDesc = HUD.getTheme().getButtonDescription();
        DrawRectangle rect = new DrawRectangle((float)width, (float)height, true);
        Texture2DCanvas texCanvas = rect.getTextureCanvas();
        texCanvas.addDrawCallback(new Texture2DCanvas.DrawCallback2D(){

            public void drawTexture(Texture2DCanvas texCanvas, int texWidth, int texHeight) {
                texCanvas.beginUpdateRegionComplete();
                TextureImage2D ic = texCanvas.getImage();
                texCanvas.setAntialiazingEnabled(false);
                ic.clear(true, null);
                TextureImage2D btex = buttonDesc.getTextureNormal().getImage0();
                int srcOrgW = btex.getOriginalWidth();
                int srcOrgH = btex.getOriginalHeight();
                int srcBottomH = buttonDesc.getBottomHeight();
                int srcRightW = buttonDesc.getRightWidth();
                int srcTopH = buttonDesc.getTopHeight();
                int srcLeftW = buttonDesc.getLeftWidth();
                int srcRightLeft = srcOrgW - srcRightW;
                int srcBottomTop = srcOrgH - srcBottomH;
                int trgRightLeft = texWidth - srcRightW;
                int trgBottomTop = texHeight - srcBottomH;
                int srcBodyWidth = srcOrgW - srcLeftW - srcRightW;
                ic.drawImage(btex, 0, srcBottomTop, srcLeftW, srcBottomH, 0, trgBottomTop, true, null);
                ic.drawImage(btex, srcRightLeft, srcBottomTop, srcRightW, srcBottomH, trgRightLeft, trgBottomTop, true, null);
                ic.drawImage(btex, srcRightLeft, 0, srcRightW, srcTopH, trgRightLeft, 0, true, null);
                ic.drawImage(btex, 0, 0, srcLeftW, srcTopH, 0, 0, true, null);
                ic.drawImage(btex, srcLeftW, srcBottomTop, srcOrgW - srcLeftW - srcRightW, srcBottomH, srcLeftW, trgBottomTop, texWidth - srcLeftW - srcRightW, srcBottomH, true, null);
                ic.drawImage(btex, srcRightLeft, srcTopH, srcRightW, srcOrgH - srcTopH - srcBottomH, trgRightLeft, srcTopH, srcRightW, texHeight - srcTopH - srcBottomH, true, null);
                ic.drawImage(btex, srcLeftW, 0, srcOrgW - srcLeftW - srcRightW, srcTopH, srcLeftW, 0, texWidth - srcLeftW - srcRightW, srcTopH, true, null);
                ic.drawImage(btex, 0, srcTopH, srcLeftW, srcOrgH - srcTopH - srcBottomH, 0, srcTopH, srcLeftW, texHeight - srcTopH - srcBottomH, true, null);
                ic.drawImage(btex, srcLeftW, srcTopH, srcBodyWidth, srcOrgH - srcTopH - srcBottomH, srcLeftW, srcTopH, texWidth - srcLeftW - srcRightW, texHeight - srcTopH - srcBottomH, true, null);
                texCanvas.setAntialiazingEnabled(false);
                String text = "Click me!";
                Rectangle2D bounds = texCanvas.getFontMetrics().getStringBounds(text, null);
                texCanvas.setColor(Colorf.BLACK);
                texCanvas.drawString(text, texWidth / 2 - (int)(bounds.getWidth() / 2.0), texHeight / 2 + (int)(bounds.getHeight() / 3.0));
                texCanvas.setAntialiazingEnabled(false);
                texCanvas.finishUpdateRegion();
            }
        });
        StaticTransform.translate(rect, (float)left, -((float)top), 0.0f);
        return rect;
    }

    private void createSceneGraph(Sized2iRO canvasRes, SceneGraph sceneGraph) {
        RenderPass renderPass = RenderPass.create2D(canvasRes);
        BranchGroup scene = renderPass.getBranchGroup();
        this.drawTexture = Texture2D.createDrawTexture(TextureFormat.RGBA, 256, 256, true);
        Texture2DCanvas texCanvas = this.drawTexture.getTextureCanvas();
        texCanvas.addDrawCallback(this.drawCallback);
        Rectangle rect = new Rectangle(256.0f, 256.0f, Rectangle.ZeroPointLocation.TOP_LEFT, (Texture)this.drawTexture);
        StaticTransform.translate(rect, 100.0f, -100.0f, 0.0f);
        scene.addChild(rect);
        Texture2D sampleTex = TextureLoader.getInstance().getTexture("jplogo.png", Texture.MipmapMode.BASE_LEVEL);
        this.sampleImage = sampleTex.getImage0();
        Rectangle sampleRect = new Rectangle((float)sampleTex.getOriginalWidth(), (float)sampleTex.getOriginalHeight(), Rectangle.ZeroPointLocation.TOP_LEFT, (Texture)sampleTex);
        StaticTransform.translate(sampleRect, 100.0f + rect.getWidth() + 100.0f, -100.0f, 0.0f);
        scene.addChild(sampleRect);
        Rectangle button = this.createButton(100, 465, 100, 30);
        scene.addChild(button);
        sceneGraph.addRenderPass(renderPass);
    }

    public TexturePainterTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(arguments.getResolution(), env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        TexturePainterTest test = new TexturePainterTest(TexturePainterTest.parseCommandLine(args));
        test.begin();
    }
}

