/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import org.jagatoo.input.devices.components.MouseButton;
import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.ui.HUDContextMenuTest;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.contextmenu.ContextMenu;
import org.xith3d.ui.hud.contextmenu.ContextMenuItem;
import org.xith3d.ui.hud.layout.GridLayout;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.utility.commandline.BasicApplicationArguments;

@Xith3DTest.Description(fulltext={"This test demonstrates a custom HUD ContextMenu.<br>", "The menu items are constructed of Image Widgets."}, authors={"Marvin Froehlich (aka Qudus)"})
public class HUDCustomContextMenuTest
extends HUDContextMenuTest {
    protected ContextMenu createImageContextMenu() {
        CustomContextMenu contextMenu = new CustomContextMenu();
        contextMenu.addItem(new CustomContextMenuItem("brushedMetal.png", "brushedMetal"));
        contextMenu.addItem(new CustomContextMenuItem("crate.png", "crate"));
        contextMenu.addItem(new CustomContextMenuItem("rustycan.jpg", "rustycan"));
        contextMenu.addItem(new CustomContextMenuItem("wood.jpg", "wood"));
        return contextMenu;
    }

    public HUDCustomContextMenuTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments);
    }

    public static void main(String[] args) throws Throwable {
        HUDCustomContextMenuTest test = new HUDCustomContextMenuTest(HUDCustomContextMenuTest.parseCommandLine(args));
        test.begin();
    }

    private static class CustomContextMenuItem
    extends Image
    implements ContextMenuItem {
        private ContextMenu contextMenu = null;
        private boolean ishovered = false;

        public final boolean clickCausesMenuHide() {
            return true;
        }

        public void setContextMenu(ContextMenu contextMenu) {
            this.contextMenu = contextMenu;
            if (contextMenu == null) {
                this.detach();
            } else {
                contextMenu.getMenuItemsContainer().addWidget(this);
            }
        }

        public ContextMenu getContextMenu() {
            return this.contextMenu;
        }

        protected void markHovered() {
            this.ishovered = true;
            this.setTextureDirty();
        }

        protected void markFree() {
            this.ishovered = false;
            this.setTextureDirty();
        }

        public void onMouseEntered(boolean isTopMost, boolean hasFocus) {
            super.onMouseEntered(isTopMost, hasFocus);
            if (isTopMost) {
                this.markHovered();
            }
        }

        public void onMouseExited(boolean isTopMost, boolean hasFocus) {
            super.onMouseExited(isTopMost, hasFocus);
            this.markFree();
        }

        public void onMouseButtonReleased(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
            super.onMouseButtonReleased(button, x, y, when, lastWhen, isTopMost, hasFocus);
            if (isTopMost) {
                this.contextMenu.onItemClicked(this);
                this.markFree();
            }
        }

        protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
            super.drawWidget(texCanvas, offsetX, offsetY, width, height, drawsSelf);
            if (this.ishovered) {
                Colorf oldColor = texCanvas.getColorf();
                texCanvas.setColor(new Colorf(0.5f, 0.5f, 0.5f, 0.5f));
                texCanvas.fillRect(offsetX, offsetY, width, height);
                texCanvas.setColor(oldColor);
            }
        }

        public CustomContextMenuItem(String texture, Object userObject) {
            super(50.0f, 50.0f, texture);
            this.setUserObject(userObject);
        }
    }

    private static class CustomContextMenu
    extends ContextMenu {
        protected WidgetContainer createMenuItemsContainer() {
            Panel panel = new Panel(true, 100.0f, 100.0f, HUD.getTheme().getContentPaneBackgroundColor());
            panel.setLayout(new GridLayout(2, 2));
            return panel;
        }

        public CustomContextMenu() {
            super(null, null);
        }
    }
}

