/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.layout.BorderLayout;
import org.xith3d.ui.hud.layout.CenterLayout;
import org.xith3d.ui.hud.layout.FillLayout;
import org.xith3d.ui.hud.layout.GridLayout;
import org.xith3d.ui.hud.layout.HullLayout;
import org.xith3d.ui.hud.layout.ListLayout;
import org.xith3d.ui.hud.widgets.EmptyWidget;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This test demonstrates the HUD's LayoutManagers."}, authors={"Marvin Froehlich (aka Qudus)"})
public class HUDLayoutManagersTest
extends Xith3DTest {
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createHUD(Xith3DEnvironment env, Sized2iRO resolusion) {
        HUD hud = new HUD(resolusion, 800.0f);
        Panel p1 = Panel.createContentPane(220.0f, 100.0f);
        p1.setLayout(new GridLayout(3, 3, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Label lbl = new Label(1.0f, 1.0f, "Label" + (i * 3 + j), TextAlignment.CENTER_CENTER);
                lbl.setBackgroundColor(Colorf.GREEN);
                p1.addWidget(lbl);
            }
        }
        hud.getContentPane().addWidget(p1, 20.0f, 20.0f);
        Panel p2 = Panel.createContentPane(220.0f, 100.0f);
        GridLayout gl2 = new GridLayout(3, 3, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f);
        gl2.setColWeights(0.25f, 0.4f, 0.35f);
        p2.setLayout(gl2);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (i == 1 && j == 1) {
                    p2.addWidget(new EmptyWidget());
                    continue;
                }
                Label lbl = new Label(1.0f, 1.0f, "Label" + (i * 3 + j), TextAlignment.CENTER_CENTER);
                lbl.setBackgroundColor(Colorf.GREEN);
                p2.addWidget(lbl);
            }
        }
        hud.getContentPane().addWidget(p2, 290.0f, 20.0f);
        Panel p3 = Panel.createContentPane(220.0f, 100.0f);
        p3.setLayout(new FillLayout(5.0f));
        p3.addWidget(new Image(0.0f, 0.0f, "stone.jpg"));
        hud.getContentPane().addWidget(p3, 560.0f, 20.0f);
        Panel p4 = Panel.createContentPane(220.0f, 300.0f);
        ListLayout ll = new ListLayout(ListLayout.Orientation.VERTICAL, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f);
        p4.setLayout(ll);
        for (int i = 0; i < 9; ++i) {
            if (i == 4) {
                p4.addWidget(new EmptyWidget(0.0f, 20.0f));
                continue;
            }
            Label lbl = new Label(100.0f, 20.0f, "Label" + i, TextAlignment.CENTER_CENTER);
            lbl.setBackgroundColor(Colorf.GREEN);
            p4.addWidget(lbl);
        }
        hud.getContentPane().addWidget(p4, 20.0f, 170.0f);
        Panel p5 = Panel.createContentPane(220.0f, 300.0f);
        p5.setLayout(new BorderLayout(5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f));
        p5.addWidget(new Image(0.0f, 50.0f, "stone.jpg"), (Object)BorderLayout.Area.NORTH);
        p5.addWidget(new Image(0.0f, 30.0f, "stone.jpg"), (Object)BorderLayout.Area.SOUTH);
        p5.addWidget(new Image(70.0f, 0.0f, "stone.jpg"), (Object)BorderLayout.Area.WEST);
        p5.addWidget(new Image(10.0f, 0.0f, "stone.jpg"), (Object)BorderLayout.Area.EAST);
        p5.addWidget(new Image(0.0f, 0.0f, "stone.jpg"), (Object)BorderLayout.Area.CENTER);
        hud.getContentPane().addWidget(p5, 290.0f, 170.0f);
        Panel p6 = Panel.createContentPane(220.0f, 100.0f);
        p6.setLayout(new CenterLayout(CenterLayout.Orientation.HORIZONTAL, 5.0f));
        p6.addWidget(new Image(50.0f, 50.0f, "stone.jpg"));
        p6.addWidget(new Image(50.0f, 50.0f, "stone.jpg"));
        p6.addWidget(new Image(50.0f, 50.0f, "stone.jpg"));
        hud.getContentPane().addWidget(p6, 560.0f, 170.0f);
        Panel p7 = Panel.createContentPane(0.0f, 0.0f);
        p7.setLayout(new HullLayout(25.0f, 20.0f, 25.0f, 20.0f));
        p7.addWidget(new Image(25.0f, 25.0f, "stone.jpg"), 10.0f, 20.0f);
        p7.addWidget(new Image(50.0f, 25.0f, "stone.jpg"), 140.0f, 30.0f);
        p7.addWidget(new Image(20.0f, 50.0f, "stone.jpg"), 75.0f, 30.0f);
        hud.getContentPane().addWidget(p7, 560.0f, 320.0f);
        env.addHUD(hud);
    }

    public HUDLayoutManagersTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createHUD(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
    }

    public static void main(String[] args) throws Throwable {
        HUDLayoutManagersTest test = new HUDLayoutManagersTest(HUDLayoutManagersTest.parseCommandLine(args));
        test.begin();
    }
}

