/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import java.util.ArrayList;
import org.jagatoo.commands.CommandException;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.Controller;
import org.jagatoo.input.devices.components.Keys;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.layout.CenterLayout;
import org.xith3d.ui.hud.layout.ListLayout;
import org.xith3d.ui.hud.listeners.ButtonListener;
import org.xith3d.ui.hud.menusystem.ButtonsLeftMenusCenterMenuGroupWidget;
import org.xith3d.ui.hud.menusystem.Menu;
import org.xith3d.ui.hud.menusystem.MenuGroup;
import org.xith3d.ui.hud.menusystem.MenuGroupWidget;
import org.xith3d.ui.hud.menusystem.MenuSystem;
import org.xith3d.ui.hud.menusystem.MenuSystemListener;
import org.xith3d.ui.hud.menusystem.menus.MenuBase;
import org.xith3d.ui.hud.menusystem.menus.settings.FPIHInputBindingsSettingsMenu;
import org.xith3d.ui.hud.menusystem.menus.settings.FPIHMainSettingsMenu;
import org.xith3d.ui.hud.menusystem.menus.settings.GraphicsMainSettingsMenu;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.hud.widgets.TextField;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.commands.ExitCommand;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This test demonstrates the HUD's custom MenuSystem."}, authors={"Marvin Froehlich (aka Qudus)"})
public class HUDMenuSystemTest
extends Xith3DTest {
    private MenuSystem menuSystem;
    private Label infoLabel;
    private ExitCommand exitCommand = new ExitCommand(this);
    private FirstPersonInputHandler fpih;
    private MenuSystemListener msl = new MenuSystemListener(){

        public boolean beforeMenuStateChanged(MenuSystem menuSystem, String currentMenu, Object target) {
            return false;
        }

        public void onMenuStateChanged(MenuSystem menuSystem, String oldMenu, Object target) {
            if (target instanceof ExitCommand) {
                try {
                    ((ExitCommand)target).execute();
                }
                catch (CommandException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            } else {
                MenuGroup targetMG = menuSystem.findMenuGroup(target);
                Menu targetMenu = menuSystem.findMenu(target);
                if (targetMG != null || targetMenu != null) {
                    System.out.println("changed from " + oldMenu + " to " + target);
                }
            }
        }

        public void onSettingChanged(MenuSystem menuSystem, Menu menu, String setting, Object value) {
            System.out.println("Setting changed: " + setting + " = " + value);
        }

        public boolean onMenuActionPerformed(MenuSystem menuSystem, MenuGroup menuGroup, Menu menu, String action) {
            System.out.println("action performed: " + action);
            if (action.equals("new_game")) {
                menuSystem.setVisible(false);
            }
            return true;
        }

        public void onMenuSystemEntered(MenuSystem menuSystem) {
            menuSystem.setCurrentMenuGroup("Main").setCurrentActiveMenu(null);
            HUDMenuSystemTest.this.infoLabel.setVisible(false);
        }

        public void onMenuSystemExited(MenuSystem menuSystem) {
            HUDMenuSystemTest.this.infoLabel.setVisible(true);
        }
    };

    private HUD createHUD(Xith3DEnvironment env, Sized2iRO resolution) {
        HUD hud = new HUD(resolution, 800.0f);
        this.menuSystem = new MenuSystem(hud, resolution.getWidth(), resolution.getHeight());
        this.menuSystem.setMenuSystemAccessor(Keys.ESCAPE);
        MainMenuGroup mmg = new MainMenuGroup("Main");
        mmg.addMenu("New Game", "New Game", new NewGameMenu(300.0f, "NewGame"));
        mmg.addActionButton("Load Game", null);
        mmg.addActionButton("Settings", "Settings");
        mmg.addActionButton("Exit", this.exitCommand);
        this.menuSystem.addMenuGroup(mmg);
        SettingsMenuGroup smg = new SettingsMenuGroup("Settings", mmg);
        smg.addMenu("Graphics", "Graphics", new GraphicsMainSettingsMenu(360.0f));
        smg.addMenu("Main Input", "Main Input Settings", new FPIHMainSettingsMenu(360.0f));
        smg.addMenu("Movement", "Movement Key Bindings", new FPIHInputBindingsSettingsMenu(520.0f));
        smg.addActionButton("Back", "Main");
        this.menuSystem.addMenuGroup(smg);
        this.menuSystem.addMenuSystemListener(this.msl);
        this.infoLabel = new Label(hud.getResX(), hud.getResY(), "Press ESCAPE to switch to the Menu-Mode.", HUDFont.getFont("Verdana", HUDFont.PLAIN, 24), Colorf.WHITE, TextAlignment.CENTER_CENTER);
        hud.getContentPane().addWidget(this.infoLabel);
        env.addHUD(hud);
        return hud;
    }

    private void bindController(HUD hud, Canvas3D canvas) throws Exception {
        Controller[] controllers = canvas.getInputDeviceFactory().getControllers();
        if (controllers.length > 0) {
            InputSystem.getInstance().registerController(controllers[0]);
            hud.bindFocusMoveAccessor(controllers[0].getButton(2), HUD.FocusMoveDirection.UP);
            hud.bindFocusMoveAccessor(controllers[0].getButton(3), HUD.FocusMoveDirection.DOWN);
            Button.bindAccessor(controllers[0].getButton(0));
        }
    }

    public HUDMenuSystemTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        HUD hud = this.createHUD(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.bindController(hud, canvas);
        this.fpih = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)canvas, arguments.getMouseYInverted());
        this.fpih.setMouseMovementSuspended(true);
        InputSystem.getInstance().addInputHandler(this.fpih);
        ((FPIHMainSettingsMenu)this.menuSystem.findMenu(FPIHMainSettingsMenu.NAME)).applyConfig(this.fpih);
        ((FPIHInputBindingsSettingsMenu)this.menuSystem.findMenu(FPIHInputBindingsSettingsMenu.NAME)).applyConfig(this.fpih);
    }

    public static void main(String[] args) throws Throwable {
        HUDMenuSystemTest test = new HUDMenuSystemTest(HUDMenuSystemTest.parseCommandLine(args));
        test.begin();
    }

    private class NewGameMenu
    extends MenuBase
    implements ButtonListener {
        private ArrayList<Widget> earlyWidgets;
        private final Label playerName;

        public final String getPlayerName() {
            return this.playerName.getText();
        }

        public void onButtonClicked(AbstractButton button, Object userObject) {
            this.getMenuGroup().fireOnMenuActionPerformed((String)userObject);
        }

        protected void initWidgets() {
            for (int i = 0; i < this.earlyWidgets.size(); ++i) {
                this.addWidget(this.earlyWidgets.get(i));
            }
            this.earlyWidgets = null;
            this.playerName.requestFocus();
        }

        public NewGameMenu(float width, String name) {
            super(width, name, new String[]{"new_game"});
            ListLayout layout = new ListLayout(ListLayout.Orientation.VERTICAL, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f);
            layout.setAlignment(ListLayout.Alignment.CENTER_TOP);
            layout.setOtherSpanCalculated(true);
            this.setLayout(layout);
            HUDFont font = HUDFont.getFont("Verdana", HUDFont.PLAIN, 12);
            this.earlyWidgets = new ArrayList();
            this.playerName = new TextField(100.0f, 25.0f, "Player", font, null, null);
            this.earlyWidgets.add(this.playerName);
            Panel dummy = new Panel(0.0f, 25.0f);
            dummy.setLayout(new CenterLayout());
            Button startButton = new Button(100.0f, 25.0f, "Start");
            startButton.setUserObject("new_game");
            startButton.addButtonListener(this);
            dummy.addWidget(startButton);
            this.earlyWidgets.add(dummy);
        }
    }

    private class MainMenuGroup
    extends MenuGroup {
        protected MenuGroupWidget createMenuSystemWidget(float width, float height, float resolutionX, float resolutionY) {
            return new ButtonsLeftMenusCenterMenuGroupWidget(width, height, resolutionX, resolutionY, ListLayout.Alignment.CENTER_BOTTOM, false);
        }

        public MainMenuGroup(String name) {
            super(name);
        }
    }

    private class SettingsMenuGroup
    extends MenuGroup {
        protected MenuGroupWidget createMenuSystemWidget(float width, float height, float resolutionX, float resolutionY) {
            return new ButtonsLeftMenusCenterMenuGroupWidget(width, height, resolutionX, resolutionY, ListLayout.Alignment.CENTER_TOP, true);
        }

        public SettingsMenuGroup(String name, MenuGroup previousMenuGroup) {
            super(name, previousMenuGroup);
        }
    }
}

