/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import java.awt.RenderingHints;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.FastMath;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.RenderLoop;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.interpolate.AngleInterpolater;

@Xith3DTest.Description(fulltext={"This test demonstrates, how to update an Image Widget to create", "a radar."}, authors={"Marvin Froehlich (aka Qudus)"})
public class HUDRadarTest
extends Xith3DTest {
    private static final int TEX_SIZE = 150;
    private static final Colorf RADAR_BACKGROUND = Colorf.newReadOnly(0.57f, 1.0f, 0.64f, 0.5f);
    private static final Colorf RADAR_ROTATOR_COLOR = Colorf.newReadOnly(0.0f, 1.0f, 0.0f, 0.1f);
    private static final Colorf OBJECT_COLOR = Colorf.newReadOnly(0.0f, 0.5f, 0.0f, 0.0f);
    private static final Colorf tmpColor = new Colorf();
    private TextureImage2D radarBaseImage;
    private final AngleInterpolater angleInter = new AngleInterpolater(0.0f, 2.0f, 0.0f, (float)Math.PI * 2, true);

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private Texture2D createRadarTexture() {
        Texture2D radarBaseTex = Texture2D.createOfflineDrawTexture(TextureFormat.RGBA, 150, 150, false);
        this.radarBaseImage = radarBaseTex.getImage0();
        Texture2DCanvas g = radarBaseTex.getTextureCanvas();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(RADAR_BACKGROUND.getAWTColor());
        g.fillArc(0, 0, 149, 149, 0, 360);
        return null;
    }

    private HUD createHUD(Sized2iRO resolution) {
        HUD hud = new HUD(resolution, 800.0f){

            protected WidgetContainer createDefaultContentPane(boolean heavyWeight, float resX, float resY) {
                Panel p = new Panel(true, resX, resY);
                p.setClippingEnabled(false);
                p.setName("HUD ContentPane");
                return p;
            }
        };
        this.createRadarTexture();
        hud.getContentPane().addWidgetCentered(new RadarImage(150.0f, 150.0f));
        return hud;
    }

    protected void onRenderLoopStarted() {
        super.onRenderLoopStarted();
        this.angleInter.startIncreasing(this.getGameMicroTime());
    }

    public HUDRadarTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addHUD(this.createHUD(arguments.getResolution()));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.begin(RenderLoop.RunMode.RUN_IN_SAME_THREAD);
    }

    public static void main(String[] args) throws Throwable {
        HUDRadarTest test = new HUDRadarTest(HUDRadarTest.parseCommandLine(args));
        test.begin();
    }

    private class RadarImage
    extends Image {
        protected void drawBackground(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
            TextureImage2D image = texCanvas.getImage();
            image.clear(HUDRadarTest.this.radarBaseImage, offsetX, offsetY, true, null);
        }

        protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
            float angle = (float)Math.PI * 2 - (HUDRadarTest.this.angleInter.isStopped() ? 0.0f : HUDRadarTest.this.angleInter.getValue(HUDRadarTest.this.getGameMicroTime()));
            texCanvas.setAntialiazingEnabled(true);
            int angStart = (int)FastMath.toDeg(angle) - 5;
            if (angStart < 0) {
                angStart = 360 + angStart;
            }
            texCanvas.setColor(RADAR_ROTATOR_COLOR);
            texCanvas.fillArc(offsetX, offsetY, width - 1, height - 1, angStart, 10);
            float objDispStartAngle = FastMath.toRad(160.0f);
            float objDispEndAngle = objDispStartAngle - FastMath.toRad(90.0f);
            if (angle <= objDispStartAngle && angle >= objDispEndAngle) {
                float objDispAngle = FastMath.toRad(157.0f);
                float objDist = (float)width * 0.75f / 2.0f;
                int objX = (int)(FastMath.cos(objDispAngle) * objDist);
                int objY = (int)(FastMath.sin(objDispAngle) * objDist);
                int objRadius = 3;
                tmpColor.set(OBJECT_COLOR);
                tmpColor.setAlpha((objDispStartAngle - angle) / (objDispStartAngle - objDispEndAngle));
                texCanvas.setColor(tmpColor);
                texCanvas.fillArc(offsetX + width / 2 + objX - objRadius, offsetY + height / 2 - objY - objRadius, objRadius << 1, objRadius << 1, 0, 360);
            }
            texCanvas.setAntialiazingEnabled(false);
        }

        public RadarImage(float width, float height) {
            super(true, width, height, (Texture2D)null);
            this.setForcedRedrawFrequency(200.0f);
        }
    }
}

