/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.opengl.enums.TextureFilter;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceBag;
import org.xith3d.resources.ResourceLoader;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.resources.TextureResourceRequest;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.StateButton;
import org.xith3d.ui.hud.listeners.WidgetStateListener;
import org.xith3d.ui.hud.utils.ButtonGroup;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.RadioButton;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This test is for watching the effect of texture filters", "in class Image Widged"}, authors={"Oliver Faulhaber"})
public class ImageWidgetFilterTest
extends Xith3DTest
implements WidgetStateListener {
    private Image ivImgWidget1 = null;
    private Image ivImgWidget2 = null;
    private RadioButton ivRBFastest = null;
    private RadioButton ivRBNicest = null;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onButtonStateChanged(StateButton stateButton, boolean state, Object userObject) {
        if (state) {
            Texture2D texture = (Texture2D)this.ivImgWidget2.getShape().getAppearance().getTexture();
            texture.setFilter(this.ivRBFastest.equals(stateButton) ? TextureFilter.FASTEST : TextureFilter.NICEST);
            System.out.println((Object)texture.getFilter());
        }
    }

    private ResourceBag loadResources() {
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        ResourceLoader resLoader = null;
        try {
            resLoc.createAndAddTSL();
            resLoc.createAndAddTSL("textures");
            resLoader = new ResourceLoader(resLoc);
            resLoader.addRequest(new TextureResourceRequest("textures/countdown_1.png", "img01"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resLoader.loadResources();
    }

    private BranchGroup createScene() {
        BranchGroup scene = new BranchGroup();
        Cube cube = new Cube(3.0f, "crate.png");
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.2f, 0.2f, 0.0f));
        rg.addChild(cube);
        scene.addChild(rg);
        this.getAnimator().addAnimatableObject(rg);
        return scene;
    }

    private HUD createHUD(Sized2iRO res, ResourceBag resBag) {
        HUD hud = new HUD(res);
        Texture2D tex = (Texture2D)resBag.getTexture("img01");
        Colorf col = Colorf.WHITE;
        HUDFont font = HUDFont.getFont("Arial", HUDFont.FontStyle.PLAIN, 12);
        Label lbl = null;
        this.ivImgWidget1 = new Image(true, (float)tex.getWidth(), (float)tex.getHeight(), tex);
        this.ivImgWidget2 = new Image(true, 218.0f, 218.0f, tex);
        lbl = new Label(100.0f, 20.0f, "TextureFilter: ", font, col);
        this.ivRBFastest = new RadioButton(100.0f, 20.0f, "FASTEST", font, col);
        this.ivRBNicest = new RadioButton(100.0f, 20.0f, "NICEST", font, col);
        this.ivImgWidget1.setLocation(100.0f, 100.0f);
        this.ivImgWidget2.setLocation(124 + tex.getWidth(), 100.0f);
        this.ivRBFastest.setLocation(120.0f, 10.0f);
        this.ivRBNicest.setLocation(240.0f, 10.0f);
        lbl.setLocation(10.0f, 10.0f);
        hud.getContentPane().addWidget(this.ivImgWidget1);
        hud.getContentPane().addWidget(this.ivImgWidget2);
        hud.getContentPane().addWidget(lbl);
        hud.getContentPane().addWidget(this.ivRBFastest);
        hud.getContentPane().addWidget(this.ivRBNicest);
        ButtonGroup stateGroup = new ButtonGroup();
        stateGroup.addStateButton(this.ivRBFastest);
        stateGroup.addStateButton(this.ivRBNicest);
        this.ivRBFastest.addStateListener(this);
        this.ivRBNicest.addStateListener(this);
        this.ivRBNicest.setState(true);
        return hud;
    }

    public ImageWidgetFilterTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        ResourceBag resBag = this.loadResources();
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        env.addCanvas(canvas);
        env.addPerspectiveBranch(this.createScene());
        env.addHUD(this.createHUD(arguments.getResolution(), resBag));
    }

    public static void main(String[] args) throws Throwable {
        ImageWidgetFilterTest test = new ImageWidgetFilterTest(ImageWidgetFilterTest.parseCommandLine(args));
        test.begin();
    }
}

