/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.layout.GridLayout;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This testcase tests alignment of a Label Widget."}, authors={"Marvin Froehlich (aka Qudus)"})
public class LabelAlignmentTest
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private static Label createLabel(HUDFont font, Texture2D icon, TextAlignment alignment) {
        String text = alignment.name().toLowerCase().replace('_', '-');
        Label lbl = new Label(1.0f, 1.0f, text, font, alignment);
        lbl.setBackgroundColor(Colorf.GREEN);
        lbl.setIcon(icon);
        lbl.setPadding(3);
        return lbl;
    }

    private static Panel createLabelPanel(HUDFont font, Texture2D icon) {
        Panel p = Panel.createContentPane(600.0f, 250.0f);
        p.setLayout(new GridLayout(3, 3, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f));
        p.addWidget(LabelAlignmentTest.createLabel(font, icon, TextAlignment.TOP_LEFT));
        p.addWidget(LabelAlignmentTest.createLabel(font, icon, TextAlignment.TOP_CENTER));
        p.addWidget(LabelAlignmentTest.createLabel(font, icon, TextAlignment.TOP_RIGHT));
        p.addWidget(LabelAlignmentTest.createLabel(font, icon, TextAlignment.CENTER_LEFT));
        p.addWidget(LabelAlignmentTest.createLabel(font, icon, TextAlignment.CENTER_CENTER));
        p.addWidget(LabelAlignmentTest.createLabel(font, icon, TextAlignment.CENTER_RIGHT));
        p.addWidget(LabelAlignmentTest.createLabel(font, icon, TextAlignment.BOTTOM_LEFT));
        p.addWidget(LabelAlignmentTest.createLabel(font, icon, TextAlignment.BOTTOM_CENTER));
        p.addWidget(LabelAlignmentTest.createLabel(font, icon, TextAlignment.BOTTOM_RIGHT));
        return p;
    }

    private void createHUD(Sized2iRO resolution, Xith3DEnvironment env) {
        HUD hud = new HUD(resolution, 800.0f);
        HUDFont font = HUDFont.getFont("DejaVu Sans Mono", HUDFont.PLAIN, 12);
        hud.getContentPane().addWidget(LabelAlignmentTest.createLabelPanel(font, null), 100.0f, 40.0f);
        hud.getContentPane().addWidget(LabelAlignmentTest.createLabelPanel(font, HUDTextureUtils.getTexture("userconfig_48x48.png")), 100.0f, 310.0f);
        env.addHUD(hud);
    }

    private void createSceneGraph(Xith3DEnvironment env, Sized2iRO resolution) {
        this.createHUD(resolution, env);
    }

    public LabelAlignmentTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("HUD");
        this.createSceneGraph(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        LabelAlignmentTest test = new LabelAlignmentTest(LabelAlignmentTest.parseCommandLine(args));
        test.begin();
    }
}

