/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Scrollbar;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This testcase tests the resizeability of a Label Widget."}, authors={"Marvin Froehlich (aka Qudus)"})
public class LabelResizingTest
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createHUD(Sized2iRO resolution, Xith3DEnvironment env) {
        HUD hud = new HUD(resolution, 800.0f);
        HUDFont font = HUDFont.getFont("DejaVu Sans Mono", HUDFont.PLAIN, 18);
        final Label label = new Label(100.0f, 100.0f, "Te\u00d6xtg\nLine2 and\nLinge3 also", font, Colorf.BLACK, TextAlignment.CENTER_CENTER);
        label.setBackgroundColor(Colorf.GREEN);
        hud.getContentPane().addWidgetCentered(label);
        Scrollbar sb = new Scrollbar(200.0f, Scrollbar.Direction.HORIZONTAL){

            protected void onScrollbarValueChanged(int oldValue, int newValue) {
                super.onScrollbarValueChanged(oldValue, newValue);
                label.setSize(newValue, newValue);
            }
        };
        sb.setMinAndMax(16, 512);
        sb.setValue(100);
        hud.getContentPane().addWidget(sb, (hud.getResX() - sb.getWidth()) / 2.0f, label.getTop() - 100.0f);
        env.addHUD(hud);
    }

    private void createSceneGraph(Xith3DEnvironment env, Sized2iRO resolution) {
        this.createHUD(resolution, env);
    }

    public LabelResizingTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        LabelResizingTest test = new LabelResizingTest(LabelResizingTest.parseCommandLine(args));
        test.begin();
    }
}

