/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.RenderLoop;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.LoadingPhaseController;
import org.xith3d.resources.LoadingScreenUpdater;
import org.xith3d.resources.ModelResourceRequest;
import org.xith3d.resources.ResourceBag;
import org.xith3d.resources.ResourceBagReceiver;
import org.xith3d.resources.ResourceLoader;
import org.xith3d.resources.ResourceLoaderAdapter;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.resources.ResourceRequest;
import org.xith3d.resources.TextureResourceRequest;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.listeners.ButtonListener;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.ui.hud.widgets.assemblies.LoadingScreen;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This test shows the LoadingScreen and resource loading.", "The difference to LoadingScreenTest2 is, that it loads in", "a separate thread."}, authors={"Marvin Froehlich (aka Qudus)"})
public class LoadingScreenTest2
extends Xith3DTest
implements ResourceBagReceiver {
    private static final boolean USE_SLEEPS = true;
    public ResourceBag resBag;

    public void setResourceBag(ResourceBag resBag) {
        this.resBag = resBag;
    }

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private ResourceLoader initResourceRequests(ResourceLocator resLoc) {
        ResourceLoader resLoader = new ResourceLoader(resLoc);
        resLoader.addRequest(new ModelResourceRequest("models/tris.md2", "tris"));
        resLoader.addRequest(new ModelResourceRequest("models/galleon.obj", "galleon", 0.05f));
        resLoader.addRequest(new ModelResourceRequest("models/jeep.obj", "jeep", 2.0f));
        resLoader.addRequest(new ModelResourceRequest("models/maul/models/players/Maul/lower.md3", "DarthMaul"));
        resLoader.addRequest(new TextureResourceRequest("textures/brushedMetal.png", "BrushedMetal"));
        resLoader.addRequest(new TextureResourceRequest("textures/jplogo.jpg", "jplogo"));
        resLoader.addRequest(new TextureResourceRequest("textures/grass.jpg", "grass"));
        resLoader.addResourceLoaderListener(new ResourceLoaderAdapter(){

            public void afterResourceLoaded(ResourceLoader resLoader, ResourceRequest request, Object resource) {
                try {
                    Thread.sleep(750L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        return resLoader;
    }

    private void createScene(ResourceBag resBag, SceneGraph sceneGraph) {
        BranchGroup scene = new BranchGroup();
        scene.addChild(resBag.getModel("jeep"));
        sceneGraph.addPerspectiveBranch(scene);
    }

    public LoadingScreenTest2(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        final Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL();
        ResourceLoader resLoader = this.initResourceRequests(resLoc);
        MyLoadingScreenListener l = new MyLoadingScreenListener(){

            public void onLoadingScreenNextRequested(LoadingScreen loadingScreen) {
                loadingScreen.detach();
                LoadingScreenTest2.this.createScene(LoadingScreenTest2.this.resBag, env);
            }
        };
        CustomLoadingScreen loadingScreen = CustomLoadingScreen.createWithHUD(arguments.getResolution(), "HUD/BlueBackground.jpg", 1 + resLoader.numRequests(), l);
        env.addHUD(loadingScreen.getHUD());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.getOperationScheduler().scheduleOperation(new MyLoadingPhaseController(this, resLoader, loadingScreen, this));
    }

    public static void main(String[] args) throws Throwable {
        LoadingScreenTest2 test = new LoadingScreenTest2(LoadingScreenTest2.parseCommandLine(args));
        test.begin();
    }

    private static class MyLoadingPhaseController
    extends LoadingPhaseController {
        protected ResourceBag load(ResourceLoader resLoader, LoadingScreenUpdater loadingScreenUpdater) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            loadingScreenUpdater.update("Initializing the loading process...");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return resLoader.loadResources(loadingScreenUpdater);
        }

        public MyLoadingPhaseController(RenderLoop renderLoop, ResourceLoader resLoader, LoadingScreen loadingScreen, ResourceBagReceiver rbc) {
            super(renderLoop, 5.0f, resLoader, loadingScreen, rbc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CustomLoadingScreen
    extends LoadingScreen {
        private Button btnNext = new Button(200.0f, 50.0f, "Next");

        @Override
        public void attach(WidgetContainer container) {
            super.attach(container);
            if (this.btnNext != null) {
                container.addWidget(this.btnNext, container.getResX() / 2.0f - this.btnNext.getWidth() / 2.0f, container.getResY() / 2.0f + 100.0f);
            }
        }

        @Override
        public void detach() {
            super.detach();
            if (this.btnNext != null) {
                this.btnNext.detach();
            }
        }

        @Override
        protected void updateContent(int value, int maxValue, String caption, Texture2D backgroundTexture) {
            super.updateContent(value, maxValue, caption, backgroundTexture);
            this.btnNext.setVisible(value >= maxValue);
        }

        @Override
        public void beforeResourceBundleLoaded(ResourceLoader resLoader, Class<? extends ResourceRequest> bundleType) {
        }

        private CustomLoadingScreen(float width, float height, String backgroundTexture, int numResources, final MyLoadingScreenListener listener) {
            super(width, height, backgroundTexture, numResources, "Loading resources...");
            this.btnNext.setVisible(false);
            this.btnNext.addButtonListener(new ButtonListener(){

                public void onButtonClicked(AbstractButton button, Object userObject) {
                    listener.onLoadingScreenNextRequested(CustomLoadingScreen.this);
                }
            });
        }

        public static CustomLoadingScreen createWithHUD(Sized2iRO resolution, String backgroundTexture, int numResources, MyLoadingScreenListener listener) {
            HUD hud = new HUD(resolution);
            CustomLoadingScreen ls = new CustomLoadingScreen(hud.getResX(), hud.getResY(), backgroundTexture, numResources, listener);
            ls.attach(hud.getContentPane());
            return ls;
        }
    }

    private static interface MyLoadingScreenListener {
        public void onLoadingScreenNextRequested(LoadingScreen var1);
    }
}

