/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This testcase tests, if the parent background of a Widget is correctly drawn."}, authors={"Marvin Froehlich (aka Qudus)"})
public class ParentBackgroundTest
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private static Panel createPanel(float width, float height) {
        Texture2D t = Texture2D.createOfflineDrawTexture(TextureFormat.RGB, 30, 30, true);
        Texture2DCanvas c = t.getTextureCanvas();
        TextureImage2D img = t.getImage0();
        c.beginUpdateRegionComplete();
        img.clear(Colorf.WHITE, true, null);
        c.setColor(Colorf.BLACK);
        for (int i = 0; i < 6; ++i) {
            c.drawLine(-30 + i * 10, 0, i * 10, 30);
            c.drawLine(60 - i * 10, 0, 30 - i * 10, 30);
        }
        c.finishUpdateRegion();
        Panel p = new Panel(width, height, t){

            protected void onMouseButtonPressed(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
                super.onMouseButtonPressed(button, x, y, when, lastWhen, isTopMost, hasFocus);
                this.setTextureDirty();
            }
        };
        return p;
    }

    private void createHUD(Sized2iRO resolution, Xith3DEnvironment env) {
        HUD hud = new HUD(resolution, 800.0f);
        Panel p = ParentBackgroundTest.createPanel(600.0f, 400.0f);
        final Label l = new Label(110.0f, 30.0f, "0", TextAlignment.CENTER_CENTER);
        l.setBackgroundColor(new Colorf(0.0f, 0.0f, 0.0f, 0.7f));
        p.addWidget(l, 240.0f, 185.0f);
        Interval i = new Interval(2000000L){

            protected void onIntervalHit(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                l.setText(String.valueOf(Integer.parseInt(l.getText()) + 1));
            }
        };
        this.getOperationScheduler().addInterval(i);
        hud.getContentPane().addWidgetCentered(p);
        env.addHUD(hud);
    }

    private void createSceneGraph(Xith3DEnvironment env, Sized2iRO resolution) {
        this.createHUD(resolution, env);
    }

    public ParentBackgroundTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("HUD");
        this.createSceneGraph(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        ParentBackgroundTest test = new ParentBackgroundTest(ParentBackgroundTest.parseCommandLine(args));
        test.begin();
    }
}

