/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.MouseWheelEvent;
import org.openmali.types.twodee.Rect2i;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.selection.BoundingBoxSelectable;
import org.xith3d.selection.Selectable;
import org.xith3d.selection.SelectionManager;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.listeners.QuadDividerListener;
import org.xith3d.ui.hud.widgets.QuadDivider;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple test of the four Viewports in a scene like it is", "needed in most 3D-modeler applications."}, authors={"Marvin Froehlich (aka Qudus)", "Mathias Henze (aka cylab)"})
public class QuadViewportTest
extends Xith3DTest
implements QuadDividerListener {
    private static final int NW = QuadDivider.QuadPanels.UPPER_LEFT.ordinal();
    private static final int NE = QuadDivider.QuadPanels.UPPER_RIGHT.ordinal();
    private static final int SW = QuadDivider.QuadPanels.LOWER_LEFT.ordinal();
    private static final int SE = QuadDivider.QuadPanels.LOWER_RIGHT.ordinal();
    private QuadDivider qd;
    private Rect2i[] viewports;
    private RenderPass[] renderPassMapping = new RenderPass[4];
    private SelectionManager selectionManager;
    private Cube cube;
    private RenderPass rp;
    private BranchGroup branchGroup;
    private Canvas3D canvas;
    private boolean rpmode = true;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                if (this.rp == null || this.branchGroup == null || this.canvas == null) break;
                this.selectionManager.unbind();
                boolean bl = this.rpmode = !this.rpmode;
                if (this.rpmode) {
                    System.out.println("Switching selections to RenderPass mode");
                    this.selectionManager.bind(this.branchGroup, this.rp.getConfig(), this.canvas);
                    break;
                }
                System.out.println("Switching selections to Branchgroup mode");
                this.selectionManager.bind(this.branchGroup, this.canvas);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onMouseWheelMoved(MouseWheelEvent e, int wheelDelta) {
        QuadDivider.QuadPanels qp = this.qd.getPanelUnderMouse(e.getMouse().getCurrentX(), e.getMouse().getCurrentY());
        if (qp != null) {
            RenderPass rp = this.renderPassMapping[qp.ordinal()];
            Transform3D t = rp.getConfig().getViewTransform();
            Vector3f heading = Vector3f.fromPool();
            Point3f viewPos = Point3f.fromPool();
            t.transform(Vector3f.NEGATIVE_Z_AXIS, heading);
            heading.mul(-((float)wheelDelta));
            t.getTranslation(viewPos);
            viewPos.add(heading);
            t.setTranslation(viewPos);
            Point3f.toPool(viewPos);
            Vector3f.toPool(heading);
        }
    }

    private Rect2i[] initViewports(SceneGraph sg, Sized2iRO res, BranchGroup branchGroup) {
        RenderPass passSW;
        RenderPass passNE;
        RenderPass passNW;
        int halfWidth = res.getWidth() / 2 - 5;
        int halfHeight = res.getHeight() / 2 - 5;
        this.renderPassMapping[QuadViewportTest.NW] = passNW = RenderPass.createPerspective(branchGroup);
        passNW.getConfig().setViewport(new Rect2i(0, 0, halfWidth, halfHeight));
        this.renderPassMapping[QuadViewportTest.NE] = passNE = RenderPass.createPerspective(branchGroup);
        passNE.getConfig().setViewport(new Rect2i(halfWidth, 0, halfWidth, halfHeight));
        this.renderPassMapping[QuadViewportTest.SW] = passSW = RenderPass.createPerspective(branchGroup);
        passSW.getConfig().setViewport(new Rect2i(0, halfHeight, halfWidth, halfHeight));
        RenderPass passSE = RenderPass.createPerspective(branchGroup);
        passSE.getConfig().setViewport(new Rect2i(halfWidth, halfHeight, halfWidth, halfHeight));
        this.renderPassMapping[QuadViewportTest.SE] = passSE;
        passNW.getConfig().setRenderOptions(new RenderOptions());
        passNW.getConfig().getRenderOptions().setWireframeModeEnabled(true);
        passNE.getConfig().setRenderOptions(new RenderOptions());
        passNE.getConfig().getRenderOptions().setWireframeModeEnabled(true);
        passSW.getConfig().setRenderOptions(new RenderOptions());
        passSW.getConfig().getRenderOptions().setWireframeModeEnabled(true);
        Transform3D viewTransNW = new Transform3D();
        viewTransNW.lookAt(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        passNW.getConfig().setViewTransform(viewTransNW);
        Transform3D viewTransNE = new Transform3D();
        viewTransNE.lookAt(0.0f, 0.0f, 15.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        passNE.getConfig().setViewTransform(viewTransNE);
        Transform3D viewTransSW = new Transform3D();
        viewTransSW.lookAt(5.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        passSW.getConfig().setViewTransform(viewTransSW);
        Transform3D viewTransSE = new Transform3D();
        viewTransSE.lookAt(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        passSE.getConfig().setViewTransform(viewTransSE);
        sg.addRenderPass(passNW);
        sg.addRenderPass(passNE);
        sg.addRenderPass(passSW);
        sg.addRenderPass(passSE);
        Rect2i[] viewports = new Rect2i[4];
        viewports[QuadViewportTest.NW] = passNW.getConfig().getViewport();
        viewports[QuadViewportTest.NE] = passNE.getConfig().getViewport();
        viewports[QuadViewportTest.SW] = passSW.getConfig().getViewport();
        viewports[QuadViewportTest.SE] = passSE.getConfig().getViewport();
        return viewports;
    }

    public void onDividerResized(QuadDivider quadDivider, float leftWidth, float rightWidth, float topHeight, float bottomHeight) {
        leftWidth = Math.max(leftWidth, 1.0f);
        rightWidth = Math.max(rightWidth, 1.0f);
        topHeight = Math.max(topHeight, 1.0f);
        bottomHeight = Math.max(bottomHeight, 1.0f);
        this.viewports[NW].set(0, 0, (int)leftWidth, (int)topHeight);
        this.viewports[NE].set((int)quadDivider.getWidth() - (int)rightWidth, 0, (int)rightWidth, (int)topHeight);
        this.viewports[SW].set(0, (int)quadDivider.getHeight() - (int)bottomHeight, (int)leftWidth, (int)bottomHeight);
        this.viewports[SE].set((int)quadDivider.getWidth() - (int)rightWidth, (int)quadDivider.getHeight() - (int)bottomHeight, (int)rightWidth, (int)bottomHeight);
    }

    private void initGUI(SceneGraph sg, Sized2iRO res) {
        HUD hud = new HUD(res.getWidth(), res.getHeight());
        QuadDivider qd = new QuadDivider(hud.getResX(), hud.getResY());
        qd.addQuadDividerListener(this);
        hud.getContentPane().addWidget(qd);
        this.qd = qd;
        sg.addHUD(hud);
    }

    private BranchGroup createSceneGraph() {
        this.cube = new Cube(3.0f, "stone.jpg");
        this.cube.setName("Cube");
        this.cube.setUserData(Selectable.class, new BoundingBoxSelectable<Cube>(this.cube));
        TransformGroup tg = new TransformGroup();
        tg.addChild(this.cube);
        return new BranchGroup((Node)tg);
    }

    public QuadViewportTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.branchGroup = this.createSceneGraph();
        this.viewports = this.initViewports(env, arguments.getResolution(), this.branchGroup);
        this.rp = this.renderPassMapping[SE];
        this.initGUI(env, arguments.getResolution());
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        this.selectionManager = new SelectionManager();
        if (this.rpmode) {
            this.selectionManager.bind(this.branchGroup, this.rp.getConfig(), this.canvas);
        } else {
            this.selectionManager.bind(this.branchGroup, this.canvas);
        }
        InputSystem.getInstance().getMouse().addMouseListener(this.selectionManager);
        env.getHUD().addPickMissedListener(SelectionManager.HUD_PICK_MISSED_MASK, this.selectionManager);
    }

    public static void main(String[] args) throws Throwable {
        QuadViewportTest test = new QuadViewportTest(QuadViewportTest.parseCommandLine(args));
        test.begin();
    }
}

