/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.opscheduler.PickScheduler;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.PickResult;
import org.xith3d.render.Canvas3DJPanel;
import org.xith3d.render.Canvas3DPanel;
import org.xith3d.render.Canvas3DWrapper;
import org.xith3d.render.CanvasBag;
import org.xith3d.render.config.CanvasConstructionInfo;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.awt.WindowHelper;
import org.xith3d.utility.commandline.BasicApplicationArguments;

@Xith3DTest.Description(fulltext={"This class demonstrates the basic use of<br>", "org.xith3d.render.base.ExtXith3DEnvironment<br>", "org.xith3d.render.canvas.Canvas3DPanel (Swing integration)", "org.xith3d.render.loop.ExtRenderLoop", "org.xith3d.behaviors.impl.RotatableGroup / Animatable"}, authors={"Marvin Froehlich (aka Qudus)"})
public class SwingIntegrationTest
extends Xith3DTest
implements NearestPickListener {
    private JFrame frame;
    private GroupNode pickRoot;
    private PickScheduler pickScheduler;
    private JLabel fpsLabel;

    protected void exit() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        super.exit();
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        this.pickScheduler.pickNearest(this.pickRoot, button, e.getX(), e.getY(), (NearestPickListener)this, (Object)"MyUserObject");
    }

    public boolean testIntersectionsInWorldSpaceForPicking() {
        return false;
    }

    public void onObjectPicked(PickResult nearest, Object userObject, long pickTime) {
        System.out.println("picked node: \"" + nearest.getNode().getName() + "\" with userObject \"" + userObject.toString() + "\" (picktime: " + pickTime + "ms).");
    }

    public void onPickingMissed(Object userObject, long pickTime) {
        System.out.println("picking missed! (picktime: " + pickTime + "ms)");
    }

    public void onFPSCountIntervalHit(float fps) {
        super.onFPSCountIntervalHit(fps);
        this.fpsLabel.setText("FPS: " + String.valueOf((int)fps));
    }

    private void init3DScene(SceneGraph sg) {
        TransformGroup sceneTG = new TransformGroup();
        Rectangle rect1 = new Rectangle(3.0f, 3.0f, "stone.jpg");
        rect1.setName("Rect1");
        sceneTG.addChild(rect1);
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.0f, 0.0f, 0.5f));
        rg.setTranslation(0.0f, 0.0f, 1.0f);
        Rectangle rect2 = new Rectangle(2.0f, 2.0f, "jplogo.png");
        rect2.setName("Rect2");
        rg.addChild(rect2);
        sceneTG.addChild(rg);
        this.getAnimator().addAnimatableObject(rg);
        BranchGroup scene = sg.addPerspectiveBranch().getBranchGroup();
        scene.addChild(sceneTG);
        this.pickRoot = scene;
    }

    private void initGUI(CanvasBag canvasBag, CanvasConstructionInfo canvasInfo) throws Exception {
        Container canvasComponent;
        Container canvasPanel;
        this.frame = new JFrame(this.getClass().getSimpleName());
        this.frame.setLayout(new GridLayout(1, 1));
        this.frame.setDefaultCloseOperation(2);
        this.frame.setSize(canvasInfo.getDisplayMode().getWidth(), canvasInfo.getDisplayMode().getHeight());
        WindowHelper.center(this.frame);
        JPanel main = new JPanel(new BorderLayout());
        main.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.frame.getContentPane().add((Component)main, null);
        if (canvasInfo.getOpenGLLayer() == OpenGLLayer.JOGL_SWING) {
            canvasPanel = new Canvas3DJPanel(canvasInfo);
            InputSystem.getInstance().registerNewKeyboardAndMouse(((Canvas3DJPanel)canvasPanel).getCanvas().getPeer());
            canvasBag.addCanvas((Canvas3DWrapper)((Object)canvasPanel));
            canvasComponent = canvasPanel;
        } else {
            canvasPanel = new Canvas3DPanel(canvasInfo);
            InputSystem.getInstance().registerNewKeyboardAndMouse(((Canvas3DPanel)canvasPanel).getCanvas().getPeer());
            canvasBag.addCanvas((Canvas3DWrapper)((Object)canvasPanel));
            canvasComponent = canvasPanel;
        }
        main.add((Component)canvasComponent, "Center");
        JPanel footer0 = new JPanel(new BorderLayout());
        footer0.setPreferredSize(new Dimension(1, 30));
        main.add((Component)footer0, "South");
        JPanel footerMain = new JPanel();
        footer0.add((Component)footerMain, "Center");
        this.fpsLabel = new JLabel("FPS: 0.0");
        footerMain.add((Component)this.fpsLabel, null);
        JPanel footerRight = new JPanel(new GridLayout(1, 1));
        footerRight.setPreferredSize(new Dimension(80, 1));
        footer0.add((Component)footerRight, "East");
        JButton exitButton = new JButton("Exit");
        footerRight.add((Component)exitButton, null);
        exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingIntegrationTest.this.end();
            }
        });
        this.frame.setVisible(true);
    }

    public SwingIntegrationTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        this.pickScheduler = env.getPickScheduler();
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.init3DScene(env);
        this.initGUI(env, arguments.getCanvasConstructionInfo());
        System.out.println("Hit ESC to exit\nPress SPACE to stop/start rotation\nClick the Sphere to change light color");
    }

    public static void main(String[] args) throws Throwable {
        SwingIntegrationTest test = new SwingIntegrationTest(SwingIntegrationTest.parseCommandLine(args));
        test.begin();
    }
}

