/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.PickResult;
import org.xith3d.picking.PickingLibrary;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DJPanel;
import org.xith3d.render.Canvas3DPanel;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.RenderPass;
import org.xith3d.render.config.CanvasConstructionInfo;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.RotatingSphere;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.awt.WindowHelper;
import org.xith3d.utility.commandline.BasicApplicationArguments;

@Xith3DTest.Description(fulltext={"This class demonstrates the basic use of<br>", "org.xith3d.render.base.ExtXith3DEnvironment<br>", "org.xith3d.render.canvas.Canvas3DPanel (Swing integration)", "org.xith3d.render.loop.ExtRenderLoop", "org.xith3d.behaviors.impl.RotatableGroup / Animatable"}, authors={"Marvin Froehlich (aka Qudus)"})
public class SwingIntegrationTest2
extends Xith3DTest
implements NearestPickListener {
    private JFrame frame;
    private HashMap<Canvas3D, GroupNode> pickRoots = new HashMap();
    private RotatingSphere rotSphere = new RotatingSphere(100.0f);
    private JLabel fpsLabel;

    protected void exit() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        super.exit();
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                if (this.rotSphere.isAnimating()) {
                    this.rotSphere.stopAnimation();
                    break;
                }
                this.rotSphere.startAnimation(this.getGameTime(), this.getTimingMode());
            }
        }
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        Canvas3D canvas = ((CanvasPeer)e.getMouse().getSourceWindow()).getCanvas3D();
        GroupNode pickRoot = this.pickRoots.get(canvas);
        PickingLibrary.pickNearest(pickRoot, canvas, button, e.getX(), e.getY(), (NearestPickListener)this);
    }

    public boolean testIntersectionsInWorldSpaceForPicking() {
        return false;
    }

    public void onObjectPicked(PickResult nearest, Object userObject, long pickTime) {
        System.out.println("picked node: \"" + nearest.getNode().getName() + "\" with userObject \"" + userObject + "\" (picktime: " + pickTime + "ms).");
    }

    public void onPickingMissed(Object userObject, long pickTime) {
        System.out.println("picking missed! (picktime: " + pickTime + "ms)");
    }

    public void onFPSCountIntervalHit(float fps) {
        super.onFPSCountIntervalHit(fps);
        this.fpsLabel.setText("FPS: " + String.valueOf((int)fps));
    }

    private RenderPass init3DScene(SceneGraph sg) {
        TransformGroup sceneTG = new TransformGroup();
        Rectangle rect1 = new Rectangle(3.0f, 3.0f, "stone.jpg");
        rect1.setName("Rect1a");
        sceneTG.addChild(rect1);
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.0f, 0.0f, 0.5f));
        rg.setTranslation(0.0f, 0.0f, 1.0f);
        Rectangle rect2 = new Rectangle(2.0f, 2.0f, "jplogo.png");
        rect2.setName("Rect2a");
        rg.addChild(rect2);
        sceneTG.addChild(rg);
        this.getAnimator().addAnimatableObject(rg);
        RenderPass rp = sg.addPerspectiveBranch();
        BranchGroup scene = rp.getBranchGroup();
        scene.addChild(sceneTG);
        return rp;
    }

    private RenderPass init3DScene2(SceneGraph sg) {
        TransformGroup sceneTG = new TransformGroup();
        Rectangle rect1 = new Rectangle(3.0f, 3.0f, "deathstar.jpg");
        rect1.setName("Rect1b");
        sceneTG.addChild(rect1);
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.0f, 0.0f, 0.5f));
        rg.setTranslation(0.0f, 0.0f, 1.0f);
        Rectangle rect2 = new Rectangle(2.0f, 2.0f, "grass.jpg");
        rect2.setName("Rect2b");
        rg.addChild(rect2);
        sceneTG.addChild(rg);
        this.getAnimator().addAnimatableObject(rg);
        RenderPass rp = sg.addPerspectiveBranch();
        BranchGroup scene = rp.getBranchGroup();
        scene.addChild(sceneTG);
        return rp;
    }

    private void initGUI(CanvasConstructionInfo canvasInfo, Xith3DEnvironment env, RenderPass rp1, RenderPass rp2) throws InputSystemException {
        this.frame = new JFrame(canvasInfo.getTitle());
        this.frame.setLayout(new GridLayout(1, 1));
        this.frame.setDefaultCloseOperation(2);
        this.frame.setSize(canvasInfo.getDisplayMode().getWidth(), canvasInfo.getDisplayMode().getHeight());
        WindowHelper.center(this.frame);
        JPanel main = new JPanel(new BorderLayout());
        main.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.frame.getContentPane().add((Component)main, null);
        HashMap<Canvas3D, List<RenderPass>> canvasRenderPassMap = new HashMap<Canvas3D, List<RenderPass>>();
        Canvas3DJPanel canvasPanel = new Canvas3DJPanel(canvasInfo);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvasPanel.getCanvas().getPeer());
        env.addCanvas(canvasPanel);
        main.add((Component)canvasPanel, "Center");
        this.pickRoots.put(canvasPanel.getCanvas(), rp1.getBranchGroup());
        ArrayList<RenderPass> list1 = new ArrayList<RenderPass>(1);
        list1.add(rp1);
        canvasRenderPassMap.put(canvasPanel.getCanvas(), list1);
        Canvas3DPanel canvasPanel2 = new Canvas3DPanel();
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvasPanel2.getCanvas().getPeer());
        env.addCanvas(canvasPanel2);
        canvasPanel2.setPreferredSize(new Dimension(250, 50));
        main.add((Component)canvasPanel2, "West");
        this.pickRoots.put(canvasPanel2.getCanvas(), rp2.getBranchGroup());
        ArrayList<RenderPass> list2 = new ArrayList<RenderPass>(1);
        list2.add(rp2);
        canvasRenderPassMap.put(canvasPanel2.getCanvas(), list2);
        env.setCanvasRenderPassMap(canvasRenderPassMap);
        JPanel footer0 = new JPanel(new BorderLayout());
        footer0.setPreferredSize(new Dimension(1, 30));
        main.add((Component)footer0, "South");
        JPanel footerMain = new JPanel();
        footer0.add((Component)footerMain, "Center");
        this.fpsLabel = new JLabel("FPS: 0.0");
        footerMain.add((Component)this.fpsLabel, null);
        JPanel footerRight = new JPanel(new GridLayout(1, 1));
        footerRight.setPreferredSize(new Dimension(80, 1));
        footer0.add((Component)footerRight, "East");
        JButton exitButton = new JButton("Exit");
        footerRight.add((Component)exitButton, null);
        exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingIntegrationTest2.this.end();
            }
        });
        this.frame.setVisible(true);
    }

    public SwingIntegrationTest2(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        RenderPass rp1 = this.init3DScene(env);
        RenderPass rp2 = this.init3DScene2(env);
        this.initGUI(arguments.getCanvasConstructionInfo(), env, rp1, rp2);
        System.out.println("Hit ESC to exit\nPress SPACE to stop/start rotation\nClick the Sphere to change light color");
    }

    public static void main(String[] args) throws Throwable {
        SwingIntegrationTest2 test = new SwingIntegrationTest2(SwingIntegrationTest2.parseCommandLine(args));
        test.begin();
    }
}

