/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import java.awt.Font;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.ForegroundRenderPass;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.test.Xith3DTest;
import org.xith3d.ui.text2d.Text2D;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This class demonstrates the basic use of Text2D."}, authors={"Florian Hofmann", "Marvin Froehlich (aka Qudus) [code streamlining]"})
public class Text2DTest
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private Node createScene() {
        TransformGroup scaleGroup = new TransformGroup();
        Transform3D scale = new Transform3D();
        scaleGroup.setTransform(scale);
        Text2D text = new Text2D("Hello Xith3D!", Colorf.WHITE, new Font("Verdana", 1, 64), TextAlignment.CENTER_CENTER);
        scaleGroup.addChild(text);
        return scaleGroup;
    }

    public Text2DTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ForegroundRenderPass pass = ForegroundRenderPass.createParallel(View.CameraMode.VIEW_FIXED);
        env.addRenderPass(pass);
        BranchGroup scene = pass.getBranchGroup();
        pass.getConfig().setFrontClipDistance(-1.0f);
        pass.getConfig().setBackClipDistance(1.0f);
        pass.getConfig().setScreenScale((float)arguments.getResolution().getWidth() / 2.0f);
        scene.addChild(this.createScene());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        Text2DTest test = new Text2DTest(Text2DTest.parseCommandLine(args));
        test.begin();
    }
}

