/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.hud.widgets.TextField;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.hud.editor.WidgetManipulatorDialog;

@Xith3DTest.Description(fulltext={"This class demonstrates the basic use of WidgetManipulator."}, authors={"Amos Wenger (aka BlueSky)"})
public class WidgetManipulatorTest
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createSceneGraph(Xith3DEnvironment env) {
        HUD hud = new HUD((Sized2iRO)env.getCanvas(), 1024.0f);
        Panel panel = new Panel(hud.getResX(), hud.getResY());
        hud.getContentPane().addWidget(panel);
        Button label = new Button(100.0f, 80.0f, "");
        label.setText("This is a test...");
        label.setLocation(756.48f, 682.24f);
        label.setZIndex(0);
        label.setSize(219.04004f, 56.960022f);
        panel.addWidget(label);
        new WidgetManipulatorDialog(label);
        TextField tf = new TextField(100.0f, 60.0f);
        tf.setLocation(583.83997f, 83.36003f);
        tf.setZIndex(0);
        tf.setSize(297.12f, 38.23999f);
        panel.addWidget(tf);
        new WidgetManipulatorDialog(tf);
        env.addHUD(hud);
    }

    public WidgetManipulatorTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        this.createSceneGraph(env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("You can drag widgets and use handles to resize them.");
    }

    public static void main(String[] args) throws Throwable {
        WidgetManipulatorTest test = new WidgetManipulatorTest(WidgetManipulatorTest.parseCommandLine(args));
        test.begin();
    }
}

