/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.devices.components.ControllerAxis;
import org.jagatoo.input.devices.components.ControllerButton;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.DigitalDeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.util.arrays.ArrayUtils;
import org.openmali.types.twodee.Dim2f;
import org.openmali.types.twodee.ExtSized2i;
import org.openmali.types.twodee.Sized2fRO;
import org.openmali.types.twodee.Sized2i;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.types.twodee.util.ResizeListener2i;
import org.openmali.vecmath2.Point2f;
import org.openmali.vecmath2.Point2i;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Tuple2i;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.OperationScheduler;
import org.xith3d.loop.opscheduler.impl.OperationSchedulerImpl;
import org.xith3d.render.ForegroundRenderPass;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.render.preprocessing.sorting.CustomRenderBinSorter;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.View;
import org.xith3d.ui.hud.HUDCoordinatesConverter;
import org.xith3d.ui.hud.HUDInputSystemConnection;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.base.Window;
import org.xith3d.ui.hud.base.__HUD_base_PrivilegedAccess;
import org.xith3d.ui.hud.contextmenu.ContextMenu;
import org.xith3d.ui.hud.listeners.HUDPickMissedListener;
import org.xith3d.ui.hud.listeners.WidgetContainerListener;
import org.xith3d.ui.hud.listeners.WidgetInputListener;
import org.xith3d.ui.hud.theming.FallbackTheme;
import org.xith3d.ui.hud.theming.WidgetTheme;
import org.xith3d.ui.hud.utils.Cursor;
import org.xith3d.ui.hud.utils.CursorSet;
import org.xith3d.ui.hud.utils.DefaultDropShadowFactory;
import org.xith3d.ui.hud.utils.DefaultToolTipFactory;
import org.xith3d.ui.hud.utils.DropShadowFactory;
import org.xith3d.ui.hud.utils.HUDPickResult;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.utils.TileMode;
import org.xith3d.ui.hud.utils.ToolTipFactory;
import org.xith3d.ui.hud.utils.WidgetZIndexGroup;
import org.xith3d.ui.hud.widgets.Dialog;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.ui.hud.widgets.Panel;

public class HUD {
    public static final int WINDOW_BASE_Z_INDEX = 32769;
    public static final int POPUP_Z_INDEX = 2147483547;
    public static final int TOOLTIP_Z_INDEX = 2147483557;
    public static final int CROSSHAIR_Z_INDEX = 32768;
    public static final int CURSOR_Z_INDEX = 0x7FFFFFFE;
    private ForegroundRenderPass renderPass = null;
    private final BranchGroup branchGroup;
    private Dim2f size;
    private HUDCanvas3DConnection canvasConnection = null;
    private HUDInputSystemConnection inputSystemConnection = null;
    private Dim2f resolution = null;
    private final HUDCoordinatesConverter coordinatesConverter = new HUDCoordinatesConverter(this);
    private WidgetContainer contentPane;
    private final ArrayList<Window> windows = new ArrayList();
    private final WidgetZIndexGroup framesZIGroup = new WidgetZIndexGroup(1);
    private final Stack<Dialog> dialogs = new Stack();
    private Widget currentVolatilePopup = null;
    private Widget currentVolatilePopupAssembly = null;
    private final Tuple2f lastMousePos;
    private CursorSet cursorSet = null;
    private Cursor.Type currentCursorType = Cursor.Type.POINTER1;
    private Cursor currentCursor = null;
    private Image cursorImage = null;
    private Image crosshairImage = null;
    private int crosshairHotspotX = -2;
    private int crosshairHotspotY = -2;
    private Widget currentHoveredWidget = null;
    private Widget currentFocusedWidget = null;
    private Widget mouseBoundWidget = null;
    private final ArrayList<HUDPickResult> pickedWidgets = new ArrayList();
    private final ArrayList<WidgetContainerListener> globalContainerListeners = new ArrayList(1);
    private final ArrayList<WidgetInputListener> globalInputListeners = new ArrayList(1);
    private final ArrayList<HUDPickMissedListener> pickMissedListeners = new ArrayList(1);
    private final ArrayList<Integer> pickMissedMasks = new ArrayList(1);
    private ContextMenu contextMenu = null;
    private ContextMenu currentlyDisplayedContextMenu = null;
    private boolean useVoidContextMenu = true;
    private ToolTipFactory tooltipFactory = new DefaultToolTipFactory();
    private Widget currentlyTooltippedWidget = null;
    private Point2i tooltipStartPoint = new Point2i();
    private Widget currentlyDisplayedTooltipWidget = null;
    private DropShadowFactory dropshadowFactory = new DefaultDropShadowFactory();
    private final OperationScheduler opScheduler = new OperationSchedulerImpl();
    private static transient WidgetTheme theme = null;
    private DeviceComponent[] focusMoveUpAccessors = new DeviceComponent[]{Keys.UP};
    private DeviceComponent[] focusMoveLeftAccessors = new DeviceComponent[]{Keys.LEFT};
    private DeviceComponent[] focusMoveRightAccessors = new DeviceComponent[]{Keys.RIGHT};
    private DeviceComponent[] focusMoveDownAccessors = new DeviceComponent[]{Keys.DOWN};
    private DeviceComponent[] focusMoveNextAccessors = new DeviceComponent[]{Keys.TAB};

    private final void fixRenderPass() {
        this.renderPass.getConfig().setScreenScale(this.getWidth() / 2.0f);
        this.renderPass.getConfig().setCenterOfView(new Point2f(-this.getWidth() / 2.0f, this.getHeight() / 2.0f));
    }

    private final ForegroundRenderPass createRenderPass(BranchGroup bg) {
        this.renderPass = ForegroundRenderPass.createParallel(bg);
        RenderPassConfig passConfig = this.renderPass.getConfig();
        passConfig.setCameraMode(View.CameraMode.VIEW_FIXED);
        passConfig.setOpaqueSorter(new CustomRenderBinSorter());
        passConfig.setTransparentSorter(new CustomRenderBinSorter());
        passConfig.setFrontClipDistance(-1.0f);
        passConfig.setBackClipDistance(1.0f);
        this.fixRenderPass();
        this.renderPass.setScissorEnabled(true);
        return this.renderPass;
    }

    public final ForegroundRenderPass getRenderPass() {
        if (this.renderPass == null) {
            this.renderPass = this.createRenderPass(this.branchGroup);
        }
        return this.renderPass;
    }

    public final BranchGroup getSGGroup() {
        return this.branchGroup;
    }

    public final void detach() {
        BranchGroup bg = this.getSGGroup();
        if (bg == null) {
            return;
        }
        SceneGraph sg = bg.getSceneGraph();
        if (sg == null) {
            return;
        }
        sg.removeHUD(this);
    }

    public void setName(String name) {
        this.getSGGroup().setName(name);
    }

    public final String getName() {
        return this.getSGGroup().getName();
    }

    public static void setTheme(WidgetTheme theme) {
        HUD.theme = theme;
    }

    public static void setTheme(String theme) throws IOException {
        HUD.theme = new WidgetTheme(theme);
    }

    public static final WidgetTheme getTheme() {
        if (theme == null) {
            String THEME_NAME = "GTK";
            try {
                theme = new WidgetTheme("GTK");
            }
            catch (IOException e) {
                System.err.println("WARNING: Theme \"GTK\" could not get loaded. Using Fallback-Theme");
                theme = new FallbackTheme();
            }
        }
        return theme;
    }

    public void addPickMissedListener(int mask, HUDPickMissedListener l) {
        this.pickMissedListeners.add(l);
        this.pickMissedMasks.add(mask);
    }

    public void removePickMissedListener(HUDPickMissedListener l) {
        int index = this.pickMissedListeners.indexOf(l);
        if (index < 0) {
            return;
        }
        this.pickMissedListeners.remove(index);
        this.pickMissedMasks.remove(index);
    }

    public void addGlobalInputListener(WidgetInputListener l) {
        this.globalInputListeners.add(l);
    }

    public void removeGlobalInputListener(WidgetInputListener l) {
        this.globalInputListeners.remove(l);
    }

    public void addGlobalContainerListener(WidgetContainerListener l) {
        this.globalContainerListeners.add(l);
    }

    public void removeGlobalContainerListener(WidgetContainerListener l) {
        this.globalContainerListeners.remove(l);
    }

    public void disposeFocus() {
        if (this.currentFocusedWidget != null) {
            __HUD_base_PrivilegedAccess.onFocusLost(this.currentFocusedWidget);
        }
        this.currentFocusedWidget = null;
    }

    public void setVisible(boolean visible) {
        this.getSGGroup().setRenderable(visible);
    }

    public final boolean isVisible() {
        return this.getSGGroup().isRenderable();
    }

    public void setTransparency(float transparency) {
        for (int i = 0; i < this.windows.size(); ++i) {
            this.windows.get(i).setTransparency(transparency);
        }
        this.contentPane.setTransparency(transparency, true);
    }

    public final float getTransparency() {
        return this.contentPane.getTransparency();
    }

    public final float getWidth() {
        if (this.size != null) {
            return this.size.getWidth();
        }
        return -1.0f;
    }

    public final float getHeight() {
        if (this.size != null) {
            return this.size.getHeight();
        }
        return -1.0f;
    }

    public final float getAspect() {
        return this.getWidth() / this.getHeight();
    }

    public final Sized2fRO getSize() {
        return this.size;
    }

    public final boolean hasCustomResolution() {
        return this.resolution != null;
    }

    public final float getResX() {
        if (this.resolution == null) {
            return this.getWidth();
        }
        return this.resolution.getWidth();
    }

    public final float getResY() {
        if (this.resolution == null) {
            return this.getHeight();
        }
        return this.resolution.getHeight();
    }

    public final Tuple2f getResolution() {
        return new Tuple2f(this.getResX(), this.getResY());
    }

    public final float getResAspect() {
        if (this.getResY() == 0.0f) {
            return 0.0f;
        }
        return this.getResX() / this.getResY();
    }

    public final HUDCoordinatesConverter getCoordinatesConverter() {
        return this.coordinatesConverter;
    }

    public void update() {
        this.contentPane.update();
        for (int i = 0; i < this.windows.size(); ++i) {
            this.windows.get(i).update();
        }
        if (this.currentVolatilePopup != null) {
            this.currentVolatilePopup.update();
        }
        if (this.currentlyDisplayedTooltipWidget != null) {
            this.currentlyDisplayedTooltipWidget.update();
        }
    }

    protected boolean setSize(float resX, float resY, boolean forced) {
        boolean contentPaneHasFullSize;
        boolean result = true;
        boolean bl = contentPaneHasFullSize = this.contentPane.getWidth() == this.getResX() && this.contentPane.getHeight() == this.getResY();
        if (resY >= 0.0f && resY >= 0.0f) {
            this.resolution = new Dim2f(resX, resY);
        }
        if (contentPaneHasFullSize) {
            this.contentPane.setSize(this.getResX(), this.getResY());
        }
        this.update();
        return true;
    }

    public final HUD setSize(float resX, float resY) {
        this.setSize(resX, resY, false);
        return this;
    }

    public final HUD setSize(Sized2fRO resolution) {
        return this.setSize(resolution.getWidth(), resolution.getHeight());
    }

    public final HUD setSize(Tuple2f resolution) {
        return this.setSize(resolution.getX(), resolution.getY());
    }

    public final void setSize(int canvasWidth, int canvasHeight, float resX, float resY) {
        if (this.size == null) {
            this.size = new Dim2f();
        }
        this.size.set(canvasWidth, canvasHeight);
        this.setSize(resX, resY);
        this.update();
    }

    public final void setSize(Sized2iRO canvas, float resX, float resY) {
        this.setSize(canvas.getWidth(), canvas.getHeight(), resX, resY);
    }

    public final void setSize(int canvasWidth, int canvasHeight, Sized2fRO resolution) {
        if (resolution != null) {
            this.setSize(canvasWidth, canvasHeight, resolution.getWidth(), resolution.getHeight());
        } else {
            this.setSize(canvasWidth, canvasHeight, -1.0f, -1.0f);
        }
    }

    public final void setSize(Sized2iRO canvas, Sized2fRO resolution) {
        if (resolution != null) {
            this.setSize(canvas, resolution.getWidth(), resolution.getHeight());
        } else {
            this.setSize(canvas, -1.0f, -1.0f);
        }
    }

    public final void setSize(int canvasWidth, int canvasHeight) {
        this.setSize(canvasWidth, canvasHeight, canvasWidth, canvasHeight);
    }

    public final void setSize(Sized2iRO canvas) {
        this.setSize(canvas, null);
    }

    public final void setWidth(float width) {
        this.setSize(width, this.getResX());
    }

    public final void setHeight(float height) {
        this.setSize(this.getResX(), height);
    }

    public Window addWindow(Window window, float locX, float locY) {
        int i;
        if (window.getHUD() != null) {
            throw new Error("This Widget is already added to the HUD.");
        }
        int maxZIndex = 32768;
        for (i = 0; i < this.windows.size(); ++i) {
            Window wnd = this.windows.get(i);
            if (wnd.getZIndex() <= maxZIndex) continue;
            maxZIndex = wnd.getZIndex();
        }
        window.setZIndex(maxZIndex + 1);
        this.framesZIGroup.add(window);
        this.windows.add(window);
        this.currentFocusedWidget = window;
        if (this.inputSystemConnection != null) {
            this.inputSystemConnection.nextAcceptedMouseEventTime = System.currentTimeMillis() + 200L;
        }
        if (window instanceof Dialog) {
            this.dialogs.push((Dialog)window);
        }
        window.setLocation(locX, locY);
        __HUD_base_PrivilegedAccess.setHUD(this, window);
        this.branchGroup.addChild(__HUD_base_PrivilegedAccess.getSGNode(window));
        for (i = 0; i < this.globalContainerListeners.size(); ++i) {
            this.globalContainerListeners.get(i).onWidgetAttachedToHUD(window, this);
        }
        return window;
    }

    public final Window addWindow(Window window) {
        return this.addWindow(window, window.getLeft(), window.getTop());
    }

    public final Window addWindowCentered(Window window) {
        float posUpperLeftX = (this.getResX() - window.getWidth()) / 2.0f;
        float posUpperLeftY = (this.getResY() - window.getHeight()) / 2.0f;
        posUpperLeftX = Math.round(posUpperLeftX);
        posUpperLeftY = Math.round(posUpperLeftY);
        return this.addWindow(window, posUpperLeftX, posUpperLeftY);
    }

    public void removeWindow(Window window) {
        if (window.getHUD() != this) {
            throw new Error("the given Widget is not held in this Container.");
        }
        this.branchGroup.removeChild(__HUD_base_PrivilegedAccess.getSGNode(window));
        if (window instanceof Dialog) {
            this.dialogs.remove(window);
        }
        this.windows.remove(window);
        this.framesZIGroup.remove(window);
        __HUD_base_PrivilegedAccess.setHUD(null, window);
        for (int i = 0; i < this.globalContainerListeners.size(); ++i) {
            this.globalContainerListeners.get(i).onWidgetDetachedFromHUD(window, this);
        }
    }

    private void addInternalWidget(Widget widget, float locX, float locY, int zIndex) {
        if (widget.getContainer() != null || widget.getHUD() != null) {
            throw new Error("This Widget is already added to the HUD.");
        }
        if (locX < 0.0f) {
            locX = Math.round((this.getResX() - widget.getWidth()) / 2.0f);
        }
        if (locY < 0.0f) {
            locY = Math.round((this.getResY() - widget.getHeight()) / 2.0f);
        }
        widget.setLocation(locX, locY);
        widget.setZIndex(zIndex);
        __HUD_base_PrivilegedAccess.setHUD(this, widget);
        this.branchGroup.addChild(__HUD_base_PrivilegedAccess.getSGNode(widget));
    }

    void addVolatilePopup(Widget widget, Widget assembly, float locX, float locY) {
        if (!widget.isHeavyWeight()) {
            throw new IllegalArgumentException("A volatile popup must be heavyweight.");
        }
        if (this.currentVolatilePopup != null) {
            this.removeVolatilePopup();
        }
        this.addInternalWidget(widget, locX, locY, 2147483547);
        this.currentVolatilePopup = widget;
        this.currentVolatilePopupAssembly = assembly;
    }

    void removeVolatilePopup() {
        if (this.currentVolatilePopup == null) {
            return;
        }
        this.removeInternalWidget(this.currentVolatilePopup);
        this.currentVolatilePopup = null;
        this.currentVolatilePopupAssembly = null;
    }

    final Widget getCurrentVolatilePopup() {
        return this.currentVolatilePopup;
    }

    private void removeInternalWidget(Widget widget) {
        if (widget.getContainer() != null || widget.getHUD() != this) {
            throw new Error("the given Widget is not held in this Container.");
        }
        this.branchGroup.removeChild(__HUD_base_PrivilegedAccess.getSGNode(widget));
        __HUD_base_PrivilegedAccess.setHUD(null, widget);
    }

    public void setContentPane(WidgetContainer contentPane) {
        if (contentPane == null) {
            throw new IllegalArgumentException("contentPane must not be null.");
        }
        if (contentPane == this.contentPane) {
            return;
        }
        if (this.contentPane != null) {
            this.removeInternalWidget(this.contentPane);
        }
        this.addInternalWidget(contentPane, contentPane.getLeft(), contentPane.getTop(), 0);
        this.contentPane = contentPane;
    }

    public final WidgetContainer getContentPane() {
        return this.contentPane;
    }

    private final Dialog getCurrentDialog() {
        for (int i = this.dialogs.size() - 1; i >= 0; --i) {
            Dialog dialog = (Dialog)this.dialogs.get(i);
            if (!dialog.isVisible() || dialog.getHUD() == null) continue;
            return (Dialog)this.dialogs.get(i);
        }
        return null;
    }

    Widget focus(Widget widget) {
        Widget cfw = this.currentFocusedWidget;
        if (widget instanceof WidgetContainer && ((WidgetContainer)widget).isContentPane()) {
            widget = ((WidgetContainer)widget).getParentWindow();
        }
        if (cfw == widget || !widget.isFocussable()) {
            return cfw;
        }
        if (this.currentFocusedWidget != null) {
            __HUD_base_PrivilegedAccess.onFocusLost(this.currentFocusedWidget);
        }
        this.currentFocusedWidget = widget;
        __HUD_base_PrivilegedAccess.onFocusGained(this.currentFocusedWidget);
        return cfw;
    }

    final Widget getCurrentFocusedWidget(boolean getLeaf) {
        Widget cfw = this.currentFocusedWidget;
        if (getLeaf && cfw != null && cfw instanceof WidgetContainer) {
            Widget cfw2 = ((WidgetContainer)cfw).getCurrentFocusedWidget(getLeaf);
            if (cfw2 != null) {
                return cfw2;
            }
            return cfw;
        }
        return cfw;
    }

    private final Widget getCurrentFocusedWidget() {
        return this.getCurrentFocusedWidget(false);
    }

    final Widget getCurrentHoveredWidget(boolean getLeaf) {
        Widget chw = this.currentHoveredWidget;
        if (getLeaf && chw != null && chw instanceof WidgetContainer) {
            Widget chw2 = ((WidgetContainer)chw).getCurrentHoveredWidget(getLeaf);
            if (chw2 != null) {
                return chw2;
            }
            return chw;
        }
        return chw;
    }

    private final Widget getCurrentHoveredWidget() {
        return this.currentHoveredWidget;
    }

    void bindMouseMovement(Widget widget) {
        this.mouseBoundWidget = widget;
    }

    private final Widget getCurrentMouseBoundWidget() {
        return this.mouseBoundWidget;
    }

    public void setToolTipFactory(ToolTipFactory ttf) {
        this.tooltipFactory = ttf;
    }

    public final ToolTipFactory getToolTipFactory() {
        return this.tooltipFactory;
    }

    private void disposeToolTip() {
        if (this.currentlyDisplayedTooltipWidget == null) {
            return;
        }
        this.removeInternalWidget(this.currentlyDisplayedTooltipWidget);
        this.currentlyDisplayedTooltipWidget = null;
        this.currentlyTooltippedWidget = null;
    }

    private void displayToolTipIfNeeded(Widget leafHoveredWidget, int canvasX, int canvasY) {
        if (!leafHoveredWidget.hasToolTip() || this.getToolTipFactory() == null) {
            return;
        }
        if (leafHoveredWidget == this.currentlyTooltippedWidget) {
            return;
        }
        Widget tooltip = __HUD_base_PrivilegedAccess.getCachedToolTipWidget(leafHoveredWidget);
        if (tooltip == null) {
            tooltip = this.getToolTipFactory().createToolTip(leafHoveredWidget.getToolTip());
            if (tooltip == null) {
                throw new Error("ToolTipFactory " + this.getToolTipFactory().getClass() + " returns null. This is illegal!");
            }
            if (!tooltip.isHeavyWeight()) {
                throw new Error("A tooltip must be heavyweight!");
            }
            __HUD_base_PrivilegedAccess.setCachedToolTipWidget(leafHoveredWidget, tooltip);
        }
        this.disposeToolTip();
        this.currentlyDisplayedTooltipWidget = tooltip;
        Tuple2f buffer = Tuple2f.fromPool();
        this.coordinatesConverter.getLocationPixels2HUD(canvasX, canvasY, buffer);
        float posX = buffer.getX();
        float posY = buffer.getY();
        Tuple2f.toPool(buffer);
        this.addInternalWidget(tooltip, posX, posY, 2147483557);
        this.currentlyTooltippedWidget = leafHoveredWidget;
        this.tooltipStartPoint.set(canvasX, canvasY);
    }

    public void setDropShadowFactory(DropShadowFactory dsf) {
        this.dropshadowFactory = dsf;
    }

    public final DropShadowFactory getDropShadowFactory() {
        return this.dropshadowFactory;
    }

    public void setContextMenu(ContextMenu contextMenu) {
        if (contextMenu == this.contextMenu) {
            return;
        }
        if (this.contextMenu != null) {
            this.contextMenu.setHUD(null);
        }
        this.contextMenu = contextMenu;
        contextMenu.setHUD(this);
    }

    public ContextMenu getContextMenu() {
        return this.contextMenu;
    }

    public void setUseVoidContextMenu(boolean use) {
        this.useVoidContextMenu = use;
    }

    public final boolean useVoidContextMenu() {
        return this.useVoidContextMenu;
    }

    private void popUpContextMenu(ContextMenu contextMenu, float posX, float posY) {
        if (contextMenu == null) {
            return;
        }
        contextMenu.popUp(posX, posY);
    }

    private void checkPopupMenu(HUDPickResult pickResult, MouseButton button, float posX, float posY, HUDPickResult.HUDPickReason pickReason) {
        if (pickReason == HUDPickResult.HUDPickReason.MOUSE_MOVED) {
            return;
        }
        Widget pickedWidget = pickResult == null ? null : pickResult.getLeafResult().getWidget();
        ContextMenu contextMenu = null;
        if (pickedWidget != null) {
            contextMenu = pickedWidget.getContextMenu();
        }
        if (contextMenu == null) {
            contextMenu = this.getContextMenu();
        }
        if (contextMenu != null) {
            if (this.currentlyDisplayedContextMenu != null) {
                if ((pickedWidget != null || this.useVoidContextMenu()) && pickedWidget != this.currentlyDisplayedContextMenu.getMenuItemsContainer()) {
                    if (button == MouseButtons.RIGHT_BUTTON) {
                        if (contextMenu != this.currentlyDisplayedContextMenu) {
                            this.currentlyDisplayedContextMenu.popUp(false);
                            this.currentlyDisplayedContextMenu = null;
                        }
                        if (pickReason == HUDPickResult.HUDPickReason.BUTTON_RELEASED) {
                            this.popUpContextMenu(contextMenu, posX, posY);
                            this.currentlyDisplayedContextMenu = contextMenu;
                        }
                    } else if (pickResult == null || pickResult.getWidget() != contextMenu.getMenuItemsContainer()) {
                        this.currentlyDisplayedContextMenu.popUp(false);
                        this.currentlyDisplayedContextMenu = null;
                    }
                }
            } else if (button == MouseButtons.RIGHT_BUTTON && pickReason == HUDPickResult.HUDPickReason.BUTTON_RELEASED && (pickedWidget != null || this.useVoidContextMenu())) {
                this.popUpContextMenu(contextMenu, posX, posY);
                this.currentlyDisplayedContextMenu = contextMenu;
            }
        } else if (this.currentlyDisplayedContextMenu != null) {
            this.currentlyDisplayedContextMenu.popUp(false);
            this.currentlyDisplayedContextMenu = null;
        }
    }

    private Widget pick(int canvasX, int canvasY, HUDPickResult.HUDPickReason pickReason, MouseButton button, long when, long meta, int flags) {
        int i;
        boolean eventsSuppressed;
        HUDPickResult tmpHPR = null;
        HUDPickResult topMost = null;
        this.pickedWidgets.clear();
        if (topMost == null && this.getCurrentVolatilePopup() != null && (tmpHPR = __HUD_base_PrivilegedAccess.pick(this.getCurrentVolatilePopup(), canvasX, canvasY, pickReason, button, when, meta, flags)) != null) {
            this.pickedWidgets.add(tmpHPR);
            topMost = tmpHPR;
        }
        Dialog currDialog = this.getCurrentDialog();
        if (topMost == null) {
            if (currDialog != null) {
                if (currDialog.isPickable() && (tmpHPR = __HUD_base_PrivilegedAccess.pick(currDialog, canvasX, canvasY, pickReason, button, when, meta, flags)) != null) {
                    this.pickedWidgets.add(tmpHPR);
                    topMost = tmpHPR;
                }
            } else {
                for (int i2 = 0; i2 < this.windows.size(); ++i2) {
                    Window window = this.windows.get(i2);
                    if (!window.isVisible() || !window.isPickable() || (tmpHPR = __HUD_base_PrivilegedAccess.pick(window, canvasX, canvasY, pickReason, button, when, meta, flags | 1)) == null) continue;
                    this.pickedWidgets.add(tmpHPR);
                    if (topMost != null && topMost.compareTo(tmpHPR) > 0) continue;
                    topMost = tmpHPR;
                }
                if (topMost == null && this.contentPane.isVisible() && this.contentPane.isPickable() && (tmpHPR = __HUD_base_PrivilegedAccess.pick(this.contentPane, canvasX, canvasY, pickReason, button, when, meta, flags)) != null) {
                    this.pickedWidgets.add(tmpHPR);
                    topMost = tmpHPR;
                }
            }
        }
        boolean justTest = (flags & 0x1000) == 4096;
        boolean isInternal = justTest || (flags & 1) != 0;
        boolean bl = eventsSuppressed = justTest || (flags & 2) != 0;
        if (!(justTest || this.currentHoveredWidget == null || topMost != null && this.currentHoveredWidget == topMost.getWidget())) {
            if (this.currentHoveredWidget.getHUD() != null) {
                __HUD_base_PrivilegedAccess.onMouseExited(this.currentHoveredWidget, true, false);
                for (int j = 0; j < this.globalInputListeners.size(); ++j) {
                    this.globalInputListeners.get(j).onMouseExited(this.getCurrentHoveredWidget(true), true, false);
                }
            }
            this.currentHoveredWidget = null;
        }
        Tuple2f locP = Tuple2f.fromPool();
        this.getCoordinatesConverter().getLocationPixels2HUD(canvasX, canvasY, locP);
        float pickXHUD = locP.getX();
        float pickYHUD = locP.getY();
        Tuple2f.toPool(locP);
        if (topMost != null && isInternal && !eventsSuppressed) {
            block10: for (i = 0; i < this.pickedWidgets.size(); ++i) {
                HUDPickResult hpr = this.pickedWidgets.get(i);
                Widget pickedWidget = hpr.getWidget();
                boolean isTopMost = pickedWidget == topMost.getWidget();
                boolean hasFocus = pickedWidget == this.getCurrentFocusedWidget();
                float pickXHUD_ = pickXHUD - pickedWidget.getLeft();
                float pickYHUD_ = pickYHUD - pickedWidget.getTop();
                switch (pickReason) {
                    case BUTTON_PRESSED: {
                        int j;
                        if (isTopMost && this.currentFocusedWidget != pickedWidget) {
                            this.focus(pickedWidget);
                            hasFocus = true;
                        }
                        __HUD_base_PrivilegedAccess.onMouseButtonPressed(pickedWidget, button, pickXHUD_, pickYHUD_, when, meta, isTopMost, hasFocus);
                        for (j = 0; j < this.globalInputListeners.size(); ++j) {
                            this.globalInputListeners.get(j).onMouseButtonPressed(hpr.getLeafResult().getWidget(), button, pickXHUD_, pickYHUD_, when, meta, isTopMost, hasFocus);
                        }
                        continue block10;
                    }
                    case BUTTON_RELEASED: {
                        int j;
                        __HUD_base_PrivilegedAccess.onMouseButtonReleased(pickedWidget, button, pickXHUD_, pickYHUD_, when, meta, isTopMost, hasFocus);
                        for (j = 0; j < this.globalInputListeners.size(); ++j) {
                            this.globalInputListeners.get(j).onMouseButtonReleased(hpr.getLeafResult().getWidget(), button, pickXHUD_, pickYHUD_, when, meta, isTopMost, hasFocus);
                        }
                        continue block10;
                    }
                    case MOUSE_MOVED: {
                        int j;
                        __HUD_base_PrivilegedAccess.onMouseMoved(pickedWidget, pickXHUD_, pickYHUD_, (int)meta, when, isTopMost, hasFocus);
                        if (this.currentHoveredWidget == null && isTopMost) {
                            this.currentHoveredWidget = pickedWidget;
                            __HUD_base_PrivilegedAccess.onMouseEntered(this.currentHoveredWidget, isTopMost, hasFocus);
                            for (j = 0; j < this.globalInputListeners.size(); ++j) {
                                this.globalInputListeners.get(j).onMouseEntered(this.getCurrentHoveredWidget(true), isTopMost, hasFocus);
                            }
                        }
                        for (j = 0; j < this.globalInputListeners.size(); ++j) {
                            this.globalInputListeners.get(j).onMouseMoved(hpr.getLeafResult().getWidget(), pickXHUD_, pickYHUD_, (int)meta, when, isTopMost, hasFocus);
                        }
                        continue block10;
                    }
                    case MOUSE_STOPPED: {
                        if (!isTopMost) continue block10;
                        this.displayToolTipIfNeeded(hpr.getLeafResult().getWidget(), canvasX, canvasY);
                        continue block10;
                    }
                    case MOUSE_WHEEL_MOVED_UP: {
                        int j;
                        __HUD_base_PrivilegedAccess.onMouseWheelMoved(pickedWidget, 1, meta != 0L, pickXHUD_, pickYHUD_, when, isTopMost);
                        for (j = 0; j < this.globalInputListeners.size(); ++j) {
                            this.globalInputListeners.get(j).onMouseWheelMoved(hpr.getLeafResult().getWidget(), 1, meta != 0L, pickXHUD_, pickYHUD_, when, isTopMost);
                        }
                        continue block10;
                    }
                    case MOUSE_WHEEL_MOVED_DOWN: {
                        int j;
                        __HUD_base_PrivilegedAccess.onMouseWheelMoved(pickedWidget, -1, meta != 0L, pickXHUD_, pickYHUD_, when, isTopMost);
                        for (j = 0; j < this.globalInputListeners.size(); ++j) {
                            this.globalInputListeners.get(j).onMouseWheelMoved(hpr.getLeafResult().getWidget(), -1, meta != 0L, pickXHUD_, pickYHUD_, when, isTopMost);
                        }
                        continue block10;
                    }
                }
            }
        }
        if (!justTest) {
            if (this.pickedWidgets.size() == 0 || this.pickedWidgets.size() == 1 && this.pickedWidgets.get(0).getWidget() == this.getContentPane() && this.getContentPane().getBackgroundColor() == null && this.getContentPane().getBackgroundTexture() == null) {
                if (!eventsSuppressed && currDialog == null) {
                    for (i = 0; i < this.pickMissedListeners.size(); ++i) {
                        if ((this.pickMissedMasks.get(i) & pickReason.getMaskValue()) <= 0) continue;
                        this.pickMissedListeners.get(i).onHUDPickMissed(button, canvasX, canvasY, pickReason, when, meta);
                    }
                }
                this.checkPopupMenu(null, button, pickXHUD, pickYHUD, pickReason);
            }
            if (topMost != null) {
                Cursor.Type newCursorType = topMost.getInheritedCursorType();
                if (newCursorType != this.currentCursorType && (newCursorType != null || this.currentCursorType != null)) {
                    if (newCursorType == null) {
                        this.setCursorInternal(this.getCursorSet().get(Cursor.Type.POINTER1), Cursor.Type.POINTER1, false);
                    } else {
                        this.setCursorInternal(this.getCursorSet().get(newCursorType), newCursorType, false);
                    }
                }
                if (pickReason == HUDPickResult.HUDPickReason.BUTTON_PRESSED || pickReason == HUDPickResult.HUDPickReason.BUTTON_RELEASED) {
                    this.checkPopupMenu(topMost, button, pickXHUD, pickYHUD, pickReason);
                }
            } else if (this.currentCursorType != Cursor.Type.POINTER1) {
                this.setCursorInternal(this.getCursorSet().get(Cursor.Type.POINTER1), Cursor.Type.POINTER1, false);
            }
        }
        if (topMost != null) {
            if (pickReason == HUDPickResult.HUDPickReason.BUTTON_PRESSED && this.getCurrentVolatilePopup() != null && topMost.getWidget() != this.getCurrentVolatilePopup() && topMost.getLeafResult().getWidget() != this.currentVolatilePopupAssembly) {
                this.removeVolatilePopup();
            }
        } else if (pickReason == HUDPickResult.HUDPickReason.BUTTON_PRESSED && this.getCurrentVolatilePopup() != null) {
            this.removeVolatilePopup();
        }
        Widget topmostWidget = topMost != null ? topMost.getWidget() : null;
        for (int i3 = 0; i3 < this.pickedWidgets.size(); ++i3) {
            HUDPickResult.toPool(this.pickedWidgets.get(i3));
        }
        this.pickedWidgets.clear();
        return topmostWidget;
    }

    void onMouseButtonPressed(MouseButton button, int x, int y, long when, long lastWhen) {
        this.pick(x, y, HUDPickResult.HUDPickReason.BUTTON_PRESSED, button, when, lastWhen, 1);
    }

    void onMouseButtonReleased(MouseButton button, int x, int y, long when, long lastWhen) {
        if (this.getCurrentMouseBoundWidget() == null) {
            this.pick(x, y, HUDPickResult.HUDPickReason.BUTTON_RELEASED, button, when, lastWhen, 1);
        } else {
            Tuple2f locP = Tuple2f.fromPool();
            __HUD_base_PrivilegedAccess.getLocationPixels2HUD_(this.mouseBoundWidget, x, y, locP);
            float pickXHUD = locP.getX();
            float pickYHUD = locP.getY();
            Tuple2f.toPool(locP);
            Widget mbw = this.mouseBoundWidget;
            this.mouseBoundWidget = null;
            __HUD_base_PrivilegedAccess.onMouseButtonReleased(mbw, button, pickXHUD, pickYHUD, when, lastWhen, true, mbw.isFocussable());
        }
    }

    void onMouseMoved(int x, int y, int buttonsState, long when, long lastWhen) {
        Widget mouseBound;
        if (this.currentlyDisplayedTooltipWidget != null) {
            Widget tmp = this.currentlyDisplayedTooltipWidget;
            this.currentlyDisplayedTooltipWidget = null;
            Widget pr = this.pick(x, y, HUDPickResult.HUDPickReason.MOUSE_MOVED, null, when, lastWhen, 4096);
            this.currentlyDisplayedTooltipWidget = tmp;
            if (pr == null || pr != this.currentlyDisplayedTooltipWidget) {
                int minMoveX = (int)(this.getWidth() / 16.0f);
                int minMoveY = (int)(this.getHeight() / 12.0f);
                if (Math.abs(x - this.tooltipStartPoint.getX()) > minMoveX || Math.abs(y - this.tooltipStartPoint.getY()) > minMoveY) {
                    this.disposeToolTip();
                }
            }
        }
        this.lastMousePos.set((float)x * this.getResX() / this.getWidth(), (float)y * this.getResY() / this.getHeight());
        if (this.cursorImage != null && this.currentCursor != null) {
            if (__HUD_base_PrivilegedAccess.getSGNode(this.cursorImage).getParent() == null) {
                this.branchGroup.addChild(__HUD_base_PrivilegedAccess.getSGNode(this.cursorImage));
                __HUD_base_PrivilegedAccess.setHUD(this, this.cursorImage);
            }
            float zpx = (float)this.currentCursor.getZeroPointX() * this.getResX() / this.getWidth();
            float zpy = (float)this.currentCursor.getZeroPointY() * this.getResY() / this.getHeight();
            this.cursorImage.setLocation(this.lastMousePos.getX() - zpx, this.lastMousePos.getY() - zpy);
        }
        if ((mouseBound = this.getCurrentMouseBoundWidget()) != null && this.getCurrentHoveredWidget() != mouseBound) {
            Tuple2f locP = Tuple2f.fromPool();
            __HUD_base_PrivilegedAccess.getLocationPixels2HUD_(mouseBound, x, y, locP);
            float pickXHUD = locP.getX();
            float pickYHUD = locP.getY();
            Tuple2f.toPool(locP);
            __HUD_base_PrivilegedAccess.onMouseMoved(mouseBound, pickXHUD, pickYHUD, buttonsState, when, true, mouseBound.hasFocus());
        } else {
            this.pick(x, y, HUDPickResult.HUDPickReason.MOUSE_MOVED, null, when, buttonsState, 1);
        }
    }

    void onMouseStopped(int x, int y, int buttonsState, long when) {
        if (this.currentHoveredWidget != null) {
            Tuple2f locP = Tuple2f.fromPool();
            this.getCoordinatesConverter().getLocationPixels2HUD(x, y, locP);
            float pickXHUD = locP.getX();
            float pickYHUD = locP.getY();
            Tuple2f.toPool(locP);
            __HUD_base_PrivilegedAccess.onMouseStopped(this.currentHoveredWidget, pickXHUD, pickYHUD, when, true, this.currentHoveredWidget.hasFocus());
        }
        this.pick(x, y, HUDPickResult.HUDPickReason.MOUSE_STOPPED, null, when, buttonsState, 1);
    }

    void onMouseWheelMoved(int wheelDelta, int x, int y, long when, boolean isPageMove) {
        HUDPickResult.HUDPickReason pickReason = wheelDelta > 0 ? HUDPickResult.HUDPickReason.MOUSE_WHEEL_MOVED_UP : (wheelDelta < 0 ? HUDPickResult.HUDPickReason.MOUSE_WHEEL_MOVED_DOWN : null);
        if (pickReason != null) {
            this.pick(x, y, pickReason, null, when, isPageMove ? 1L : 0L, 1);
        }
    }

    void onKeyPressed(Key key, int modifierMask, long when) {
        if (this.currentFocusedWidget != null) {
            __HUD_base_PrivilegedAccess.onKeyPressed(this.currentFocusedWidget, key, modifierMask, when);
            if (!this.globalInputListeners.isEmpty()) {
                Widget leafFocussedWidget = this.getCurrentFocusedWidget(true);
                for (int i = 0; i < this.globalInputListeners.size(); ++i) {
                    this.globalInputListeners.get(i).onKeyPressed(leafFocussedWidget, key, modifierMask, when);
                }
            }
        }
    }

    void onKeyReleased(Key key, int modifierMask, long when) {
        if (this.currentFocusedWidget != null) {
            __HUD_base_PrivilegedAccess.onKeyReleased(this.currentFocusedWidget, key, modifierMask, when);
            if (!this.globalInputListeners.isEmpty()) {
                Widget leafFocussedWidget = this.getCurrentFocusedWidget(true);
                for (int i = 0; i < this.globalInputListeners.size(); ++i) {
                    this.globalInputListeners.get(i).onKeyReleased(leafFocussedWidget, key, modifierMask, when);
                }
            }
        }
    }

    void onKeyTyped(char keyChar, int modifierMask, long when) {
        if (this.currentFocusedWidget != null) {
            __HUD_base_PrivilegedAccess.onKeyTyped(this.currentFocusedWidget, keyChar, modifierMask, when);
            if (!this.globalInputListeners.isEmpty()) {
                Widget leafFocussedWidget = this.getCurrentFocusedWidget(true);
                for (int i = 0; i < this.globalInputListeners.size(); ++i) {
                    this.globalInputListeners.get(i).onKeyTyped(leafFocussedWidget, keyChar, modifierMask, when);
                }
            }
        }
    }

    void onControllerButtonPressed(ControllerButton button, long when) {
        Widget currentFocusedWidget = this.getCurrentFocusedWidget(true);
        if (currentFocusedWidget != null) {
            __HUD_base_PrivilegedAccess.onControllerButtonPressed(currentFocusedWidget, button, when);
            if (!this.globalInputListeners.isEmpty()) {
                Widget leafFocussedWidget = this.getCurrentFocusedWidget(true);
                for (int i = 0; i < this.globalInputListeners.size(); ++i) {
                    this.globalInputListeners.get(i).onControllerButtonPressed(leafFocussedWidget, button, when);
                }
            }
        }
    }

    void onControllerButtonReleased(ControllerButton button, long when) {
        Widget currentFocusedWidget = this.getCurrentFocusedWidget(true);
        if (currentFocusedWidget != null) {
            __HUD_base_PrivilegedAccess.onControllerButtonReleased(currentFocusedWidget, button, when);
            if (!this.globalInputListeners.isEmpty()) {
                Widget leafFocussedWidget = this.getCurrentFocusedWidget(true);
                for (int i = 0; i < this.globalInputListeners.size(); ++i) {
                    this.globalInputListeners.get(i).onControllerButtonReleased(leafFocussedWidget, button, when);
                }
            }
        }
    }

    void onControllerAxisChanged(ControllerAxis axis, float axisDelta, long when) {
        Widget currentFocusedWidget = this.getCurrentFocusedWidget(true);
        if (currentFocusedWidget != null) {
            __HUD_base_PrivilegedAccess.onControllerAxisChanged(currentFocusedWidget, axis, (int)(axisDelta * axis.getScale()), when);
            if (!this.globalInputListeners.isEmpty()) {
                Widget leafFocussedWidget = this.getCurrentFocusedWidget(true);
                for (int i = 0; i < this.globalInputListeners.size(); ++i) {
                    this.globalInputListeners.get(i).onControllerAxisChanged(leafFocussedWidget, axis, axisDelta, when);
                }
            }
        }
    }

    void onInputStateChanged(DeviceComponent comp, int delta, int state, long when) {
        Widget leafFocussedWidget = this.getCurrentFocusedWidget(true);
        if (leafFocussedWidget == null) {
            return;
        }
        __HUD_base_PrivilegedAccess.onInputStateChanged(leafFocussedWidget, comp, delta, state, when, true, true);
        boolean doFocusManagement = true;
        if (comp instanceof DigitalDeviceComponent) {
            if (delta <= 0) {
                doFocusManagement = false;
            }
        } else {
            doFocusManagement = false;
        }
        if (doFocusManagement && leafFocussedWidget.getContainer() != null && !__HUD_base_PrivilegedAccess.widgetBlocksFocusMoveDeviceComponent(leafFocussedWidget, comp)) {
            int i;
            FocusMoveDirection fmd = null;
            if (fmd == null && this.focusMoveUpAccessors != null) {
                for (i = 0; i < this.focusMoveUpAccessors.length; ++i) {
                    if (this.focusMoveUpAccessors[i] != comp) continue;
                    fmd = FocusMoveDirection.UP;
                    break;
                }
            }
            if (fmd == null && this.focusMoveDownAccessors != null) {
                for (i = 0; i < this.focusMoveDownAccessors.length; ++i) {
                    if (this.focusMoveDownAccessors[i] != comp) continue;
                    fmd = FocusMoveDirection.DOWN;
                    break;
                }
            }
            if (fmd == null && this.focusMoveLeftAccessors != null) {
                for (i = 0; i < this.focusMoveLeftAccessors.length; ++i) {
                    if (this.focusMoveLeftAccessors[i] != comp) continue;
                    fmd = FocusMoveDirection.LEFT;
                    break;
                }
            }
            if (fmd == null && this.focusMoveRightAccessors != null) {
                for (i = 0; i < this.focusMoveRightAccessors.length; ++i) {
                    if (this.focusMoveRightAccessors[i] != comp) continue;
                    fmd = FocusMoveDirection.RIGHT;
                    break;
                }
            }
            if (fmd == null && this.focusMoveNextAccessors != null) {
                for (i = 0; i < this.focusMoveNextAccessors.length; ++i) {
                    if (this.focusMoveNextAccessors[i] != comp) continue;
                    fmd = FocusMoveDirection.NEXT;
                    break;
                }
            }
            if (fmd != null && leafFocussedWidget.getContainer() != null) {
                __HUD_base_PrivilegedAccess.moveFocus(leafFocussedWidget.getContainer(), fmd);
            }
        }
        for (int i = 0; i < this.globalInputListeners.size(); ++i) {
            this.globalInputListeners.get(i).onInputStateChanged(leafFocussedWidget, comp, delta, state, when, true, true);
        }
    }

    public void bindFocusMoveAccessor(DeviceComponent comp, FocusMoveDirection direction) {
        DeviceComponent[] accessors;
        switch (direction) {
            case UP: {
                accessors = this.focusMoveUpAccessors;
                break;
            }
            case DOWN: {
                accessors = this.focusMoveDownAccessors;
                break;
            }
            case LEFT: {
                accessors = this.focusMoveLeftAccessors;
                break;
            }
            case RIGHT: {
                accessors = this.focusMoveRightAccessors;
                break;
            }
            case NEXT: {
                accessors = this.focusMoveNextAccessors;
                break;
            }
            default: {
                throw new Error("Unsupported direction " + (Object)((Object)direction));
            }
        }
        if (accessors == null || accessors.length == 0) {
            accessors = new DeviceComponent[]{comp};
        } else {
            DeviceComponent[] newArray = new DeviceComponent[accessors.length + 1];
            System.arraycopy(accessors, 0, newArray, 0, accessors.length);
            newArray[newArray.length - 1] = comp;
            accessors = newArray;
        }
        switch (direction) {
            case UP: {
                this.focusMoveUpAccessors = accessors;
                break;
            }
            case DOWN: {
                this.focusMoveDownAccessors = accessors;
                break;
            }
            case LEFT: {
                this.focusMoveLeftAccessors = accessors;
                break;
            }
            case RIGHT: {
                this.focusMoveRightAccessors = accessors;
                break;
            }
            case NEXT: {
                this.focusMoveNextAccessors = accessors;
            }
        }
    }

    public void unbindFocusMoveAccessor(DeviceComponent comp, FocusMoveDirection direction) {
        Object[] accessors;
        switch (direction) {
            case UP: {
                accessors = this.focusMoveUpAccessors;
                break;
            }
            case DOWN: {
                accessors = this.focusMoveDownAccessors;
                break;
            }
            case LEFT: {
                accessors = this.focusMoveLeftAccessors;
                break;
            }
            case RIGHT: {
                accessors = this.focusMoveRightAccessors;
                break;
            }
            case NEXT: {
                accessors = this.focusMoveNextAccessors;
                break;
            }
            default: {
                throw new Error("Unsupported direction " + (Object)((Object)direction));
            }
        }
        if (accessors == null) {
            return;
        }
        int index = ArrayUtils.indexOf(accessors, comp, true);
        if (index < 0) {
            return;
        }
        if (accessors.length == 1) {
            accessors = null;
            return;
        }
        DeviceComponent[] newArray = new DeviceComponent[accessors.length - 1];
        System.arraycopy(accessors, 0, newArray, 0, index);
        System.arraycopy(accessors, index + 1, newArray, index, accessors.length - index - 1);
        accessors = newArray;
        switch (direction) {
            case UP: {
                this.focusMoveUpAccessors = accessors;
                break;
            }
            case DOWN: {
                this.focusMoveDownAccessors = accessors;
                break;
            }
            case LEFT: {
                this.focusMoveLeftAccessors = accessors;
                break;
            }
            case RIGHT: {
                this.focusMoveRightAccessors = accessors;
                break;
            }
            case NEXT: {
                this.focusMoveNextAccessors = accessors;
            }
        }
    }

    public void setCursorSet(CursorSet cursorSet) {
        if (cursorSet == null) {
            throw new IllegalArgumentException("cursorSet cannot be null.");
        }
        this.cursorSet = cursorSet;
    }

    public final CursorSet getCursorSet() {
        if (this.cursorSet == null) {
            this.cursorSet = HUD.getTheme().getCursorSet();
        }
        return this.cursorSet;
    }

    private final void setCursorInternal(Cursor cursor, Cursor.Type type, boolean allowDetach) {
        if (cursor != null) {
            float texWidth = (float)cursor.getTexture().getOriginalWidth() * this.getResX() / this.getWidth();
            float texHeight = (float)cursor.getTexture().getOriginalHeight() * this.getResY() / this.getHeight();
            Dim2f tmp = Dim2f.fromPool();
            this.getCoordinatesConverter().getSizePixels2HUD(cursor.getZeroPointX(), cursor.getZeroPointY(), tmp);
            float zpx = tmp.getWidth();
            float zpy = tmp.getHeight();
            Dim2f.toPool(tmp);
            if (this.cursorImage == null) {
                this.cursorImage = new Image(true, texWidth, texHeight, cursor.getTexture(), TileMode.TILE_BOTH);
                this.cursorImage.setLocation(this.lastMousePos.getX() - zpx, this.lastMousePos.getY() - zpy);
                this.cursorImage.setZIndex(0x7FFFFFFE);
                this.branchGroup.addChild(__HUD_base_PrivilegedAccess.getSGNode(this.cursorImage));
                __HUD_base_PrivilegedAccess.setHUD(this, this.cursorImage);
            } else {
                if (this.cursorImage.getTexture() != cursor.getTexture()) {
                    this.cursorImage.setTexture(cursor.getTexture());
                }
                if (this.cursorImage.getWidth() != texWidth || this.cursorImage.getHeight() != texHeight) {
                    this.cursorImage.setSize(texWidth, texHeight);
                }
                this.cursorImage.setLocation(this.lastMousePos.getX() - zpx, this.lastMousePos.getY() - zpy);
            }
            this.cursorImage.setVisible(true);
            this.currentCursorType = type;
            this.currentCursor = cursor;
        } else if (allowDetach) {
            if (__HUD_base_PrivilegedAccess.getSGNode(this.cursorImage).getParent() != null) {
                __HUD_base_PrivilegedAccess.getSGNode(this.cursorImage).detach();
            }
            __HUD_base_PrivilegedAccess.setHUD(null, this.cursorImage);
            this.cursorImage = null;
            this.currentCursorType = null;
            this.currentCursor = null;
        } else if (this.cursorImage != null) {
            this.cursorImage.setVisible(false);
        }
    }

    public void setCursor(Cursor pointer1) {
        this.getCursorSet().setPointer1(pointer1);
        if (this.currentCursorType == Cursor.Type.POINTER1) {
            this.setCursorInternal(pointer1, Cursor.Type.POINTER1, true);
        }
    }

    public void setCursor(String pointer1) {
        if (this.getCursorSet().getPointer1() == null) {
            this.getCursorSet().setPointer1(new Cursor(pointer1));
        } else {
            this.getCursorSet().getPointer1().setTexture(pointer1);
        }
        if (this.currentCursorType == Cursor.Type.POINTER1) {
            this.setCursorInternal(this.getCursorSet().getPointer1(), Cursor.Type.POINTER1, true);
        }
    }

    public void setCursorVisible(boolean visible) {
        if (this.cursorImage != null) {
            this.cursorImage.setVisible(visible);
        }
    }

    public final boolean isCursorVisible() {
        if (this.cursorImage == null) {
            return false;
        }
        return this.cursorImage.isVisible();
    }

    private void setCrosshairLocation(Image crosshairImage, int hotspotX, int hotspotY, float imgWidth, float imgHeight) {
        if (hotspotX < 0 || hotspotY < 0) {
            float posX = (this.getResX() - imgWidth) / 2.0f;
            float posY = (this.getResY() - imgHeight) / 2.0f;
            crosshairImage.setLocation(posX, posY);
        } else {
            Dim2f tmp = Dim2f.fromPool();
            this.getCoordinatesConverter().getSizePixels2HUD(hotspotX, hotspotY, tmp);
            float posX = (this.getResX() - imgWidth) / 2.0f + (float)hotspotX;
            float posY = (this.getResY() - imgHeight) / 2.0f + (float)hotspotY;
            Dim2f.toPool(tmp);
            crosshairImage.setLocation(posX, posY);
        }
        this.crosshairHotspotX = hotspotX;
        this.crosshairHotspotY = hotspotY;
    }

    public void setCrosshair(Texture2D texture, int hotspotX, int hotspotY) {
        if (texture != null) {
            Dim2f tmp = Dim2f.fromPool();
            this.getCoordinatesConverter().getSizePixels2HUD(HUDTextureUtils.getTextureWidth(texture), HUDTextureUtils.getTextureHeight(texture), tmp);
            float imgWidth = tmp.getWidth();
            float imgHeight = tmp.getHeight();
            Dim2f.toPool(tmp);
            if (this.crosshairImage == null) {
                this.crosshairImage = new Image(true, imgWidth, imgHeight, texture, TileMode.TILE_BOTH);
                this.crosshairImage.setZIndex(32768);
                this.setCrosshairLocation(this.crosshairImage, hotspotX, hotspotY, imgWidth, imgHeight);
                this.branchGroup.addChild(__HUD_base_PrivilegedAccess.getSGNode(this.crosshairImage));
                __HUD_base_PrivilegedAccess.setHUD(this, this.crosshairImage);
            } else {
                this.crosshairImage.setTexture(texture);
                if (this.crosshairImage.getWidth() != imgWidth || this.crosshairImage.getHeight() != imgHeight) {
                    this.crosshairImage.setSize(imgWidth, imgHeight);
                    this.setCrosshairLocation(this.crosshairImage, hotspotX, hotspotY, imgWidth, imgHeight);
                } else if (hotspotX != this.crosshairHotspotX || hotspotY != this.crosshairHotspotY) {
                    this.setCrosshairLocation(this.crosshairImage, hotspotX, hotspotY, imgWidth, imgHeight);
                }
            }
        } else {
            if (__HUD_base_PrivilegedAccess.getSGNode(this.crosshairImage).getParent() != null) {
                this.branchGroup.removeChild(__HUD_base_PrivilegedAccess.getSGNode(this.crosshairImage));
            }
            this.crosshairImage = null;
        }
    }

    public final void setCrosshair(Texture2D texture, Tuple2i hotspot) {
        this.setCrosshair(texture, hotspot.getX(), hotspot.getY());
    }

    public final void setCrosshair(String texture, int hotspotX, int hotspotY) {
        this.setCrosshair(HUDTextureUtils.getTexture(texture, true), hotspotX, hotspotY);
    }

    public final void setCrosshair(String texture, Tuple2i hotspot) {
        this.setCrosshair(texture, hotspot.getX(), hotspot.getY());
    }

    public final void setCrosshair(Texture2D texture) {
        this.setCrosshair(texture, -1, -1);
    }

    public final void setCrosshair(String texture) {
        this.setCrosshair(texture, -1, -1);
    }

    public void setCrosshairVisible(boolean visible) {
        if (this.crosshairImage != null) {
            this.crosshairImage.setVisible(visible);
        }
    }

    public final boolean isCrosshairVisible() {
        if (this.crosshairImage == null) {
            return false;
        }
        return this.crosshairImage.isVisible();
    }

    public final OperationScheduler getOperationScheduler() {
        return this.opScheduler;
    }

    final void updateOperations(long nanoGameTime, long nanoFrameTime) {
        this.opScheduler.update(nanoGameTime, nanoFrameTime, UpdatingThread.TimingMode.NANOSECONDS);
    }

    public void connect(ExtSized2i canvas) {
        if (this.isConnected()) {
            return;
        }
        this.canvasConnection = new HUDCanvas3DConnection();
        canvas.addResizeListener(this.canvasConnection);
        this.update();
    }

    public void connect(InputSystem inputSystem) {
        if (inputSystem != null) {
            this.inputSystemConnection = new HUDInputSystemConnection(this);
            inputSystem.addInputListener(this.inputSystemConnection);
            inputSystem.addInputStateListener(this.inputSystemConnection);
            if (inputSystem.hasMouse()) {
                Mouse mouse = inputSystem.getMouse();
                this.lastMousePos.set(mouse.getCurrentX(), (float)mouse.getCurrentY());
                mouse.addMouseStopListener(this.inputSystemConnection);
            }
        }
    }

    public void disconnect(ExtSized2i canvas) {
        if (this.canvasConnection != null) {
            canvas.removeResizeListener(this.canvasConnection);
            this.canvasConnection = null;
        }
    }

    public void disconnect(InputSystem inputSystem) {
        if (inputSystem != null && this.inputSystemConnection != null) {
            inputSystem.removeInputListener(this.inputSystemConnection);
            inputSystem.removeInputStateListener(this.inputSystemConnection);
            if (inputSystem.hasMouse()) {
                Mouse mouse = inputSystem.getMouse();
                mouse.removeMouseStopListener(this.inputSystemConnection);
            }
            this.inputSystemConnection = null;
        }
    }

    public final boolean isConnected() {
        return this.canvasConnection != null;
    }

    protected WidgetContainer createDefaultContentPane(boolean heavyWeight, float resX, float resY) {
        Panel p = new Panel(heavyWeight, resX, resY, null, null);
        p.setClippingEnabled(false);
        p.setName("HUD ContentPane");
        return p;
    }

    protected HUD(int canvasWidth, int canvasHeight, Sized2fRO resolution, WidgetContainer contentPane, boolean createHeavyWeightContentPane) {
        float resY;
        Node.pushGlobalIgnoreBounds(true);
        this.branchGroup = new BranchGroup();
        Node.popGlobalIgnoreBounds();
        float resX = resolution == null ? (float)canvasWidth : resolution.getWidth();
        float f = resY = resolution == null ? (float)canvasHeight : resolution.getHeight();
        if (contentPane == null) {
            this.setContentPane(this.createDefaultContentPane(createHeavyWeightContentPane, resX, resY));
        } else {
            this.setContentPane(contentPane);
        }
        this.setSize(canvasWidth, canvasHeight, resolution);
        this.lastMousePos = new Tuple2f(this.getResX() / 2.0f, this.getResY() / 2.0f);
    }

    public HUD(int canvasWidth, int canvasHeight, Sized2fRO resolution, WidgetContainer contentPane) {
        this(canvasWidth, canvasHeight, resolution, contentPane, true);
    }

    public HUD(int canvasWidth, int canvasHeight, Sized2fRO resolution) {
        this(canvasWidth, canvasHeight, resolution, null);
    }

    public HUD(int canvasWidth, int canvasHeight, float resX, float resY) {
        this(canvasWidth, canvasHeight, new Dim2f(resX, resY));
    }

    public HUD(int canvasWidth, int canvasHeight, float resX, float resY, WidgetContainer contentPane) {
        this(canvasWidth, canvasHeight, new Dim2f(resX, resY), contentPane);
    }

    public HUD(Sized2iRO canvas, Sized2fRO resolution) {
        this(canvas.getWidth(), canvas.getHeight(), resolution);
    }

    public HUD(Sized2iRO canvas, Sized2fRO resolution, WidgetContainer contentPane) {
        this(canvas.getWidth(), canvas.getHeight(), resolution, contentPane);
    }

    public HUD(Sized2iRO canvas, float resX) {
        this(canvas.getWidth(), canvas.getHeight(), resX, resX / canvas.getAspect());
    }

    public HUD(Sized2iRO canvas, float resX, boolean createHeavyWeightContentPane) {
        this(canvas.getWidth(), canvas.getHeight(), new Dim2f(resX, resX / canvas.getAspect()), null, createHeavyWeightContentPane);
    }

    public HUD(Sized2iRO canvas, float resX, WidgetContainer contentPane) {
        this(canvas.getWidth(), canvas.getHeight(), resX, resX / canvas.getAspect(), contentPane);
    }

    public HUD(int canvasWidth, int canvasHeight, float resX) {
        this(canvasWidth, canvasHeight, new Dim2f(resX, resX / ((float)canvasWidth / (float)canvasHeight)));
    }

    public HUD(int canvasWidth, int canvasHeight, float resX, WidgetContainer contentPane) {
        this(canvasWidth, canvasHeight, new Dim2f(resX, resX / ((float)canvasWidth / (float)canvasHeight)), contentPane);
    }

    public HUD(Sized2iRO canvas, float resX, float resY) {
        this(canvas, new Dim2f(resX, resY));
    }

    public HUD(Sized2iRO canvas, float resX, float resY, boolean createHeavyWeightContentPane) {
        this(canvas.getWidth(), canvas.getHeight(), new Dim2f(resX, resY), null, createHeavyWeightContentPane);
    }

    public HUD(Sized2iRO canvas, float resX, float resY, WidgetContainer contentPane) {
        this(canvas, new Dim2f(resX, resY), contentPane);
    }

    public HUD(int canvasWidth, int canvasHeight) {
        this(canvasWidth, canvasHeight, (Sized2fRO)null);
    }

    public HUD(Sized2iRO canvas) {
        this(canvas, null);
    }

    public HUD(Sized2iRO canvas, boolean createHeavyWeightContentPane) {
        this(canvas.getWidth(), canvas.getHeight(), null, null, createHeavyWeightContentPane);
    }

    private class HUDCanvas3DConnection
    implements ResizeListener2i {
        private HUDCanvas3DConnection() {
        }

        public void onObjectResized(Sized2i object, int oldWidth, int oldHeight, int newWidth, int newHeight) {
            HUD.this.setSize(newWidth, newHeight, -1.0f, -1.0f);
            HUD.this.fixRenderPass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FocusMoveDirection {
        UP,
        LEFT,
        RIGHT,
        DOWN,
        NEXT;

    }
}

