/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.base;

import java.util.ArrayList;
import org.jagatoo.datatypes.Enableable;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.DigitalDeviceComponent;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.util.arrays.ArrayUtils;
import org.openmali.types.twodee.Dim2f;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.listeners.ButtonListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractButton
extends Widget
implements Enableable {
    protected ButtonState buttonState;
    protected boolean isStateChangable = true;
    private boolean enabled = true;
    private final ArrayList<ButtonListener> listeners = new ArrayList();
    private static DeviceComponent[] accessors = new DeviceComponent[]{Keys.ENTER, Keys.SPACE};
    private static boolean isDefaultFocusResponsive = false;
    private boolean isFocusResponsive = isDefaultFocusResponsive;

    public static final void setDefaultFocusResponsive(boolean resp) {
        isDefaultFocusResponsive = resp;
    }

    public static final boolean isDefaultFocusResponsive() {
        return isDefaultFocusResponsive;
    }

    public final void setFocusResponsive(boolean resp) {
        this.isFocusResponsive = resp;
    }

    public final boolean isFocusResponsive() {
        return this.isFocusResponsive;
    }

    public static void bindAccessor(DeviceComponent comp) {
        if (accessors == null || accessors.length == 0) {
            accessors = new DeviceComponent[]{comp};
        } else {
            DeviceComponent[] newArray = new DeviceComponent[accessors.length + 1];
            System.arraycopy(accessors, 0, newArray, 0, accessors.length);
            newArray[newArray.length - 1] = comp;
            accessors = newArray;
        }
    }

    public static void unbindAccessor(DeviceComponent comp) {
        if (accessors == null) {
            return;
        }
        int index = ArrayUtils.indexOf(accessors, comp, true);
        if (index < 0) {
            return;
        }
        if (accessors.length == 1) {
            accessors = null;
            return;
        }
        DeviceComponent[] newArray = new DeviceComponent[accessors.length - 1];
        System.arraycopy(accessors, 0, newArray, 0, index);
        System.arraycopy(accessors, index + 1, newArray, index, accessors.length - index - 1);
        accessors = newArray;
    }

    public void addButtonListener(ButtonListener l) {
        this.listeners.add(l);
    }

    public void removeButtonListener(ButtonListener l) {
        this.listeners.remove(l);
    }

    protected void fireButtonClickedEvent() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onButtonClicked(this, this.getUserObject());
        }
    }

    protected abstract void setEnabledImpl(boolean var1);

    @Override
    public final void setEnabled(boolean enabled) {
        if (enabled == this.enabled) {
            return;
        }
        this.enabled = enabled;
        this.setEnabledImpl(enabled);
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    public boolean setButtonState(ButtonState buttonState) {
        if (buttonState == null) {
            throw new IllegalArgumentException("buttonState must not be null");
        }
        if (buttonState == this.buttonState) {
            return false;
        }
        this.buttonState = buttonState;
        return true;
    }

    public final ButtonState getButtonState() {
        return this.buttonState;
    }

    @Override
    protected void onMouseEntered(boolean isTopMost, boolean hasFocus) {
        super.onMouseEntered(isTopMost, hasFocus);
        if (isTopMost && this.isStateChangable && this.isEnabled()) {
            this.setButtonState(ButtonState.HOVERED);
        }
    }

    @Override
    protected void onMouseExited(boolean isTopMost, boolean hasFocus) {
        super.onMouseExited(isTopMost, hasFocus);
        if (isTopMost && this.isStateChangable && this.isEnabled()) {
            this.setButtonState(ButtonState.NORMAL);
        }
    }

    @Override
    protected void onMouseButtonPressed(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
        super.onMouseButtonPressed(button, x, y, when, lastWhen, isTopMost, hasFocus);
        if (isTopMost && this.isStateChangable && this.isEnabled()) {
            this.setButtonState(ButtonState.PRESSED);
        }
    }

    @Override
    protected void onMouseButtonReleased(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
        super.onMouseButtonReleased(button, x, y, when, lastWhen, isTopMost, hasFocus);
        if (isTopMost && this.isStateChangable && this.isEnabled()) {
            this.setButtonState(ButtonState.HOVERED);
            this.fireButtonClickedEvent();
        }
    }

    @Override
    protected void onInputStateChanged(DeviceComponent comp, int delta, int state, long when, boolean isTopMost, boolean hasFocus) {
        super.onInputStateChanged(comp, delta, state, when, isTopMost, hasFocus);
        if (comp instanceof DigitalDeviceComponent) {
            if (delta <= 0) {
                return;
            }
        } else {
            return;
        }
        if (accessors != null) {
            for (int i = 0; i < accessors.length; ++i) {
                if (accessors[i] != comp) continue;
                this.fireButtonClickedEvent();
                return;
            }
        }
    }

    public abstract <Dim2f_ extends Dim2f> Dim2f_ getOptimalSize(Dim2f_ var1);

    public AbstractButton(boolean isHeavyWeight, boolean hasWidgetAssembler, float width, float height) {
        super(isHeavyWeight, hasWidgetAssembler, width, height);
        this.buttonState = ButtonState.NORMAL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ButtonState {
        NORMAL,
        HOVERED,
        PRESSED;

    }
}

