/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.base;

import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.utils.DrawUtils;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.utils.TileMode;

public abstract class BackgroundSettableWidget
extends Widget {
    private Colorf backgroundColor;
    private Texture2D backgroundTexture;
    private TileMode bgTileMode = TileMode.STRETCH;

    public void setBackgroundColor(Colorf color) {
        this.backgroundColor = color;
        this.setTextureDirty();
    }

    public final Colorf getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundTexture(Texture2D texture) {
        this.backgroundTexture = texture;
        this.setTextureDirty();
    }

    public void setBackgroundTexture(Texture2D texture, TileMode tileMode) {
        this.backgroundTexture = texture;
        this.bgTileMode = tileMode;
        this.setTextureDirty();
    }

    public final void setBackgroundTexture(String texture) {
        this.setBackgroundTexture(HUDTextureUtils.getTexture(texture, true));
    }

    public final void setBackgroundTexture(String texture, TileMode tileMode) {
        this.setBackgroundTexture(HUDTextureUtils.getTexture(texture, true), tileMode);
    }

    public final void setBackground(Colorf color, String texture, TileMode tileMode) {
        this.setBackgroundColor(color);
        this.setBackgroundTexture(texture);
        this.setBackgroundTileMode(tileMode);
    }

    public final void setBackground(Colorf color, Texture2D texture, TileMode tileMode) {
        this.setBackgroundColor(color);
        this.setBackgroundTexture(texture);
        this.setBackgroundTileMode(tileMode);
    }

    public final void setBackground(Colorf color, String texture) {
        this.setBackgroundColor(color);
        this.setBackgroundTexture(texture);
    }

    public final void setNoBackground() {
        this.setBackgroundColor(null);
        this.setBackgroundTexture((Texture2D)null);
    }

    public final Texture2D getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public void setBackgroundTileMode(TileMode mode) {
        this.bgTileMode = mode;
        this.setTextureDirty();
    }

    public final TileMode getBackgroundTileMode() {
        return this.bgTileMode;
    }

    protected void drawBackground(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
        if (this.isHeavyWeight()) {
            if (this.getBackgroundColor() == null && this.getBackgroundTexture() == null) {
                DrawUtils.clearImage(Colorf.BLACK_TRANSPARENT, null, null, texCanvas, offsetX, offsetY, width, height);
            } else {
                DrawUtils.clearImage(this.getBackgroundColor(), this.getBackgroundTexture(), this.getBackgroundTileMode(), texCanvas, offsetX, offsetY, width, height);
            }
        } else if (this.getBackgroundColor() == null && this.getBackgroundTexture() == null) {
            if (this.getContainer() != null && !this.getContainer().isThisWidgetDirty() && this.getAssembly() == null) {
                this.getContainer().drawParentBackground(this, texCanvas, offsetX, offsetY, width, height);
            }
        } else if (this.getBackgroundColor() != null && !this.getBackgroundColor().hasAlpha() || this.getBackgroundTexture() != null && !this.getBackgroundTexture().getFormat().hasAlpha()) {
            DrawUtils.clearImage(this.getBackgroundColor(), this.getBackgroundTexture(), this.getBackgroundTileMode(), texCanvas, offsetX, offsetY, width, height);
        } else {
            if (this.getContainer() != null && !this.getContainer().isThisWidgetDirty() && this.getAssembly() == null) {
                this.getContainer().drawParentBackground(this, texCanvas, offsetX, offsetY, width, height);
            }
            DrawUtils.drawImage(this.getBackgroundColor(), this.getBackgroundTexture(), this.getBackgroundTileMode(), texCanvas, offsetX, offsetY, width, height);
        }
    }

    protected BackgroundSettableWidget(boolean isHeavyWeight, boolean hasWidgetAssembler, Colorf backgroundColor, Texture2D backgroundTexture, TileMode tileMode) {
        super(isHeavyWeight, hasWidgetAssembler);
        this.setBackground(backgroundColor, backgroundTexture, tileMode);
    }

    protected BackgroundSettableWidget(boolean isHeavyWeight, boolean hasWidgetAssembler, float width, float height, Colorf backgroundColor, Texture2D backgroundTexture, TileMode tileMode) {
        super(isHeavyWeight, hasWidgetAssembler, width, height);
        this.setBackground(backgroundColor, backgroundTexture, tileMode);
    }

    protected static abstract class BackgroundSettableDescriptionBase
    extends Widget.DescriptionBase {
        private Colorf backgroundColor;
        private Texture2D backgroundTexture;

        public void setBackgroundColor(Colorf color) {
            this.backgroundColor = color;
        }

        public final Colorf getBackgroundColor() {
            return this.backgroundColor;
        }

        public void setBackgroundTexture(Texture2D texture) {
            this.backgroundTexture = texture;
        }

        public final void setBackgroundTexture(String texture) {
            if (texture != null) {
                this.setBackgroundTexture(HUDTextureUtils.getTexture(texture, true));
            } else {
                this.setBackgroundTexture((Texture2D)null);
            }
        }

        public final Texture2D getBackgroundTexture() {
            return this.backgroundTexture;
        }

        protected void setBgSDB(BackgroundSettableDescriptionBase desc) {
            this.backgroundColor = desc.backgroundColor;
            this.backgroundTexture = desc.backgroundTexture;
        }

        public abstract BackgroundSettableDescriptionBase clone();

        public BackgroundSettableDescriptionBase(Colorf backgroundColor, Texture2D backgroundTexture) {
            this.backgroundColor = backgroundColor;
            this.backgroundTexture = backgroundTexture;
        }
    }
}

