/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.base;

import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.utils.HUDTextureUtils;

public abstract class Border {
    private int bottomHeight;
    private int rightWidth;
    private int topHeight;
    private int leftwidth;

    public final int getBottomHeight() {
        return this.bottomHeight;
    }

    public final int getRightWidth() {
        return this.rightWidth;
    }

    public final int getTopHeight() {
        return this.topHeight;
    }

    public final int getLeftWidth() {
        return this.leftwidth;
    }

    public abstract void drawBorder(Texture2DCanvas var1, int var2, int var3, int var4, int var5, Widget var6);

    protected Border(int bottomHeight, int rightWidth, int topHeight, int leftwidth) {
        this.bottomHeight = bottomHeight;
        this.rightWidth = rightWidth;
        this.topHeight = topHeight;
        this.leftwidth = leftwidth;
    }

    public static class Description
    extends Widget.DescriptionBase {
        private String name = null;
        private int leftWidth;
        private int rightWidth;
        private int topHeight;
        private int bottomHeight;
        private int llUpperHeight;
        private int llRightWidth;
        private int lrLeftWidth;
        private int lrUpperHeight;
        private int urLowerHeight;
        private int urLeftWidth;
        private int ulRightWidth;
        private int ulLowerHeight;
        private Colorf color;
        private Texture2D texture;

        public void setName(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }

        public final boolean hasNonZeroSize() {
            return (float)(this.bottomHeight + this.rightWidth + this.topHeight + this.leftWidth) > 0.0f;
        }

        public void setBottomHeight(int bh) {
            this.bottomHeight = bh;
        }

        public final int getBottomHeight() {
            return this.bottomHeight;
        }

        public void setRightWidth(int rw) {
            this.rightWidth = rw;
        }

        public final int getRightWidth() {
            return this.rightWidth;
        }

        public void setTopHeight(int th) {
            this.topHeight = th;
        }

        public final int getTopHeight() {
            return this.topHeight;
        }

        public void setLeftWidth(int lw) {
            this.leftWidth = lw;
        }

        public final int getLeftWidth() {
            return this.leftWidth;
        }

        public void setLLupperHeight(int value) {
            this.llUpperHeight = value;
        }

        public final int getLLupperHeight() {
            return this.llUpperHeight;
        }

        public void setLLrightWidth(int value) {
            this.llRightWidth = value;
        }

        public final int getLLrightWidth() {
            return this.llRightWidth;
        }

        public void setLRleftWidth(int value) {
            this.lrLeftWidth = value;
        }

        public final int getLRleftWidth() {
            return this.lrLeftWidth;
        }

        public void setLRupperHeight(int value) {
            this.lrUpperHeight = value;
        }

        public final int getLRupperHeight() {
            return this.lrUpperHeight;
        }

        public void setURlowerHeight(int value) {
            this.urLowerHeight = value;
        }

        public final int getURlowerHeight() {
            return this.urLowerHeight;
        }

        public void setURleftWidth(int value) {
            this.urLeftWidth = value;
        }

        public final int getURleftWidth() {
            return this.urLeftWidth;
        }

        public void setULrightWidth(int value) {
            this.ulRightWidth = value;
        }

        public final int getULrightWidth() {
            return this.ulRightWidth;
        }

        public void setULlowerHeight(int value) {
            this.ulLowerHeight = value;
        }

        public final int getULlowerHeight() {
            return this.ulLowerHeight;
        }

        public void setSizes(int bottom, int right, int top, int left) {
            this.bottomHeight = bottom;
            this.rightWidth = right;
            this.topHeight = top;
            this.leftWidth = left;
        }

        public void setSizes(int bottom, int right, int top, int left, int heightLLupper, int widthLLright, int widthLRleft, int heightLRupper, int heightURlower, int widthURleft, int widthULright, int heightULlower) {
            this.bottomHeight = bottom;
            this.rightWidth = right;
            this.topHeight = top;
            this.leftWidth = left;
            this.llUpperHeight = heightLLupper;
            this.llRightWidth = widthLLright;
            this.lrLeftWidth = widthLRleft;
            this.lrUpperHeight = heightLRupper;
            this.urLowerHeight = heightURlower;
            this.urLeftWidth = widthURleft;
            this.ulRightWidth = widthULright;
            this.ulLowerHeight = heightULlower;
        }

        public void setColor(Colorf color) {
            this.color = color;
        }

        public final Colorf getColor() {
            return this.color;
        }

        public void setTexture(Texture2D texture) {
            this.texture = texture;
        }

        public final void setTexture(String texture) {
            this.setTexture(HUDTextureUtils.getTextureOrNull(texture, true));
        }

        public final Texture2D getTexture() {
            return this.texture;
        }

        public void set(Description bd) {
            this.name = bd.name;
            this.bottomHeight = bd.bottomHeight;
            this.rightWidth = bd.rightWidth;
            this.topHeight = bd.topHeight;
            this.leftWidth = bd.leftWidth;
            this.llUpperHeight = bd.llUpperHeight;
            this.llRightWidth = bd.llRightWidth;
            this.lrLeftWidth = bd.lrLeftWidth;
            this.lrUpperHeight = bd.lrUpperHeight;
            this.urLowerHeight = bd.urLowerHeight;
            this.urLeftWidth = bd.urLeftWidth;
            this.ulRightWidth = bd.ulRightWidth;
            this.ulLowerHeight = bd.ulLowerHeight;
            this.color = bd.color;
            this.texture = bd.texture;
        }

        public Description clone() {
            return new Description(this);
        }

        private Description(Description bd) {
            this.set(bd);
        }

        public Description(int bottom, int right, int top, int left, int heightLLupper, int widthLLright, int widthLRleft, int heightLRupper, int heightURlower, int widthURleft, int widthULright, int heightULlower, Texture2D texture) {
            this.bottomHeight = bottom;
            this.rightWidth = right;
            this.topHeight = top;
            this.leftWidth = left;
            this.llUpperHeight = heightLLupper;
            this.llRightWidth = widthLLright;
            this.lrLeftWidth = widthLRleft;
            this.lrUpperHeight = heightLRupper;
            this.urLowerHeight = heightURlower;
            this.urLeftWidth = widthURleft;
            this.ulRightWidth = widthULright;
            this.ulLowerHeight = heightULlower;
            this.texture = texture;
        }

        public Description(int bottom, int right, int top, int left, Texture2D texture) {
            this(bottom, right, top, left, 0, 0, 0, 0, 0, 0, 0, 0, texture);
        }

        public Description(int bottom, int right, int top, int left, int heightLLupper, int widthLLright, int widthLRleft, int heightLRupper, int heightURlower, int widthURleft, int widthULright, int heightULlower, String texture) {
            this(bottom, right, top, left, heightLLupper, widthLLright, widthLRleft, heightLRupper, heightURlower, widthURleft, widthULright, heightULlower, HUDTextureUtils.getTexture(texture, true));
        }

        public Description(int bottom, int right, int top, int left, String texture) {
            this(bottom, right, top, left, 0, 0, 0, 0, 0, 0, 0, 0, HUDTextureUtils.getTexture(texture, true));
        }

        public Description(int bottom, int right, int top, int left) {
            this(bottom, right, top, left, (Texture2D)null);
        }

        public Description(int bottom, int right, int top, int left, Colorf color) {
            this(bottom, right, top, left);
            this.setColor(color);
        }

        public Description(int width, Colorf color) {
            this(width, width, width, width, color);
        }
    }
}

