/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.base;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jagatoo.datatypes.NamableObject;
import org.jagatoo.input.devices.components.ControllerAxis;
import org.jagatoo.input.devices.components.ControllerButton;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.opengl.enums.TestFunction;
import org.openmali.types.primitives.MutableLong;
import org.openmali.types.twodee.Dim2f;
import org.openmali.types.twodee.Dim2i;
import org.openmali.types.twodee.Positioned2f;
import org.openmali.types.twodee.Rect2i;
import org.openmali.types.twodee.Sized2f;
import org.openmali.types.twodee.Sized2fRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point2f;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Tuple2i;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.DrawRectangle;
import org.xith3d.scenegraph.utils.ShapeUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.__HUD_PrivilegedAccess;
import org.xith3d.ui.hud.base.Border;
import org.xith3d.ui.hud.base.PaddingSettable;
import org.xith3d.ui.hud.base.TextWidget;
import org.xith3d.ui.hud.base.WidgetAssembler;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.base.Window;
import org.xith3d.ui.hud.borders.BorderFactory;
import org.xith3d.ui.hud.contextmenu.ContextMenu;
import org.xith3d.ui.hud.listeners.WidgetContainerListener;
import org.xith3d.ui.hud.listeners.WidgetControllerListener;
import org.xith3d.ui.hud.listeners.WidgetFocusListener;
import org.xith3d.ui.hud.listeners.WidgetInputListener;
import org.xith3d.ui.hud.listeners.WidgetKeyboardListener;
import org.xith3d.ui.hud.listeners.WidgetLocationListener;
import org.xith3d.ui.hud.listeners.WidgetMouseListener;
import org.xith3d.ui.hud.listeners.WidgetSizeListener;
import org.xith3d.ui.hud.listeners.WidgetVisibilityListener;
import org.xith3d.ui.hud.utils.Cursor;
import org.xith3d.ui.hud.utils.DrawUtils;
import org.xith3d.ui.hud.utils.DropShadowFactory;
import org.xith3d.ui.hud.utils.HUDPickResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Widget
implements Positioned2f,
Sized2f,
NamableObject {
    private static final MutableLong MIN_UPDATE_DELAY = new MutableLong(50000000L);
    private long forcedUpdateDelay = -1L;
    private static final RenderingAttributes RENDERING_ATTRIBUTES = new RenderingAttributes();
    private final boolean isHeavyWeight;
    private Widget hostWidget = null;
    private boolean isPassive = false;
    private Boolean hierarchyOK = null;
    private final TransformGroup transformGroup;
    private final WidgetAssembler widgetAssembler;
    private String name = "";
    private Object userObject = null;
    private Widget assembly = null;
    private Border border = null;
    private int widthPX = -1;
    private int heightPX = -1;
    private int contentWidthPX = -1;
    private int contentHeightPX = -1;
    protected float transformWidth_Pixels2HUD = -1.0f;
    protected float transformHeight_Pixels2HUD = -1.0f;
    private HUD hud = null;
    private WidgetContainer container = null;
    private ContextMenu contextMenu = null;
    private String tooltip = null;
    private Widget cachedTooltipWidget = null;
    private final Dim2f size = new Dim2f(0.0f, 0.0f);
    private final Tuple2f location = new Point2f(0.0f, 0.0f);
    private int zIndex = 0;
    private boolean hovered = false;
    private boolean isVisible = true;
    private boolean isClickable = true;
    private boolean isPickable = true;
    private boolean isDraggable;
    private boolean isInitialized = false;
    private boolean isInitializing = false;
    private Cursor.Type cursorType = null;
    private Point2f dragStart = null;
    private final Point2f tmpDragStart = new Point2f();
    private Tuple2f dragStartWidget = null;
    private final Tuple2f tmpDragStartWidget = new Point2f();
    private boolean focussable = true;
    private boolean focusRequested = false;
    private float transparency = 0.0f;
    private boolean earlyTransparencyChildrenToo = false;
    private DrawRectangle shape = null;
    private final Texture2DCanvas.DrawCallback2D drawCallback;
    boolean isThisWidgetDirty = true;
    private boolean isAHostedWidgetDirty = true;
    private boolean hasDropShadow = false;
    private final Rect2i oldClip = new Rect2i();
    private final Rect2i clip = new Rect2i();
    private final ArrayList<WidgetKeyboardListener> keyboardListeners = new ArrayList(1);
    private final ArrayList<WidgetMouseListener> mouseListeners = new ArrayList(1);
    private final ArrayList<WidgetControllerListener> controllerListeners = new ArrayList(1);
    private final ArrayList<WidgetFocusListener> focusListeners = new ArrayList(1);
    private final ArrayList<WidgetLocationListener> locationListeners = new ArrayList(1);
    private final ArrayList<WidgetSizeListener> sizeListeners = new ArrayList(1);
    private final ArrayList<WidgetVisibilityListener> visibilityListeners = new ArrayList(1);
    private final ArrayList<WidgetContainerListener> containerListeners = new ArrayList(1);
    private final ZIndexComparable zIndexComparable = new ZIndexComparable();

    public final boolean isHeavyWeight() {
        return this.isHeavyWeight;
    }

    final Node getSGNode() {
        return this.transformGroup;
    }

    public Window getParentWindow() {
        if (this.getContainer() == null) {
            return null;
        }
        return this.getContainer().getParentWindow();
    }

    @Override
    public void setName(String name) {
        this.name = name;
        if (this.transformGroup != null) {
            this.transformGroup.setName(name);
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public final Object getUserObject() {
        return this.userObject;
    }

    public void setContextMenu(ContextMenu contextMenu) {
        this.contextMenu = contextMenu;
    }

    public ContextMenu getContextMenu() {
        if (this.contextMenu != null) {
            if (this.contextMenu.getHUD() == null) {
                this.contextMenu.setHUD(this.getHUD());
            }
            return this.contextMenu;
        }
        WidgetContainer container = this.getContainer();
        if (container != null) {
            return container.getContextMenu();
        }
        return null;
    }

    public void setToolTip(String tooltip) {
        this.tooltip = tooltip;
        this.cachedTooltipWidget = null;
    }

    public final String getToolTip() {
        return this.tooltip;
    }

    public final boolean hasToolTip() {
        return this.tooltip != null && this.tooltip.length() > 0;
    }

    void setCachedToolTipWidget(Widget tooltipWidget) {
        this.cachedTooltipWidget = tooltipWidget;
    }

    final Widget getCachedToolTipWidget() {
        return this.cachedTooltipWidget;
    }

    public void setHasDropShadow(boolean b) {
        if (this.hasDropShadow == b) {
            return;
        }
        this.hasDropShadow = b;
        this.setSize(this.getWidth(), this.getHeight(), true);
    }

    public final boolean hasDropShadow() {
        return this.hasDropShadow;
    }

    protected final WidgetAssembler getWidgetAssembler() {
        return this.widgetAssembler;
    }

    protected final float getEqualWidth_(float height) {
        if (this.getContainer() != null) {
            return this.getContainer().getEqualWidth(height);
        }
        if (this.getHUD() != null) {
            return this.getHUD().getCoordinatesConverter().getEqualWidth(height);
        }
        throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
    }

    protected final float getEqualHeight_(float width) {
        if (this.getContainer() != null) {
            return this.getContainer().getEqualHeight(width);
        }
        if (this.getHUD() != null) {
            return this.getHUD().getCoordinatesConverter().getEqualHeight(width);
        }
        throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
    }

    protected final <Dim2f_ extends Dim2f> Dim2f_ getSizePixels2HUD_(int x, int y, Dim2f_ buffer) {
        if (this.getContainer() != null) {
            return this.getContainer().getSizePixels2HUD(x, y, buffer);
        }
        if (this.getHUD() != null) {
            return this.getHUD().getCoordinatesConverter().getSizePixels2HUD(x, y, buffer);
        }
        throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
    }

    protected final <Tuple2f_ extends Tuple2f> Tuple2f_ getLocationPixels2HUD_(int x, int y, Tuple2f_ buffer) {
        x -= this.getContentLeftPX();
        y -= this.getContentTopPX();
        if (this.getContainer() != null) {
            this.getContainer().getLocationPixels2HUD(x, y, buffer);
            buffer.sub(this.getLeft(), this.getTop());
            return buffer;
        }
        if (this.getHUD() != null) {
            this.getHUD().getCoordinatesConverter().getLocationPixels2HUD(x, y, buffer);
            buffer.sub(this.getLeft(), this.getTop());
            return buffer;
        }
        throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
    }

    protected final <Dim2i_ extends Dim2i> Dim2i_ getSizeHUD2Pixels_(float x, float y, Dim2i_ buffer) {
        if (this.getContainer() != null) {
            return this.getContainer().getSizeHUD2Pixels(x, y, buffer);
        }
        if (this.getHUD() != null) {
            return this.getHUD().getCoordinatesConverter().getSizeHUD2Pixels(x, y, buffer);
        }
        throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
    }

    protected final <Tuple2i_ extends Tuple2i> Tuple2i_ getRelLocationHUD2Pixels_(float x, float y, Tuple2i_ buffer) {
        if (this.getContainer() != null) {
            return this.getContainer().getRelLocationHUD2Pixels(x, y, buffer);
        }
        if (this.getHUD() != null) {
            return this.getHUD().getCoordinatesConverter().getLocationHUD2Pixels(x, y, buffer);
        }
        throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
    }

    protected final <Tuple2i_ extends Tuple2i> Tuple2i_ getLocationHUD2Pixels_(float x, float y, Tuple2i_ buffer) {
        if (this.getContainer() != null) {
            return this.getContainer().getLocationHUD2Pixels(x, y, buffer);
        }
        if (this.getHUD() != null) {
            return this.getHUD().getCoordinatesConverter().getLocationHUD2Pixels(x, y, buffer);
        }
        throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
    }

    protected final <Dim2f_ extends Dim2f> Dim2f_ getSizeHUD2SG_(float x, float y, Dim2f_ buffer) {
        if (this.getContainer() != null) {
            return this.getContainer().getSizeHUD2SG(x, y, buffer);
        }
        if (this.getHUD() != null) {
            return this.getHUD().getCoordinatesConverter().getSizeHUD2SG(x, y, buffer);
        }
        throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
    }

    protected final <Tuple2f_ extends Tuple2f> Tuple2f_ getLocationHUD2SG_(float x, float y, Tuple2f_ buffer) {
        if (this.getContainer() != null) {
            return this.getContainer().getLocationHUD2SG(x, y, buffer);
        }
        if (this.getHUD() != null) {
            return this.getHUD().getCoordinatesConverter().getLocationHUD2SG(x, y, buffer);
        }
        throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
    }

    protected final <Dim2f_ extends Dim2f> Dim2f_ getSizeSG2HUD_(float x, float y, Dim2f_ buffer) {
        if (this.getContainer() != null) {
            return this.getContainer().getSizeSG2HUD(x, y, buffer);
        }
        if (this.getHUD() != null) {
            return this.getHUD().getCoordinatesConverter().getSizeSG2HUD(x, y, buffer);
        }
        throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
    }

    protected final <Tuple2f_ extends Tuple2f> Tuple2f_ getLocationSG2HUD_(float x, float y, Tuple2f_ buffer) {
        if (this.getContainer() != null) {
            this.getContainer().getLocationSG2HUD(x, y, buffer);
            return buffer;
        }
        if (this.getHUD() != null) {
            this.getHUD().getCoordinatesConverter().getLocationSG2HUD(x, y, buffer);
            return buffer;
        }
        throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
    }

    protected final <Dim2f_ extends Dim2f> Dim2f_ getSizeOfPixels_(int x, int y, Dim2f_ buffer) {
        if (this.getContainer() != null) {
            return this.getContainer().getSizeOfPixels(x, y, buffer);
        }
        if (this.getHUD() != null) {
            return this.getHUD().getCoordinatesConverter().getSizeOfPixels(x, y, buffer);
        }
        throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
    }

    protected final <Tuple2f_ extends Tuple2f> Tuple2f_ getAbsoluteLocationOnHUD_(Tuple2f_ buffer) {
        if (this.getHUD() != null) {
            this.getHUD().getCoordinatesConverter().getAbsoluteLocationOnHUD(this, buffer);
            return buffer;
        }
        throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
    }

    public void addKeyboardListener(WidgetKeyboardListener l) {
        this.keyboardListeners.add(l);
    }

    public void removeKeyboardListener(WidgetKeyboardListener l) {
        this.keyboardListeners.remove(l);
    }

    public void addMouseListener(WidgetMouseListener l) {
        this.mouseListeners.add(l);
    }

    public void removeMouseListener(WidgetMouseListener l) {
        this.mouseListeners.remove(l);
    }

    public void addControllerListener(WidgetControllerListener l) {
        this.controllerListeners.add(l);
    }

    public void removeControllerListener(WidgetControllerListener l) {
        this.controllerListeners.remove(l);
    }

    public final void addInputListener(WidgetInputListener l) {
        this.addKeyboardListener(l);
        this.addMouseListener(l);
        this.addControllerListener(l);
    }

    public final void removeInputListener(WidgetInputListener l) {
        this.removeKeyboardListener(l);
        this.removeMouseListener(l);
        this.removeControllerListener(l);
    }

    public void addFocusListener(WidgetFocusListener l) {
        this.focusListeners.add(l);
    }

    public void removeFocusListener(WidgetFocusListener l) {
        this.focusListeners.remove(l);
    }

    public void addLocationListener(WidgetLocationListener l) {
        this.locationListeners.add(l);
    }

    public void removeLocationListener(WidgetLocationListener l) {
        this.locationListeners.remove(l);
    }

    public void addSizeListener(WidgetSizeListener l) {
        this.sizeListeners.add(l);
    }

    public void removeSizeListener(WidgetSizeListener l) {
        this.sizeListeners.remove(l);
    }

    public void addVisibilityListener(WidgetVisibilityListener l) {
        this.visibilityListeners.add(l);
    }

    public void removeVisibilityListener(WidgetVisibilityListener l) {
        this.visibilityListeners.remove(l);
    }

    public void addContainerListener(WidgetContainerListener l) {
        this.containerListeners.add(l);
    }

    public void removeContainerListener(WidgetContainerListener l) {
        this.containerListeners.remove(l);
    }

    void notifyContainerListenersAboutAttachedWidget(Widget widget, WidgetContainer container) {
        for (int i = 0; i < this.containerListeners.size(); ++i) {
            this.containerListeners.get(i).onWidgetAttachedToContainer(widget, container);
        }
    }

    void notifyContainerListenersAboutDetachedWidget(Widget widget, WidgetContainer container) {
        for (int i = 0; i < this.containerListeners.size(); ++i) {
            this.containerListeners.get(i).onWidgetDetachedFromContainer(widget, container);
        }
    }

    public void setFocussable(boolean focussable) {
        this.focussable = focussable;
    }

    public final boolean isFocussable() {
        return this.focussable;
    }

    public void requestFocus() {
        if (!this.isFocussable()) {
            return;
        }
        if (this.isInitialized() && this.getHUD() != null) {
            if (this.getContainer() != null) {
                this.getContainer().focus(this);
            } else {
                __HUD_PrivilegedAccess.focus(this.getHUD(), this);
            }
        } else {
            this.focusRequested = true;
        }
    }

    protected void onFocusGained() {
        for (int i = 0; i < this.focusListeners.size(); ++i) {
            this.focusListeners.get(i).onFocusGained(this);
        }
    }

    protected void onFocusLost() {
        for (int i = 0; i < this.focusListeners.size(); ++i) {
            this.focusListeners.get(i).onFocusLost(this);
        }
    }

    public final boolean hasFocus(boolean testLeaf) {
        if (this.getHUD() != null) {
            Widget cfw = __HUD_PrivilegedAccess.getCurrentFocusedWidget(this.getHUD(), testLeaf);
            if (cfw == null) {
                return false;
            }
            if (cfw == this) {
                return true;
            }
            if (this.getAssembly() == cfw && this.getAssembly().getWidgetAssembler().getCurrentFocussedWidget() == this) {
                return true;
            }
        }
        return false;
    }

    public final boolean hasFocus() {
        return this.hasFocus(false);
    }

    protected boolean blocksFocusMoveDeviceComponent(DeviceComponent dc) {
        return false;
    }

    protected final void bindToGlobalMouseMovement() {
        __HUD_PrivilegedAccess.bindMouseMovement(this.getHUD(), this);
    }

    protected void onMouseEntered(boolean isTopMost, boolean hasFocus) {
        if (isTopMost) {
            this.hovered = true;
        }
        for (int i = 0; i < this.mouseListeners.size(); ++i) {
            this.mouseListeners.get(i).onMouseEntered(this, isTopMost, hasFocus);
        }
    }

    protected void onMouseExited(boolean isTopMost, boolean hasFocus) {
        if (isTopMost) {
            this.hovered = false;
        }
        for (int i = 0; i < this.mouseListeners.size(); ++i) {
            this.mouseListeners.get(i).onMouseExited(this, isTopMost, hasFocus);
        }
    }

    protected void startDragging(int canvasX, int canvasY, float widgetX, float widgetY) {
        this.dragStart = this.tmpDragStart;
        Tuple2f tmp = Tuple2f.fromPool();
        this.getAbsoluteLocationOnHUD_(tmp);
        this.dragStart.set(tmp.getX() + widgetX, tmp.getY() + widgetY);
        Tuple2f.toPool(tmp);
        this.tmpDragStartWidget.set(this.getLeft(), this.getTop());
        this.dragStartWidget = this.tmpDragStartWidget;
        this.bindToGlobalMouseMovement();
        for (int i = 0; i < this.locationListeners.size(); ++i) {
            this.locationListeners.get(i).onWidgetDragStarted(this);
        }
    }

    protected void onMouseButtonPressed(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
        for (int i = 0; i < this.mouseListeners.size(); ++i) {
            this.mouseListeners.get(i).onMouseButtonPressed(this, button, x, y, when, lastWhen, isTopMost, hasFocus);
        }
        if (this.isDraggable() && isTopMost) {
            Tuple2i tmp = Tuple2i.fromPool();
            this.getLocationHUD2Pixels_(x, y, tmp);
            int xpx = tmp.getX();
            int ypx = tmp.getY();
            Tuple2i.toPool(tmp);
            this.startDragging(xpx, ypx, x, y);
        }
    }

    protected void notifyOnDragStopped() {
        for (int i = 0; i < this.locationListeners.size(); ++i) {
            this.locationListeners.get(i).onWidgetDragStopped(this);
        }
    }

    protected void onMouseButtonReleased(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
        for (int i = 0; i < this.mouseListeners.size(); ++i) {
            this.mouseListeners.get(i).onMouseButtonReleased(this, button, x, y, when, lastWhen, isTopMost, hasFocus);
        }
        boolean wasDragging = this.dragStart != null;
        this.dragStart = null;
        this.dragStartWidget = null;
        if (wasDragging) {
            this.notifyOnDragStopped();
        }
    }

    protected void onMouseMoved(float x, float y, int buttonsState, long when, boolean isTopMost, boolean hasFocus) {
        for (int i = 0; i < this.mouseListeners.size(); ++i) {
            this.mouseListeners.get(i).onMouseMoved(this, x, y, buttonsState, when, isTopMost, hasFocus);
        }
        if (this.dragStart != null) {
            Tuple2f tmp = Tuple2f.fromPool();
            this.getAbsoluteLocationOnHUD_(tmp);
            float absX = tmp.getX() + x;
            float absY = tmp.getY() + y;
            Tuple2f.toPool(tmp);
            float widgetPosX = this.dragStartWidget.getX() + (absX - this.dragStart.getX());
            float widgetPosY = this.dragStartWidget.getY() + (absY - this.dragStart.getY());
            float parentResX = 0.0f;
            float parentResY = 0.0f;
            if (this.getContainer() != null) {
                parentResX = this.getContainer().getResX();
                parentResY = this.getContainer().getResY();
            } else if (this.getHUD() != null) {
                parentResX = this.getHUD().getResX();
                parentResY = this.getHUD().getResY();
            }
            widgetPosX = Math.max(widgetPosX, 0.0f - this.getWidth());
            widgetPosX = Math.min(widgetPosX, parentResX);
            widgetPosY = Math.max(widgetPosY, 0.0f);
            widgetPosY = Math.min(widgetPosY, parentResY);
            this.setLocation(widgetPosX, widgetPosY);
        }
    }

    protected void onMouseStopped(float x, float y, long when, boolean isTopMost, boolean hasFocus) {
        for (int i = 0; i < this.mouseListeners.size(); ++i) {
            this.mouseListeners.get(i).onMouseStopped(this, x, y, when, isTopMost, hasFocus);
        }
    }

    protected void onMouseWheelMoved(int delta, boolean isPageMove, float x, float y, long when, boolean isTopMost) {
        for (int i = 0; i < this.mouseListeners.size(); ++i) {
            this.mouseListeners.get(i).onMouseWheelMoved(this, delta, isPageMove, x, y, when, isTopMost);
        }
    }

    protected void onKeyPressed(Key key, int modifierMask, long when) {
        for (int i = 0; i < this.keyboardListeners.size(); ++i) {
            this.keyboardListeners.get(i).onKeyPressed(this, key, modifierMask, when);
        }
        if (this.getWidgetAssembler() != null) {
            this.getWidgetAssembler().onKeyPressed(key, modifierMask, when);
        }
    }

    protected void onKeyReleased(Key key, int modifierMask, long when) {
        for (int i = 0; i < this.keyboardListeners.size(); ++i) {
            this.keyboardListeners.get(i).onKeyReleased(this, key, modifierMask, when);
        }
        if (this.getWidgetAssembler() != null) {
            this.getWidgetAssembler().onKeyReleased(key, modifierMask, when);
        }
    }

    protected void onKeyTyped(char ch, int modifierMask, long when) {
        for (int i = 0; i < this.keyboardListeners.size(); ++i) {
            this.keyboardListeners.get(i).onKeyTyped(this, ch, modifierMask, when);
        }
        if (this.getWidgetAssembler() != null) {
            this.getWidgetAssembler().onKeyTyped(ch, modifierMask, when);
        }
    }

    protected void onControllerButtonPressed(ControllerButton button, long when) {
        for (int i = 0; i < this.controllerListeners.size(); ++i) {
            this.controllerListeners.get(i).onControllerButtonPressed(this, button, when);
        }
        if (this.getWidgetAssembler() != null) {
            this.getWidgetAssembler().onControllerButtonPressed(button, when);
        }
    }

    protected void onControllerButtonReleased(ControllerButton button, long when) {
        for (int i = 0; i < this.controllerListeners.size(); ++i) {
            this.controllerListeners.get(i).onControllerButtonReleased(this, button, when);
        }
        if (this.getWidgetAssembler() != null) {
            this.getWidgetAssembler().onControllerButtonReleased(button, when);
        }
    }

    protected void onControllerAxisChanged(ControllerAxis axis, int axisDelta, long when) {
        for (int i = 0; i < this.controllerListeners.size(); ++i) {
            this.controllerListeners.get(i).onControllerAxisChanged(this, axis, axisDelta, when);
        }
        if (this.getWidgetAssembler() != null) {
            this.getWidgetAssembler().onControllerAxisChanged(axis, axisDelta, when);
        }
    }

    protected void onInputStateChanged(DeviceComponent comp, int delta, int state, long when, boolean isTopMost, boolean hasFocus) {
        if (comp == null || comp.getType().isMouseComponent()) {
            for (int i = 0; i < this.mouseListeners.size(); ++i) {
                this.mouseListeners.get(i).onInputStateChanged(this, comp, delta, state, when, isTopMost, hasFocus);
            }
        } else if (comp.getType().isKeyboardComponent()) {
            for (int i = 0; i < this.keyboardListeners.size(); ++i) {
                this.keyboardListeners.get(i).onInputStateChanged(this, comp, delta, state, when, isTopMost, hasFocus);
            }
        } else if (comp.getType().isControllerComponent()) {
            for (int i = 0; i < this.controllerListeners.size(); ++i) {
                this.controllerListeners.get(i).onInputStateChanged(this, comp, delta, state, when, isTopMost, hasFocus);
            }
        }
        if (this.getWidgetAssembler() != null) {
            this.getWidgetAssembler().onInputStateChanged(comp, delta, state, when, isTopMost, hasFocus);
        }
    }

    protected final boolean isHovered() {
        return this.hovered;
    }

    protected void onVisibilityChanged(boolean visible) {
    }

    public final void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        this.isVisible = visible;
        if (this.getSGNode() != null) {
            this.getSGNode().setRenderable(visible);
        }
        this.onVisibilityChanged(visible);
        if (!this.isHeavyWeight()) {
            this.setTextureDirty();
        }
        for (int i = 0; i < this.visibilityListeners.size(); ++i) {
            this.visibilityListeners.get(i).onWidgetVisibilityChanged(this, visible);
        }
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    protected void setTransparency(float transparency, boolean childrenToo) {
        if (this.shape != null) {
            ShapeUtils.setShapesTransparency(this.shape, transparency, false, false);
        }
        if (this.getWidgetAssembler() != null) {
            this.getWidgetAssembler().setTransparency(transparency, childrenToo);
        }
        this.transparency = transparency;
        this.earlyTransparencyChildrenToo = childrenToo;
    }

    public final void setTransparency(float transparency) {
        this.setTransparency(transparency, true);
    }

    public final float getTransparency() {
        return this.transparency;
    }

    public void setClickable(boolean isClickable) {
        this.isClickable = isClickable;
    }

    public final boolean isClickable() {
        return this.isClickable;
    }

    public void setDraggable(boolean draggable) {
        this.isDraggable = draggable;
    }

    public final boolean isDraggable() {
        return this.isDraggable;
    }

    public void setPickable(boolean isPickable) {
        this.isPickable = isPickable;
    }

    public final boolean isPickable() {
        return this.isPickable;
    }

    public final void setCursor(Cursor.Type cursor) {
        this.cursorType = cursor;
    }

    public final Cursor.Type getCursor() {
        return this.cursorType;
    }

    final Cursor.Type getInheritedCursor() {
        if (this.cursorType != null) {
            return this.cursorType;
        }
        if (this.getContainer() != null) {
            return this.getContainer().getInheritedCursor();
        }
        if (this.getHUD() != null) {
            return Cursor.Type.POINTER1;
        }
        return null;
    }

    public void setBorder(Border border) {
        if (this.border == border) {
            return;
        }
        this.border = border;
        this.updateSizeFactors();
        this.setTextureDirty();
    }

    public final void setBorder(Border.Description borderDesc) {
        if (borderDesc == null) {
            this.setBorder((Border)null);
        } else {
            this.setBorder(BorderFactory.createBorder(borderDesc));
        }
    }

    public final Border getBorder() {
        return this.border;
    }

    protected int getContentLeftPX() {
        int result = 0;
        if (this instanceof PaddingSettable) {
            result += ((PaddingSettable)((Object)this)).getPaddingLeft();
        }
        if (this.getBorder() != null) {
            result += this.getBorder().getLeftWidth();
        }
        if (this.getWidgetAssembler() != null) {
            result += this.getWidgetAssembler().getAdditionalContentLeft();
        }
        return result;
    }

    protected int getContentTopPX() {
        int result = 0;
        if (this instanceof PaddingSettable) {
            result += ((PaddingSettable)((Object)this)).getPaddingTop();
        }
        if (this.getBorder() != null) {
            result += this.getBorder().getTopHeight();
        }
        if (this.getWidgetAssembler() != null) {
            result += this.getWidgetAssembler().getAdditionalContentTop();
        }
        return result;
    }

    protected final <Dim2f_ extends Dim2f> Dim2f_ getContentOffset(Dim2f_ buffer) {
        return this.getSizePixels2HUD_(this.getContentLeftPX(), this.getContentTopPX(), buffer);
    }

    protected int getContentWidthPX() {
        if (this.getHUD() == null) {
            throw new Error("This widget is not attached to the HUD.");
        }
        return this.contentWidthPX;
    }

    protected int getContentHeightPX() {
        if (this.getHUD() == null) {
            throw new Error("This widget is not attached to the HUD.");
        }
        return this.contentHeightPX;
    }

    public final float getContentWidth() {
        int nonContentWidthPX = 0;
        if (this.getBorder() != null) {
            nonContentWidthPX += this.getBorder().getLeftWidth() + this.getBorder().getRightWidth();
        }
        if (this instanceof PaddingSettable) {
            PaddingSettable ps = (PaddingSettable)((Object)this);
            nonContentWidthPX += ps.getPaddingLeft() + ps.getPaddingRight();
        }
        if (this.getWidgetAssembler() != null) {
            nonContentWidthPX -= this.getWidgetAssembler().getAdditionalContentWidth();
        }
        Dim2f buffer = Dim2f.fromPool();
        this.getSizePixels2HUD_(nonContentWidthPX, 0, buffer);
        float contentWidth = this.getWidth() - buffer.getWidth();
        Dim2f.toPool(buffer);
        return contentWidth;
    }

    public final float getContentHeight() {
        int nonContentHeightPX = 0;
        if (this.getBorder() != null) {
            nonContentHeightPX += this.getBorder().getTopHeight() + this.getBorder().getBottomHeight();
        }
        if (this instanceof PaddingSettable) {
            PaddingSettable ps = (PaddingSettable)((Object)this);
            nonContentHeightPX += ps.getPaddingTop() + ps.getPaddingBottom();
        }
        if (this.getWidgetAssembler() != null) {
            nonContentHeightPX -= this.getWidgetAssembler().getAdditionalContentHeight();
        }
        Dim2f buffer = Dim2f.fromPool();
        this.getSizePixels2HUD_(0, nonContentHeightPX, buffer);
        float contentHeight = this.getHeight() - buffer.getHeight();
        Dim2f.toPool(buffer);
        return contentHeight;
    }

    public final float getContentAspect() {
        return this.getContentWidth() / this.getContentHeight();
    }

    protected final int getLevel() {
        if (this.getContainer() == null) {
            return 0;
        }
        return this.getContainer().getLevel() + 1;
    }

    public void update() {
        this.setLocation(this.getLeft(), this.getTop(), true, true);
        this.setSize(this.getWidth(), this.getHeight(), true);
        if (this.getWidgetAssembler() != null) {
            this.getWidgetAssembler().update();
        }
    }

    protected void updateAbsZIndex() {
        this.zIndexComparable.update(this);
    }

    protected float calculateTransformWidth_Pixels2HUD(float contentWidth) {
        return 1.0f;
    }

    protected float calculateTransformHeight_Pixels2HUD(float contentHeight) {
        return 1.0f;
    }

    protected void updateSizeFactors() {
        if (this.getHUD() == null) {
            return;
        }
        int nonContentWidthPX = 0;
        int nonContentHeightPX = 0;
        if (this.getBorder() != null) {
            nonContentWidthPX += this.getBorder().getLeftWidth() + this.getBorder().getRightWidth();
            nonContentHeightPX += this.getBorder().getTopHeight() + this.getBorder().getBottomHeight();
        }
        if (this instanceof PaddingSettable) {
            PaddingSettable ps = (PaddingSettable)((Object)this);
            nonContentWidthPX += ps.getPaddingLeft() + ps.getPaddingRight();
            nonContentHeightPX += ps.getPaddingTop() + ps.getPaddingBottom();
        }
        if (this.getWidgetAssembler() != null) {
            nonContentWidthPX -= this.getWidgetAssembler().getAdditionalContentWidth();
            nonContentHeightPX -= this.getWidgetAssembler().getAdditionalContentHeight();
        }
        Dim2f buffer = Dim2f.fromPool();
        this.getSizePixels2HUD_(nonContentWidthPX, nonContentHeightPX, buffer);
        float contentWidth = this.getWidth() - buffer.getWidth();
        float contentHeight = this.getHeight() - buffer.getHeight();
        Dim2f.toPool(buffer);
        Dim2i buffer2 = Dim2i.fromPool();
        this.getSizeHUD2Pixels_(contentWidth, contentHeight, buffer2);
        this.contentWidthPX = buffer2.getWidth();
        this.contentHeightPX = buffer2.getHeight();
        this.getSizeHUD2Pixels_(this.getWidth(), this.getHeight(), buffer2);
        this.widthPX = buffer2.getWidth();
        this.heightPX = buffer2.getHeight();
        Dim2i.toPool(buffer2);
        this.transformWidth_Pixels2HUD = this.calculateTransformWidth_Pixels2HUD(contentWidth);
        this.transformHeight_Pixels2HUD = this.calculateTransformHeight_Pixels2HUD(contentHeight);
    }

    protected void updateTranslation() {
        if (this.getHUD() == null) {
            return;
        }
        this.updateAbsZIndex();
        if (this.transformGroup == null) {
            return;
        }
        Transform3D t3d = this.transformGroup.getTransform();
        Tuple2f loc2 = Tuple2f.fromPool();
        this.getLocationHUD2SG_(this.getLeft(), this.getTop(), loc2);
        t3d.setTranslation(loc2.getX(), loc2.getY(), 0.0f);
        Tuple2f.toPool(loc2);
        this.transformGroup.setTransform(t3d);
    }

    protected void onLocationChanged(float oldLeft, float oldTop, float newLeft, float newTop) {
    }

    protected final boolean setLocation(float locX, float locY, boolean forced, boolean needsTextureRefresh) {
        boolean result;
        float oldLeft = this.getLeft();
        float oldTop = this.getTop();
        boolean bl = result = oldLeft != locX || oldTop != locY;
        if (!result && !forced) {
            return false;
        }
        if (result || forced) {
            this.location.set(locX, locY);
            if (this.getHUD() != null) {
                this.updateTranslation();
            }
            if (this.getWidgetAssembler() != null) {
                this.getWidgetAssembler().onOwnerMoved(locX - oldLeft, locY - oldTop, needsTextureRefresh);
            }
        }
        if (result) {
            if (!this.isHeavyWeight() && needsTextureRefresh) {
                this.setTextureDirty();
                Widget rootHost = this.getRootHostWidget();
                if (rootHost != null) {
                    rootHost.setWidgetDirty();
                }
            }
            this.onLocationChanged(oldLeft, oldTop, locX, locY);
            for (int i = 0; i < this.locationListeners.size(); ++i) {
                this.locationListeners.get(i).onWidgetLocationChanged(this, oldLeft, oldTop, locX, locY);
            }
            if (this.getContainer() != null) {
                this.getContainer().onChildMovedOrResized(this);
            }
        }
        return result;
    }

    @Override
    public final Widget setLocation(float locX, float locY) {
        this.setLocation(locX, locY, false, true);
        return this;
    }

    @Override
    public final Widget setLocation(Tuple2f loc) {
        return this.setLocation(loc.getX(), loc.getY());
    }

    @Override
    public final Tuple2f getLocation() {
        return this.location.getReadOnly();
    }

    public <Tuple2f_ extends Tuple2f> Tuple2f_ getLocation(Tuple2f_ loc) {
        this.location.get(loc);
        return loc;
    }

    @Override
    public final float getLeft() {
        return this.location.getX();
    }

    @Override
    public final float getTop() {
        return this.location.getY();
    }

    protected float getMinWidth() {
        return -1.0f;
    }

    protected float getMinHeight() {
        return -1.0f;
    }

    protected void onSizeChanged(float oldWidth, float oldHeight, float newWidth, float newHeight) {
        this.updateSizeFactors();
    }

    protected final boolean setSize(float width, float height, boolean forced) {
        boolean result;
        float oldWidth = this.getWidth();
        float oldHeight = this.getHeight();
        width = Math.max(this.getMinWidth(), width);
        height = Math.max(this.getMinHeight(), height);
        boolean bl = result = oldWidth != width || oldHeight != height;
        if (!result && !forced) {
            return false;
        }
        if (result || forced) {
            this.size.set(width, height);
            if (this.shape != null && this.getHUD() != null) {
                float shapeWidth = width;
                float shapeHeight = height;
                Dim2f s = Dim2f.fromPool();
                DropShadowFactory dsf = this.getHUD().getDropShadowFactory();
                if (dsf != null && this.hasDropShadow()) {
                    this.getSizePixels2HUD_(dsf.getDropShadowWidth(), dsf.getDropShadowHeight(), s);
                    shapeWidth += s.getWidth();
                    shapeHeight += s.getHeight();
                }
                this.getSizeHUD2SG_(shapeWidth, shapeHeight, s);
                this.shape.resize(s.getWidth(), s.getHeight());
                Dim2f.toPool(s);
            }
            this.setTextureDirty();
            if (this.getContainer() != null) {
                this.getContainer().setTextureDirty();
            }
            this.onSizeChanged(oldWidth, oldHeight, width, height);
            for (int i = 0; i < this.sizeListeners.size(); ++i) {
                this.sizeListeners.get(i).onWidgetSizeChanged(this, oldWidth, oldHeight, width, height);
            }
            if (this.getContainer() != null) {
                this.getContainer().onChildMovedOrResized(this);
            }
        }
        return result;
    }

    @Override
    public final Widget setSize(float width, float height) {
        this.setSize(width, height, false);
        return this;
    }

    @Override
    public final Widget setSize(Sized2fRO size) {
        return this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public final Widget setSize(Tuple2f size) {
        return this.setSize(size.getX(), size.getY());
    }

    @Override
    public final void setWidth(float width) {
        this.setSize(width, this.getHeight());
    }

    @Override
    public final void setHeight(float height) {
        this.setSize(this.getWidth(), height);
    }

    @Override
    public final float getWidth() {
        return this.size.getWidth();
    }

    protected final int getWidthPX() {
        if (this.getHUD() == null) {
            throw new Error("This widget is not attached to the HUD.");
        }
        return this.widthPX;
    }

    @Override
    public final float getHeight() {
        return this.size.getHeight();
    }

    protected final int getHeightPX() {
        if (this.getHUD() == null) {
            throw new Error("This widget is not attached to the HUD.");
        }
        return this.heightPX;
    }

    public final Sized2fRO getSize() {
        return new Dim2f(this.size);
    }

    @Override
    public final float getAspect() {
        if (this.size.getHeight() == 0.0f) {
            return 0.0f;
        }
        return this.size.getWidth() / this.size.getHeight();
    }

    public void setZIndex(int zIndex) {
        if (zIndex == this.zIndex) {
            return;
        }
        this.zIndex = zIndex;
        if (this.getContainer() != null) {
            this.getContainer().setZIndexSortingDirty();
            if (!this.isHeavyWeight()) {
                this.getContainer().setTextureDirty();
            }
        }
        this.updateTranslation();
    }

    public final int getZIndex() {
        return this.zIndex;
    }

    public final int compareAbsZIndex(Widget widget2) {
        return this.zIndexComparable.compareTo(widget2.zIndexComparable);
    }

    protected float getPickWidth() {
        return this.getWidth();
    }

    protected float getPickHeight() {
        return this.getHeight();
    }

    protected boolean pickConditionsMatch(HUDPickResult.HUDPickReason pickReason) {
        if (this.getHUD() == null) {
            return false;
        }
        if (!this.isPickable() || !this.isVisible()) {
            return false;
        }
        return pickReason != HUDPickResult.HUDPickReason.BUTTON_PRESSED && pickReason != HUDPickResult.HUDPickReason.BUTTON_RELEASED || this.isClickable();
    }

    private boolean pickWidgetAssembler(int canvasX, int canvasY, float widgetX, float widgetY, HUDPickResult.HUDPickReason pickReason, MouseButton button, long when, long meta, int flags) {
        if (this.getWidgetAssembler() == null || !this.getWidgetAssembler().isPickingDispatched()) {
            return false;
        }
        return this.getWidgetAssembler().pick(canvasX, canvasY, widgetX, widgetY, pickReason, button, when, meta, flags);
    }

    protected HUDPickResult pick(int canvasX, int canvasY, HUDPickResult.HUDPickReason pickReason, MouseButton button, long when, long meta, int flags) {
        if (!this.pickConditionsMatch(pickReason)) {
            return null;
        }
        Tuple2f locP = Tuple2f.fromPool();
        this.getLocationPixels2HUD_(canvasX, canvasY, locP);
        float pickXHUD = locP.getX();
        float pickYHUD = locP.getY();
        Tuple2f.toPool(locP);
        if (0.0f > pickXHUD || pickXHUD > this.getPickWidth() || 0.0f > pickYHUD || pickYHUD > this.getPickHeight()) {
            return null;
        }
        HUDPickResult hpr = HUDPickResult.fromPool();
        hpr.set(this, this.getCursor(), pickXHUD + this.getLeft(), pickYHUD + this.getTop(), pickXHUD, pickYHUD, pickReason, button);
        if ((flags & 1) != 0) {
            this.pickWidgetAssembler(canvasX, canvasY, pickXHUD, pickYHUD, pickReason, button, when, meta, flags);
        }
        return hpr;
    }

    protected final boolean isInitializing() {
        return this.isInitializing;
    }

    protected final boolean isInitialized() {
        return this.isInitialized;
    }

    protected void initSize() {
    }

    protected void createShape() {
        if (!this.isHeavyWeight) {
            return;
        }
        Dim2f size2 = Dim2f.fromPool();
        float shapeWidth = this.getWidth();
        float shapeHeight = this.getHeight();
        DropShadowFactory dsf = this.getHUD().getDropShadowFactory();
        if (dsf != null && this.hasDropShadow()) {
            this.getSizePixels2HUD_(dsf.getDropShadowWidth(), dsf.getDropShadowHeight(), size2);
            shapeWidth += size2.getWidth();
            shapeHeight += size2.getHeight();
        }
        this.getSizeHUD2SG_(shapeWidth, shapeHeight, size2);
        Node.pushGlobalIgnoreBounds(true);
        this.shape = new DrawRectangle(size2.getWidth(), size2.getHeight(), false, true, true);
        Node.popGlobalIgnoreBounds();
        this.shape.getAppearance().setRenderingAttributes(RENDERING_ATTRIBUTES);
        this.shape.setCustomComparable(this.zIndexComparable);
        this.shape.getGeometry().setOptimization(Geometry.Optimization.USE_VBOS);
        this.transformGroup.addChild(this.shape);
        Dim2f.toPool(size2);
        this.shape.getTextureCanvas().addDrawCallback(this.drawCallback);
        if (this.transparency > 0.0f) {
            this.setTransparency(this.transparency, this.earlyTransparencyChildrenToo);
        }
    }

    protected abstract void init();

    boolean checkHiearchyIntegrity() {
        if (this.hierarchyOK == Boolean.TRUE) {
            return true;
        }
        if (this.isHeavyWeight()) {
            this.hierarchyOK = Boolean.TRUE;
            return true;
        }
        this.hierarchyOK = this.getContainer() == null ? Boolean.valueOf(this.getAssembly() != null) : Boolean.valueOf(this.getContainer().checkHiearchyIntegrity());
        if (!this.hierarchyOK.booleanValue()) {
            throw new Error("The hiearchy of a Widget is not ok. Any lightweight Widget must be in a hierarchy, where a (grand-)parent Widget is heavyweight. Check the HUD's ContentPane for being heavyweight.");
        }
        return true;
    }

    protected void onAttachedToHUD(HUD hud) {
        this.checkHiearchyIntegrity();
        this.updateSizeFactors();
        this.updateTranslation();
        if (!this.isInitialized()) {
            this.isInitializing = true;
            this.initSize();
            this.createShape();
            this.init();
            this.isInitializing = false;
            if (this.getWidgetAssembler() != null) {
                this.getWidgetAssembler().update();
            }
            this.isInitialized = true;
        }
        this.setSize(this.getWidth(), this.getHeight(), true);
        if (this.focusRequested) {
            this.container.focus(this);
            this.focusRequested = false;
        }
        for (int i = 0; i < this.containerListeners.size(); ++i) {
            this.containerListeners.get(i).onWidgetAttachedToHUD(this, hud);
        }
    }

    protected void onDetachedFromHUD(HUD hud) {
        this.hierarchyOK = null;
        for (int i = 0; i < this.containerListeners.size(); ++i) {
            this.containerListeners.get(i).onWidgetDetachedFromHUD(this, hud);
        }
    }

    void setHUD(HUD hud) {
        if (this.hud == hud) {
            return;
        }
        HUD oldHUD = this.hud;
        this.hud = hud;
        if (this.getWidgetAssembler() != null) {
            this.getWidgetAssembler().setHUD(hud);
        }
        if (hud != null) {
            this.onAttachedToHUD(hud);
        } else {
            this.onDetachedFromHUD(oldHUD);
        }
    }

    public final HUD getHUD() {
        return this.hud;
    }

    protected void onAttachedToContainer(WidgetContainer container) {
        if (container.getSGGroup() != null && this.getSGNode() != null) {
            container.getSGGroup().addChild(this.getSGNode());
        }
        container.notifyContainerListenersAboutAttachedWidget(this, container);
        this.notifyContainerListenersAboutAttachedWidget(this, container);
    }

    protected void onDetachedFromContainer(WidgetContainer container) {
        if (container.getSGGroup() != null && this.getSGNode() != null) {
            container.getSGGroup().removeChild(this.getSGNode());
        }
        container.notifyContainerListenersAboutDetachedWidget(this, container);
        this.notifyContainerListenersAboutDetachedWidget(this, container);
    }

    final void setContainer(WidgetContainer container, Widget assembly) {
        boolean assemblyChanged;
        boolean containerChanged = this.container != container;
        boolean bl = assemblyChanged = this.assembly != assembly;
        if (!containerChanged && !assemblyChanged) {
            return;
        }
        WidgetContainer oldContainer = this.container;
        this.container = container;
        this.assembly = assembly;
        if (containerChanged) {
            if (this.getWidgetAssembler() != null) {
                this.getWidgetAssembler().setContainer(container);
            }
            if (container != null) {
                this.onAttachedToContainer(container);
            } else {
                this.onDetachedFromContainer(oldContainer);
            }
        }
    }

    public final WidgetContainer getContainer() {
        return this.container;
    }

    protected final Widget getAssembly() {
        return this.assembly;
    }

    public void detach() {
        if (this.getAssembly() != null) {
            this.getAssembly().getWidgetAssembler().removeWidget(this);
        } else if (this.getContainer() != null) {
            this.getContainer().removeWidget(this);
        }
    }

    public String toString() {
        if (this instanceof TextWidget) {
            String text = String.valueOf(((TextWidget)((Object)this)).getText()).replaceAll("\n", "\\\\n");
            if (this.getName() != null && this.getName().length() > 0) {
                return this.getClass().getSimpleName() + "( \"" + this.getName() + "\", " + text + "\" )";
            }
            return this.getClass().getSimpleName() + "( \"" + text + "\" )";
        }
        if (this.getName() != null && this.getName().length() > 0) {
            return this.getClass().getSimpleName() + "( \"" + this.getName() + "\" )";
        }
        return super.toString();
    }

    public Shape3D getShape() {
        return this.shape;
    }

    protected void setHostWidget(Widget widget) {
        this.hostWidget = widget;
    }

    protected final Widget getRootHostWidget() {
        if (this.hostWidget == null) {
            if (this.isHeavyWeight()) {
                return this;
            }
            return null;
        }
        return this.hostWidget.getRootHostWidget();
    }

    final void setPassive(boolean passive) {
        this.isPassive = passive;
        if (this.getWidgetAssembler() != null) {
            this.getWidgetAssembler().setWidgetsPassive(passive);
        }
    }

    protected void setHostedWidgetDirty() {
        this.isAHostedWidgetDirty = true;
    }

    protected void setWidgetDirty() {
        this.isThisWidgetDirty = true;
        if (this.getWidgetAssembler() != null) {
            this.getWidgetAssembler().setWidgetsDirty();
        }
    }

    protected void resetWidgetDirty() {
        this.isThisWidgetDirty = false;
        this.isAHostedWidgetDirty = false;
    }

    protected final boolean isThisWidgetDirty() {
        return this.isThisWidgetDirty;
    }

    protected final boolean isAHostedWidgetDirty() {
        return this.isAHostedWidgetDirty;
    }

    protected void setHostTextureDirty(int flags) {
        if (this.isPassive) {
            return;
        }
        this.setHostedWidgetDirty();
        if (this.isHeavyWeight()) {
            this.drawCallback.setDirty(true);
            return;
        }
        Widget hostWidget = this.hostWidget;
        if (hostWidget != null) {
            hostWidget.setHostTextureDirty(flags);
            return;
        }
    }

    protected final void setHostTextureDirty() {
        this.setHostTextureDirty(0);
    }

    protected void setTextureDirty(int flags) {
        if (this.isPassive) {
            return;
        }
        if (this.getAssembly() != null) {
            this.getAssembly().setTextureDirty(flags);
            return;
        }
        this.setWidgetDirty();
        if (this.isHeavyWeight()) {
            this.drawCallback.setDirty(true);
            return;
        }
        Widget hostWidget = this.hostWidget;
        if (hostWidget != null) {
            hostWidget.setHostTextureDirty(flags);
            return;
        }
    }

    protected final void setTextureDirty() {
        this.setTextureDirty(0);
    }

    protected void drawBackground(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
        if (this.isHeavyWeight()) {
            DrawUtils.clearImage(Colorf.BLACK_TRANSPARENT, null, null, texCanvas, offsetX, offsetY, width, height);
        } else if (this.getContainer() != null && !this.getContainer().isThisWidgetDirty() && this.getAssembly() == null) {
            DropShadowFactory dsf = this.getHUD().getDropShadowFactory();
            if (dsf == null || !this.hasDropShadow()) {
                this.getContainer().drawParentBackground(this, texCanvas, offsetX, offsetY, width, height);
            } else {
                this.getContainer().drawParentBackground(this, texCanvas, offsetX, offsetY, width + dsf.getDropShadowWidth(), height + dsf.getDropShadowHeight());
            }
        }
    }

    protected abstract void drawWidget(Texture2DCanvas var1, int var2, int var3, int var4, int var5, boolean var6);

    protected void drawWidgetAfterWidgetAssembler(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
    }

    protected void drawBorder(Border border, Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
        border.drawBorder(texCanvas, offsetX, offsetY, width, height, this);
    }

    protected void setContentClipRect(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
        texCanvas.setClip(offsetX, offsetY, width, height);
    }

    protected void drawWidgetContents(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        int contentLeft = offsetX + this.getContentLeftPX();
        int contentTop = offsetY + this.getContentTopPX();
        int contentWidth = this.getContentWidthPX();
        int contentHeight = this.getContentHeightPX();
        this.clip.set(contentLeft, contentTop, contentWidth, contentHeight);
        this.clip.clamp(this.oldClip);
        this.setContentClipRect(texCanvas, this.clip.getLeft(), this.clip.getTop(), this.clip.getWidth(), this.clip.getHeight());
        this.drawWidget(texCanvas, contentLeft, contentTop, contentWidth, contentHeight, drawsSelf);
        if (this.getWidgetAssembler() != null) {
            this.clip.set(offsetX, offsetY, width, height);
            this.clip.clamp(this.oldClip);
            texCanvas.setClip(this.clip);
            this.getWidgetAssembler().draw(texCanvas, offsetX, offsetY);
            this.clip.set(contentLeft, contentTop, contentWidth, contentHeight);
            this.clip.clamp(this.oldClip);
            this.setContentClipRect(texCanvas, this.clip.getLeft(), this.clip.getTop(), this.clip.getWidth(), this.clip.getHeight());
        }
        this.drawWidgetAfterWidgetAssembler(texCanvas, contentLeft, contentTop, contentWidth, contentHeight, drawsSelf);
    }

    public void drawAndUpdateWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        if (this.isThisWidgetDirty || this.isPassive) {
            texCanvas.getClip(this.oldClip);
            DropShadowFactory dsf = this.getHUD().getDropShadowFactory();
            if (dsf == null || !this.hasDropShadow()) {
                this.clip.set(offsetX, offsetY, width, height);
                this.clip.clamp(this.oldClip);
                texCanvas.setClip(this.clip);
                texCanvas.beginUpdateRegion(offsetX, offsetY, width, height);
            } else {
                this.clip.set(offsetX, offsetY, width + dsf.getDropShadowWidth(), height + dsf.getDropShadowHeight());
                this.clip.clamp(this.oldClip);
                texCanvas.setClip(this.clip);
                texCanvas.beginUpdateRegion(offsetX, offsetY, width + dsf.getDropShadowWidth(), height + dsf.getDropShadowHeight());
                dsf.drawDropShadow(offsetX + width, offsetY + height, width, height, this.getZIndex(), texCanvas);
                this.clip.set(offsetX, offsetY, width, height);
                this.clip.clamp(this.oldClip);
                texCanvas.setClip(this.clip);
            }
            this.drawBackground(texCanvas, offsetX, offsetY, width, height);
            this.drawWidgetContents(texCanvas, offsetX, offsetY, width, height, drawsSelf);
            if (this.getBorder() != null) {
                this.clip.set(offsetX, offsetY, width, height);
                this.clip.clamp(this.oldClip);
                texCanvas.setClip(this.clip);
                this.drawBorder(this.getBorder(), texCanvas, offsetX, offsetY, width, height);
            }
            texCanvas.finishUpdateRegion();
            texCanvas.setClip(this.oldClip);
        } else if (this.isAHostedWidgetDirty) {
            this.drawWidgetContents(texCanvas, offsetX, offsetY, width, height, drawsSelf);
        }
        this.resetWidgetDirty();
    }

    public static final void setMaxRedrawFrequency(float freq) {
        MIN_UPDATE_DELAY.setValue((long)(1.0E9f / freq));
    }

    public static final float getMaxRedrawFrequency() {
        return 1.0E9f / MIN_UPDATE_DELAY.floatValue();
    }

    public void setForcedRedrawFrequency(float freq) {
        if (!this.isHeavyWeight()) {
            throw new Error("A lightweight Widget cannot be forced redrawn.");
        }
        if (freq <= 0.0f) {
            this.forcedUpdateDelay = -1L;
            return;
        }
        this.forcedUpdateDelay = (long)(1.0E9f / freq);
    }

    public final float getForcedRedrawFrequency() {
        if (this.forcedUpdateDelay <= 0L) {
            return -1.0f;
        }
        return 1.0E9f / (float)this.forcedUpdateDelay;
    }

    protected Widget(boolean isHeavyWeight, boolean hasWidgetAssembler) {
        this.isHeavyWeight = isHeavyWeight;
        Node.pushGlobalIgnoreBounds(true);
        this.transformGroup = new TransformGroup();
        Node.popGlobalIgnoreBounds();
        this.widgetAssembler = hasWidgetAssembler ? new WidgetAssembler(this) : null;
        this.drawCallback = isHeavyWeight ? new Texture2DCanvas.DrawCallback2D(){
            private boolean dirty = true;
            private long nextAllowedRedrawTime = -1L;
            private long nextForcedRedrawTime = -1L;

            public void setDirty(boolean dirty) {
                this.dirty = dirty;
            }

            public boolean needsRedraw(long nanoTime) {
                if (this.dirty) {
                    if (nanoTime < this.nextAllowedRedrawTime) {
                        return false;
                    }
                    this.nextAllowedRedrawTime += MIN_UPDATE_DELAY.longValue();
                } else if (Widget.this.forcedUpdateDelay > 0L && nanoTime >= this.nextForcedRedrawTime) {
                    this.nextForcedRedrawTime += Widget.this.forcedUpdateDelay;
                    Widget.this.setWidgetDirty();
                    return true;
                }
                boolean result = this.dirty;
                this.dirty = false;
                return result;
            }

            public void drawTexture(Texture2DCanvas texCanvas, int texWidth, int texHeight) {
                texCanvas.setClip(0, 0, texWidth, texHeight);
                DropShadowFactory dsf = Widget.this.getHUD().getDropShadowFactory();
                if (dsf != null && Widget.this.hasDropShadow()) {
                    texWidth -= dsf.getDropShadowWidth();
                    texHeight -= dsf.getDropShadowHeight();
                }
                Widget.this.drawAndUpdateWidget(texCanvas, 0, 0, texWidth, texHeight, true);
            }
        } : null;
    }

    protected Widget(boolean isHeavyWeight, boolean hasWidgetAssembler, float width, float height) {
        this(isHeavyWeight, hasWidgetAssembler);
        this.size.set(Math.max(this.getMinWidth(), width), Math.max(this.getMinHeight(), height));
    }

    static {
        RENDERING_ATTRIBUTES.setDepthTestFunction(TestFunction.ALWAYS);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ZIndexComparable
    implements Comparable<Object> {
        private int[] zIndices = new int[1];

        private ZIndexComparable() {
        }

        public final void update(Widget widget) {
            int level = widget.getLevel();
            if (this.zIndices.length != level + 1) {
                this.zIndices = new int[level + 1];
            }
            while (widget != null) {
                this.zIndices[level--] = widget.getZIndex();
                widget = widget.getContainer();
            }
        }

        @Override
        public int compareTo(Object o2) {
            if (!(o2 instanceof ZIndexComparable)) {
                return 1;
            }
            ZIndexComparable that = (ZIndexComparable)o2;
            int n = Math.min(this.zIndices.length, that.zIndices.length);
            for (int i = 0; i < n; ++i) {
                if (this.zIndices[i] < that.zIndices[i]) {
                    return -1;
                }
                if (this.zIndices[i] <= that.zIndices[i]) continue;
                return 1;
            }
            if (this.zIndices.length < that.zIndices.length) {
                return -1;
            }
            if (this.zIndices.length > that.zIndices.length) {
                return 1;
            }
            return 0;
        }
    }

    protected static abstract class DescriptionBase {
        protected DescriptionBase() {
        }

        public String toString() {
            String s = this.getClass().getName() + "\n{\n";
            Method[] methods = this.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                String value;
                String name = methods[i].getName();
                if (name.startsWith("get")) {
                    name = name.substring(3);
                } else {
                    if (!name.startsWith("is")) continue;
                    name = name.substring(2);
                }
                try {
                    Object valueObj = methods[i].invoke((Object)this, (Object[])null);
                    value = valueObj == null ? null : valueObj.toString();
                }
                catch (Throwable t) {
                    value = "[N/A]";
                }
                s = s + "    " + name + " = " + value + "\n";
            }
            s = s + "}";
            return s;
        }
    }
}

