/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.base;

import org.jagatoo.input.devices.components.MouseButton;
import org.openmali.types.twodee.Dim2f;
import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.utils.HUDPickResult;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;

public class WindowHeaderWidget
extends Label {
    public static final int FLAG_ONLY_WINDOW_HEADER_WIDGET = 1;
    private Description desc;
    private AbstractButton closeButton;

    public final AbstractButton getCloseButton() {
        return this.closeButton;
    }

    public final boolean isMouseOverBar(float relX, float relY) {
        if (relY > this.getHeight()) {
            return false;
        }
        Widget test = this.getWidgetAssembler().pick(relX, relY);
        return test == null;
    }

    protected HUDPickResult pick(int canvasX, int canvasY, HUDPickResult.HUDPickReason pickReason, MouseButton button, long when, long meta, int flags) {
        return super.pick(canvasX, canvasY, pickReason, button, when, meta, flags &= 0xFFFFFFFD);
    }

    protected void onSizeChanged(float oldWidth, float oldHeight, float newWidth, float newHeight) {
        super.onSizeChanged(oldWidth, oldHeight, newWidth, newHeight);
        if (this.closeButton != null && this.getWidgetAssembler().contains(this.closeButton)) {
            Dim2f threePixels = Dim2f.fromPool();
            this.getSizeOfPixels_(3, 3, threePixels);
            this.getWidgetAssembler().reposition(this.closeButton, this.getWidth() - threePixels.getWidth() - this.closeButton.getWidth(), (this.getHeight() - this.closeButton.getHeight()) / 2.0f);
            Dim2f.toPool(threePixels);
        }
    }

    protected void setHostTextureDirty(int flags) {
        super.setHostTextureDirty(flags | 1);
    }

    protected void setTextureDirty(int flags) {
        super.setTextureDirty(flags | 1);
    }

    protected void init() {
        Dim2f size2 = Dim2f.fromPool();
        if (this.closeButton != null) {
            int wpx = HUDTextureUtils.getTextureWidth(this.desc.closeButtonDesc.getTextureNormal());
            int hpx = HUDTextureUtils.getTextureHeight(this.desc.closeButtonDesc.getTextureNormal());
            this.getSizePixels2HUD_(wpx, hpx, size2);
            this.closeButton.setSize(size2);
            this.getWidgetAssembler().addWidget(this.closeButton);
        }
        this.getSizePixels2HUD_(0, HUDTextureUtils.getTextureHeight(this.getBackgroundTexture()), size2);
        this.setSize(this.getWidth(), size2.getHeight(), true);
        Dim2f.toPool(size2);
        this.getWidgetAssembler().setPickDispatched(true);
    }

    protected AbstractButton createCloseButton(Description desc) {
        Texture2D texNormal = desc.getCloseButtonDescription().getTextureNormal();
        Texture2D texHovered = desc.getCloseButtonDescription().getTextureHovered();
        Texture2D texPressed = desc.getCloseButtonDescription().getTexturePressed();
        Button btn = new Button(false, (float)HUDTextureUtils.getTextureWidth(texNormal), (float)HUDTextureUtils.getTextureHeight(texNormal), texNormal, texHovered, texPressed);
        return btn;
    }

    public WindowHeaderWidget(float width, String title, Description desc) {
        super(false, true, width, HUDTextureUtils.getTextureHeight(desc.getBackgroundTexture()), title, desc);
        this.desc = desc;
        this.closeButton = this.createCloseButton(desc);
    }

    public WindowHeaderWidget(float width, String title) {
        this(width, title, HUD.getTheme().getWindowHeaderDescription());
    }

    public static class Description
    extends Label.Description {
        private Button.Description closeButtonDesc;

        public void setCloseButtonDescription(Button.Description desc) {
            this.closeButtonDesc = desc;
        }

        public final Button.Description getCloseButtonDescription() {
            return this.closeButtonDesc;
        }

        public void set(Description desc) {
            super.set(desc);
            this.closeButtonDesc = desc.closeButtonDesc == null ? null : desc.closeButtonDesc.clone();
        }

        public Description clone() {
            return new Description(this);
        }

        public Description(Description desc) {
            super(desc);
            this.set(desc);
        }

        public Description(Texture2D backgroundTexture, HUDFont font, Colorf color, TextAlignment alignment, Button.Description closeButtonDesc) {
            super(null, backgroundTexture, font, null, color, null, alignment);
            this.closeButtonDesc = closeButtonDesc;
        }

        public Description(String backgroundTexture, HUDFont font, Colorf color, TextAlignment alignment, Button.Description closeButtonDesc) {
            this(HUDTextureUtils.getTexture(backgroundTexture, true), font, color, alignment, closeButtonDesc);
        }
    }
}

