/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.dialogs;

import java.util.ArrayList;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.base.TextWidget;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.base.Window;
import org.xith3d.ui.hud.base.WindowHeaderWidget;
import org.xith3d.ui.hud.base.__HUD_base_PrivilegedAccess;
import org.xith3d.ui.hud.borders.EmptyBorder;
import org.xith3d.ui.hud.layout.HullLayout;
import org.xith3d.ui.hud.layout.ListLayout;
import org.xith3d.ui.hud.listeners.ButtonListener;
import org.xith3d.ui.hud.listeners.DialogListener;
import org.xith3d.ui.hud.listeners.WindowAdapter;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.ui.hud.widgets.Dialog;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;

public class MsgBox
extends Dialog {
    private static Factory factory = new DefaultFactory();
    private static final ArrayList<MsgBox> cache = new ArrayList();
    private CacheManager cacheManager = new CacheManager();
    private TextWidget messageWidget = null;
    private Button btnOK = null;

    public static void setFactory(Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null.");
        }
        MsgBox.factory = factory;
    }

    public static final Factory getFactory() {
        return factory;
    }

    public void setMessageWidget(TextWidget widget) {
        this.messageWidget = widget;
    }

    public final TextWidget getMessageWidget() {
        return this.messageWidget;
    }

    public void setOKButton(Button button) {
        this.btnOK = button;
    }

    public final Button getOKButton() {
        return this.btnOK;
    }

    private void setIcon(IconType iconType) {
    }

    private void setMessage(String text) {
        this.getMessageWidget().setText(text);
    }

    private MsgBox() {
        super(300.0f, 150.0f, "");
        this.getContentPane().setClippingEnabled(false);
        this.getContentPane().setBorder(new EmptyBorder(15, 15, 10, 15));
        ListLayout listLayout = new ListLayout(ListLayout.Orientation.VERTICAL, 15.0f);
        listLayout.setOtherSpanCalculated(false);
        HullLayout hullLayout = new HullLayout(listLayout);
        this.getContentPane().setLayout(hullLayout);
        this.addWindowListener(this.cacheManager);
        factory.create(this);
        if (this.getMessageWidget() == null) {
            throw new Error("The currently used Factory doesn't set the message-widget.");
        }
        if (this.getOKButton() == null) {
            throw new Error("The currently used Factory doesn't set the OK-Button.");
        }
        this.setCloseCommand(this.getOKButton().getUserObject());
        this.getOKButton().addButtonListener(new ButtonListener(){

            public void onButtonClicked(AbstractButton button, Object userObject) {
                MsgBox.this.detach();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final MsgBox show(String title, String text, IconType iconType, HUD hud, DialogListener listener) {
        WindowHeaderWidget whw;
        MsgBox msgbox;
        ArrayList<MsgBox> arrayList = cache;
        synchronized (arrayList) {
            msgbox = cache.size() > 0 ? cache.remove(cache.size() - 1) : new MsgBox();
        }
        msgbox.removeAllDialogListeners();
        if (listener != null) {
            msgbox.addDialogListener(listener);
        }
        if ((whw = msgbox.getHeaderWidget()) != null) {
            msgbox.getHeaderWidget().setText(title);
        }
        msgbox.setIcon(iconType);
        msgbox.setMessage(text);
        __HUD_base_PrivilegedAccess.setTextureDirty(msgbox);
        hud.addWindowCentered(msgbox);
        return msgbox;
    }

    public static final MsgBox show(String text, IconType iconType, HUD hud, DialogListener listener) {
        return MsgBox.show("Message", text, iconType, hud, listener);
    }

    public static final MsgBox show(String text, HUD hud, DialogListener listener) {
        return MsgBox.show(text, null, hud, listener);
    }

    public static final MsgBox show(String title, String text, IconType iconType, HUD hud) {
        return MsgBox.show(title, text, iconType, hud, null);
    }

    public static final MsgBox show(String text, IconType iconType, HUD hud) {
        return MsgBox.show("Message", text, iconType, hud);
    }

    public static final MsgBox show(String text, HUD hud) {
        return MsgBox.show(text, null, hud);
    }

    private static class CacheManager
    extends WindowAdapter {
        private CacheManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowClosed(Window window) {
            ArrayList arrayList = cache;
            synchronized (arrayList) {
                cache.add((MsgBox)window);
            }
        }
    }

    private static class DefaultFactory
    implements Factory {
        private DefaultFactory() {
        }

        public Texture2D getIconTexture(IconType iconType) {
            return null;
        }

        protected String getOKText() {
            return "OK";
        }

        public void create(MsgBox msgbox) {
            WidgetContainer pane = msgbox.getContentPane();
            Label msgLabel = new Label(-1.0f, -1.0f, "", TextAlignment.TOP_LEFT);
            pane.addWidget(msgLabel);
            msgbox.setMessageWidget(msgLabel);
            Button btnOK = new Button(100.0f, 24.0f, this.getOKText());
            btnOK.setUserObject("OK");
            pane.addWidget(btnOK);
            msgbox.setOKButton(btnOK);
        }
    }

    public static interface Factory {
        public Texture2D getIconTexture(IconType var1);

        public void create(MsgBox var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IconType {
        STANDARD,
        QUESTION,
        EXCEPTION,
        ERROR;

    }
}

