/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.layout;

import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.layout.BorderSettableLayoutManagerBase;

public class BorderLayout
extends BorderSettableLayoutManagerBase {
    private Widget northWidget = null;
    private Widget southWidget = null;
    private Widget westWidget = null;
    private Widget eastWidget = null;
    private Widget centerWidget = null;
    private float hgap;
    private float vgap;

    public void setHGap(float hgap) {
        this.hgap = hgap;
    }

    public final float getHGap() {
        return this.hgap;
    }

    public void setVGap(float vgap) {
        this.vgap = vgap;
    }

    public final float getVGap() {
        return this.vgap;
    }

    public void addWidget(Widget widget, Object constraints) {
        super.addWidget(widget, constraints);
        if (constraints != null && !(constraints instanceof Area)) {
            throw new IllegalArgumentException("constraints must either be null of of type BorderLayout.Area");
        }
        if (constraints == null || constraints == Area.CENTER) {
            this.centerWidget = widget;
        } else {
            switch ((Area)((Object)constraints)) {
                case NORTH: {
                    this.northWidget = widget;
                    break;
                }
                case SOUTH: {
                    this.southWidget = widget;
                    break;
                }
                case WEST: {
                    this.westWidget = widget;
                    break;
                }
                case EAST: {
                    this.eastWidget = widget;
                }
            }
        }
    }

    public void removeWidget(Widget widget) {
        super.removeWidget(widget);
        if (widget == this.northWidget) {
            this.northWidget = null;
        } else if (widget == this.southWidget) {
            this.southWidget = null;
        } else if (widget == this.westWidget) {
            this.westWidget = null;
        } else if (widget == this.eastWidget) {
            this.eastWidget = null;
        } else if (widget == this.centerWidget) {
            this.centerWidget = null;
        }
    }

    public void clear() {
        super.clear();
        this.northWidget = null;
        this.southWidget = null;
        this.westWidget = null;
        this.eastWidget = null;
        this.centerWidget = null;
    }

    protected void doLayout(float left0, float top0, float containerResX, float containerResY) {
        float centerWidth = containerResX;
        float centerHeight = containerResY;
        float centerLeft = left0;
        float centerTop = top0;
        if (this.northWidget != null && (this.northWidget.isVisible() || !this.getInvisibleWidgetsHidden())) {
            this.northWidget.setSize(containerResX, this.northWidget.getHeight());
            this.northWidget.setLocation(left0, top0);
            centerHeight -= this.northWidget.getHeight() + this.getVGap();
            centerTop += this.northWidget.getHeight() + this.getVGap();
        }
        if (this.southWidget != null && (this.southWidget.isVisible() || !this.getInvisibleWidgetsHidden())) {
            this.southWidget.setSize(containerResX, this.southWidget.getHeight());
            this.southWidget.setLocation(left0, top0 + containerResY - this.southWidget.getHeight());
            centerHeight -= this.southWidget.getHeight() + this.getVGap();
        }
        if (this.westWidget != null && (this.westWidget.isVisible() || !this.getInvisibleWidgetsHidden())) {
            this.westWidget.setSize(this.westWidget.getWidth(), centerHeight);
            this.westWidget.setLocation(left0, centerTop);
            centerWidth -= this.westWidget.getWidth() + this.getHGap();
            centerLeft += this.westWidget.getWidth() + this.getHGap();
        }
        if (this.eastWidget != null && (this.eastWidget.isVisible() || !this.getInvisibleWidgetsHidden())) {
            this.eastWidget.setSize(this.eastWidget.getWidth(), centerHeight);
            this.eastWidget.setLocation(left0 + containerResX - this.eastWidget.getWidth(), centerTop);
            centerWidth -= this.eastWidget.getWidth() + this.getHGap();
        }
        if (this.centerWidget != null && (this.centerWidget.isVisible() || !this.getInvisibleWidgetsHidden())) {
            this.centerWidget.setSize(centerWidth, centerHeight);
            this.centerWidget.setLocation(centerLeft, centerTop);
        }
    }

    public BorderLayout(float hgap, float vgap, float borderBottom, float borderRight, float borderTop, float borderLeft) {
        super(borderBottom, borderRight, borderTop, borderLeft);
        if (hgap < 0.0f || vgap < 0.0f) {
            throw new IllegalArgumentException("hgap and vgap must be >= 0");
        }
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public BorderLayout(float hgap, float vgap) {
        this(hgap, vgap, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public BorderLayout(float borderBottom, float borderRight, float borderTop, float borderLeft) {
        this(0.0f, 0.0f, borderBottom, borderRight, borderTop, borderLeft);
    }

    public BorderLayout() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Area {
        NORTH,
        SOUTH,
        WEST,
        EAST,
        CENTER;

    }
}

